/* RxBMW.cmd                                                       */
/* Load RexxUtil, RexxLib, and RexxIni libraries                   */
IF ADDRESS()<>'RXDLG' THEN
  DO
       SAY 'The REXX Dialog package is required to run RxBMW.cmd'
       EXIT
  END

CALL RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
CALL SysLoadFuncs
CALL RxFuncAdd 'RexxLibRegister', 'REXXLIB', 'RexxLibRegister'
CALL RexxLibRegister
CALL RxFuncAdd 'IniLoadFuncs', 'REXXINI', 'IniLoadFuncs'
CALL IniLoadFuncs

/* Trap ERROR and FAILURE                                          */
SIGNAL ON ERROR
SIGNAL ON FAILURE
RXERR 'FULL'

/* =============== Create "Main Window" =================          */
mainWindowTitle = '"Backup My Way"'
numMainWindowControls = 13
initialSelectionDone = 0
curDir = Directory()
cfgFile = curDir'\RxBMW.cfg'
histFile = curDir||'\RxBMW.hst'
logger = curDir||'\RxBMWlog.cmd '
execFile = curDir||'\RxBMWex.cmd'
CRLF = '0D0A'x
TAB  = '09'x
/* Get user options from RxBMW.cfg file                         */
CALL configOptions
/* set window size and position. Scan all drives                   */
CALL windowSetup
CALL scanDrives

begin:
/* First control: a LIST box to select a source disk               */
RXTYPE.1 = 'LIST'
RXLABEL.1 = 'Source'
RXFLAGS.1 = ' '
RXINFO.1 = '1 1 160 7'
RXX.1 = 30
RXY.1 = 320
RXVAL.1 = 'LIST1'
LIST1.0 = ' ' /* value returned */
/* load the source drive list with available drives data           */
DO i = 1 TO numDrives
     LIST1.i = drvInfo.i.drvLetter||' '||drvInfo.i.drvLetter.label
END

i = numDrives + 1
LIST1.i = ' '

/* Second control: a LIST box to select a destination disk         */
RXTYPE.2 = 'LIST'
RXLABEL.2 = 'Target'
RXFLAGS.2 = ' '
RXINFO.2 = '1 1 160 7'
RXX.2 = 215
RXY.2 = 320
RXVAL.2 = 'LIST2'
LIST2.0 = ' ' /* value returned */
/* load the target drive list with available drives data           */
DO i = 1 TO numDrives
     LIST2.i = drvInfo.i.drvLetter||' '||drvInfo.i.drvLetter.label
END
i = numDrives + 1
LIST2.i = ' '

/* Third control: a text window to display generated commands      */
RXTYPE.3 = 'TEXT'
RXFLAGS.3 = ' '
RXLABEL.3 = copies('F',60)||'| | |Commands Generated'
RXINFO.3 = '3 1 '
RXX.3 = 30
RXY.3 = 90
RXVAL.3 = ' '

/* Fourth Control: a Text description for fifth -seventh controls  */
RXTYPE.4 = 'TEXT'
RXFLAGS.4 = ' '
RXLABEL.4 = 'Comments or description of backup'
/* Width, Height */
RXINFO.4 = '330 165'
/* X = horizontal position of control on window (in pels)          */
RXX.4 = 400
/* Y = vertical position in pels   */
RXY.4 = 435

/* Fifth control: an Entry control for a comment for history file  */
/* 31 characters max per line                                      */
RXTYPE.5 = 'ENTRY'
RXLABEL.5 = ' '
RXFLAGS.5 = ' '
RXINFO.5 = '1 1 475'
RXX.5 = 400
RXY.5 = 400
RXVAL.5 = 'firstComment'
firstComment.1 = ' '

/* Sixth control: an Entry control for a comment for history file  */
/* 31 characters max per line                                      */
RXTYPE.6 = 'ENTRY'
RXLABEL.6 = ' '
RXFLAGS.6 = ' '
RXINFO.6 = '1 1 475'
RXX.6 = 400
RXY.6 = 370
RXVAL.6 = 'secondComment'
secondComment.1 = ' '

/* Seventh control: an Entry control for a comment for history file  */
/* 31 characters max per line                                      */
RXTYPE.7 = 'ENTRY'
RXLABEL.7 = ' '
RXFLAGS.7 = ' '
RXINFO.7 = '1 1 475'
RXX.7 = 400
RXY.7 = 340
RXVAL.7 = 'thirdComment'
thirdComment.1 = ' '

/* Eigth control: a List box to choose an archiver/backup cmd      */
RXTYPE.8 = 'LIST'
RXLABEL.8 = 'Command to be used'
RXFLAGS.8 = 'INDEX'
RXINFO.8 = '1 1 175 7'
RXX.8 = 30
RXY.8 = 170
RXVAL.8 = 'LIST8'
LIST8.0 = ' ' /* index of item selected, starting at zero */
DO i = 1 TO numPgms
     LIST8.i = title.i
END
i = numPgms + 1
LIST8.i = ' '

/* Ninth control: a radio button to choose formatting option       */
RXTYPE.9 = 'RADIO'
RXLABEL.9 = 'Ask |No |Yes |Format'
RXFLAGS.9 = 'END'
RXINFO.9 = '3 1 75'
RXX.9 = 635
RXY.9 = 185
RXVAL.9 = '1'

/* Tenth control: a push button to start copy                      */
RXTYPE.10 = 'PUSH'
RXFLAGS.10 = 'END'
RXLABEL.10 = ' Start Backup '
RXINFO.10 = '1 1 135'
RXX.10 = 450
RXY.10 = 32
RXVAL.10 = ' '

/* Eleventh control: a push button to view log of backup results      */
RXTYPE.11 = 'PUSH'
RXLABEL.11 = 'View Log'
RXFLAGS.11 = 'END'
RXINFO.11 = '1 1 125'
RXX.11 = 120
RXY.11 = 32
RXVAL.11 = ' '

/* Twelvth control: a MENU                                         */
RXTYPE.12 = 'MENU'
/* Total number of Menus, and REXX variable names for the Headings */
RXINFO.12 = '3 MENU1|MENU2|MENU3'
/* Create a HELP menu too */
RXFLAGS.12 = 'HELP'
/* Menu 1 */
MENU1.0 = 'File'
MENU1.1 = 'Open|2'  /* NOTE: 2 subitems */
MENU1.2 = 'View/Change CMD file'
MENU1.3 = ' '  /* End of Menu 1 */

/* Menu 1, Item 1 subitems */
MENU1.1.1 = 'History'
MENU1.1.2 = 'Config File'

/* Menu 2 */
MENU2.0 = 'Options'
MENU2.1 = 'Available Drives'
MENU2.2 = 'Scan Drives'
MENU2.3 = 'Update Config Options'
MENU2.4 = 'Standalone Drives Window'
MENU2.5 = ' '  /* End of Menu 2 */

/* Menu 3 */
MENU3.0 = 'Tips'
MENU3.1 = ' ' /* End of Menu 3 */

/* Thirteenth control: a radio button to override the selected command */
RXTYPE.13 = 'CHECK'
RXLABEL.13 = 'Ovr'
RXFLAGS.13 = ' '
RXINFO.13 = '1 1 55'
RXX.13 = 555
RXY.13 = 250
RXVAL.13 = ' '

/* Create and display the main Window                              */
/* NOCLOSE since we want to close the window ourselves.            */
RXDLG numMainWindowControls mainWindowTitle 'WINDOWSIZE'  'KEYS|NOCLOSE'
RXHELP 'CREATE' '""' 'RxBMW.hlp'
RXSET mainWindowTitle  3 0  'SIZE' '600 10'
RXSET mainWindowTitle  5 1  'SIZE' '295 8'
RXSET mainWindowTitle  6 1  'SIZE' '295 8'
RXSET mainWindowTitle  7 1  'SIZE' '295 8'
RXSET mainWindowTitle  8 0  'SIZE' '520 8'
CALL clearCmdWindow

/* Wait for user interaction with the controls                     */
more:
RXDLG mainWindowTitle 0

IF RXID = -98 THEN  CALL closeUp

srcDrv = SUBSTR(LIST1.0, 1, 2)
tgtDrv = SUBSTR(LIST2.0, 1, 2)
drvID = Left(srcDrv,1)

IF RXID = 12 THEN  CALL menuSelected
IF initialSelectionDone = 0 THEN  CALL firstTime
IF RXID = 11 THEN  CALL viewLog

/* Get user selection for program to use for backup, and           */
/* for formatting target drive. Then create commands for display   */
IF RXID = 9  THEN
   DO
        CALL copyCMDOption
        CALL overRideCopyCMD
        CALL formatOption
        CALL chkDrvSelection
/* delete any existing Rexx .cmd file which executes the backup commands*/
        gone = DOSDEL(execFile)
        IF RXVAL.9 = '3' THEN
          DO
           CALL logCMD
           CALL crtExecFile 'FORMATYES'
          END
        ELSE
          DO
           formatCMD = 'No Formatting will be done'
           formatCMDout = formatCMD
           CALL logCMD
           CALL crtExecFile 'FORMATNO'
          END

/* display generated commands                                      */
        RXSET mainWindowTitle 3 1  'VAL' formatCMD
        RXSET mainWindowTitle 3 2  'VAL' copyCMD
        RXSET mainWindowTitle 3 3  'VAL' incrCMD
   END

/* start the backup using the generated Rexx .cmd file             */
IF RXID = 10 THEN  CALL startBackup

SIGNAL more


/* SUBROUTINES ================================================    */
/*                                                                 */
firstTime:
/* block all controls if no drive selection was made               */
IF srcDrv = ' ' THEN
  DO
       RXSAY 'Source Drive not selected' '|' 7  mainWindowTitle
       errors = Y
  END
IF tgtDrv = ' ' THEN
  DO
       RXSAY 'Target Drive not selected' '|' 7 mainWindowTitle
       errors = Y
  END
IF errors = Y  THEN
  DO
       errors = N
       SIGNAL more
  END
  ELSE
    initialSelectionDone = 1
RETURN

chkDrvSelection:
/* get the source drive file system                                */
DO i = 1 to numDrives
IF drvInfo.i.drvLetter = srcDrv then
   DO
   srcFsType = drvInfo.i.drvLetter.fileSys
   LEAVE
   END
END
/* get the target drive fileSys and label (for use in formatting)  */
DO i = 1 to numDrives
IF drvInfo.i.drvLetter = tgtDrv then
   DO
   tgtFsType = drvInfo.i.drvLetter.fileSys
   tgtFsVolID = drvInfo.i.drvLetter.label
   LEAVE
   END
END

IF srcDrv = tgtDrv THEN
    DO
       RXSAY 'Source and Target drives cannot be the same. |' 7 mainWindowTitle
       SIGNAL more
    END

/* check source drive for a valid file system                      */
     IF  srcFsType = 'UNKNOWN' THEN
       DO
            RXSAY 'Drive 'srcDrv 'is formatted in an 'srcFsType 'file system, and cannot be read.' '|' 7 mainWindowTitle
            CALL clearCmdWindow
            SIGNAL more
       END
     IF  srcFsType = '' THEN
       DO
            RXSAY 'Drive 'srcDrv 'is not ready' '|' 7 mainWindowTitle
            CALL clearCmdWindow
            SIGNAL more
       END
      IF  tgtFsType = 'UNKNOWN' THEN
        DO
             RXSAY 'Drive 'tgtDrv 'is formatted in an 'tgtFsType 'file system, and cannot be used.' '|' 7 mainWindowTitle
             CALL clearCmdWindow
             SIGNAL more
        END
      IF  tgtFsType = '' THEN
        DO
             RXSAY 'Drive 'tgtDrv 'is not ready' '|' 7 mainWindowTitle
             CALL clearCmdWindow
             SIGNAL more
        END

/* All other srcFsType's are considered readable, since an IFS     */
/* must have been loaded to get the file system type               */
SELECT
     WHEN tgtFsType = 'FAT'   THEN CALL stdFormat
     WHEN tgtFsType = 'HPFS'  THEN CALL stdFormat
     WHEN tgtFsType = 'JFS'   THEN CALL stdFormat
     WHEN tgtFsType = 'UDF'   THEN CALL udfFormat
     OTHERWISE
/* Target drive is read-only, read-write, or formattable           */
     CALL getTgtUse
END  /* select */

RETURN

getTgtUse:
/* lookup how target fileSys is to be used, and set format command */
howUsed = TRANSLATE(IniGet('use', tgtFsType , cfgFile))
SELECT
   WHEN howUsed = 0     THEN CALL notYetImplemented
   WHEN howUsed = 'RO'  THEN CALL preventUse
   WHEN howUsed = 'RW'  THEN CALL preventFormat
   WHEN howUsed = 'FMT' THEN
           DO
             fmtErrorLevel = IniGet('fmtErrLvl', tgtFsType , cfgFile)
             tmpfmtCMD = TRANSLATE(IniGet('format', tgtFsType , cfgFile))
/* substitute in the target drive letter                           */
             tgtDrvpos = POS('TGTDRV', tmpFmtCMD)
             formatCMD = INSERT(tgtDrv, DELSTR(tmpFmtCMD, tgtDrvpos, 6), tgtDrvpos - 1, 2)
           END
OTHERWISE
END  /* select */

RETURN

copyCMDoption:
/* SELECT type of backup command used to save files               */
IF Symbol(LIST8.0) = 'BAD'   THEN
   DO
      RXSAY 'Select a backup command |' 7 mainWindowTitle
      RXSET mainWindowTitle 9 1  'VAL' '1'
      SIGNAL more
   END

i = LIST8.0 + 1
titleCMD = 'Backup Description: ' || IniGet('TITLE', PROGRAM.i, cfgFile)
copyCMD = IniGet('CMD', PROGRAM.i, cfgFile)

/* substitute source drive into copyCMD                           */
copyCMDtemp = TRANSLATE(copyCMD)
srcDrvpos = POS('SRCDRV', copyCMDtemp)
copyCMD = INSERT(srcDrv, DELSTR(copyCMD, srcDrvpos, 6), srcDrvpos - 1, 2)

/* substitute target drive into copyCMD                           */
copyCMDtemp = TRANSLATE(copyCMD)
tgtDrvpos = POS('TGTDRV', copyCMDtemp)
copyCMD = INSERT(tgtDrv, DELSTR(copyCMD, tgtDrvpos, 6), tgtDrvpos - 1, 2)

/* archiveCMD determines if the archive attribute bit will be reset*/
archiveCMD = TRANSLATE(IniGet('ARCHIVE_RESET', PROGRAM.i, cfgFile))
    IF archiveCMD = 'ATTRIBCMD' THEN incrCMD = 'Attrib -a 'srcDrv'\*.* /s '
    IF archiveCMD = 'THECOPYCMD' THEN incrCMD = 'Archive attribute bit reset by the copy command'
    IF archiveCMD = 'NONE' THEN incrCMD = 'Archive attribute bits not changed'

/* minimum errorlevel to cause Rexx .cmd file to end               */
minErrorLevel = IniGet('ERRORLEVEL', PROGRAM.i, cfgFile)
RETURN

logCmd:
/* create commands for logging of formatting, copying,             */
/* archive attribute reset, and comments                           */
sq = "'"
histLogRedirectCMD = ' 1>'curDir'\RxBMW.'drvID'dr 2>&1'
histLogGroupCMD    = "'"'CALL 'logger || copies('-',80)"'"
histLogTitleCMD    = "'"'CALL 'logger titleCMD"'"
histLogFormatCMD   = "'"'CALL 'logger 'Formatting with: '||formatCMD"'"
histLogCopyCMD     = "'"'CALL 'logger 'Copying with: '||copyCMD"'"
histLogIncrCMD     = "'"'CALL 'logger 'Archive Attribute Processing: '||incrCMD"'"

IF (firstComment.1 = ' ') & (secondComment.1 = ' ') & (thirdComment.1 = ' ') THEN
   DO
      firstComment.1 = 'none entered'
      histLogCommentCMD = "'"'CALL 'logger 'Comment: 'firstComment.1"'"
   END
ELSE  histLogCommentCMD = "'"'CALL 'logger 'Comment: 'firstComment.1 ||secondComment.1||thirdComment.1"'"

RETURN

formatOption:
IF RXVAL.9 = '1'  THEN
  DO
       RXSAY 'Should the target drive be formatted ?' '|' 7 mainWindowTitle
       RXSET mainWindowTitle 10 1 'VAL' ' '
       Call clearCmdWindow
       SIGNAL more
  END
/* if here, then RXVAL.9 <> 1, so format option either yes or no   */
RETURN

stdFormat:
/* format for FAT, HPFS, HPFS386, JFS file systems                 */

fmtErrorLevel = 3
IF (tgtFsType <> 'JFS') THEN
formatCMD = 'FORMAT 'tgtDrv' /fs:'tgtFsType ' /p /ONCE /v:"'tgtFsVolID'"'
ELSE
formatCMD = 'FORMAT 'tgtDrv' /fs:'tgtFsType ' /p /v:"'tgtFsVolID'"'
formatCMDout = 'ECHO Y |'||formatCMD
RETURN

udfFormat:
/* format for UDF file system                                      */
fmtErrorLevel = 3
formatCMD = 'FORMAT 'tgtDrv' /fs:'tgtFsType ' /p /v:"'tgtFsVolID'" /F /Y /ONCE'
formatCMDout = 'ECHO Y |'||formatCMD
RETURN

preventUse:
RXSAY 'Drive 'tgtDrv 'cannot be used as a target.'CRLF  'The file system on the drive is 'tgtFsType 'which is Read-only.'  '|' 7 mainWindowTitle
RXSET mainWindowTitle 9 1 'VAL' '1'
CALL clearCmdWindow
SIGNAL more
RETURN

preventFormat:
/* prevent format of this file system                              */
IF RXVAL.9 = '3' THEN
  DO
       RXSAY 'Drive 'tgtDrv  'file system is 'tgtFsType 'which is not formattable by OS/2'  '|' 7 mainWindowTitle
       RXSET mainWindowTitle 9 1 'VAL' '1'
       Call clearCmdWindow
       SIGNAL more
  END
formatCMD = 'No Formatting will be done'
RETURN

notYetImplemented:
/* There is no section in the RxBMW.cfg file for this file system  */
RXSAY 'Drive 'tgtDrv 'has the 'tgtFsType 'file system'CRLF 'Add the file system to the config file.' '|' 7 mainWindowTitle
RXSET mainWindowTitle 9 1 'VAL' '1'
CALL clearCmdWindow
SIGNAL more
RETURN

menuSelected:
/* Perform menu actions                                            */
SELECT
     WHEN RXSUBID = 8 THEN
       DO
/* view history file                                               */
        cmdFile = curDir'\RxBMW.hst'
        IF DosIsFile(cmdFile)= 0  THEN
          DO
           RXSAY 'No history file found |' 7 mainWindowTitle
           SIGNAL more
          END
        ELSE
         ADDRESS 'CMD' 'start /f ' logFileViewer curDir'\RxBMW.hst'
         ADDRESS 'RXDLG'
         SIGNAL more
       END
     WHEN RXSUBID = 9 THEN
       DO
/* edit configuration file                                         */
            ADDRESS 'CMD'  'start /f 'editPgm curDir'\RxBMW.cfg'
            ADDRESS 'RXDLG'
            SIGNAL more
       END
     WHEN RXSUBID = 10 THEN
       DO
/* view/change current CMD file generated by user selections       */
        cmdFile = curDir'\RxBMWex.cmd'
        IF DosIsFile(cmdFile)= 0  THEN
          DO
           RXSAY 'No generated command file found |' 7 mainWindowTitle
           SIGNAL more
          END
         ADDRESS 'CMD' 'start /f ' editPgm curDir'\RxBMWex.cmd'
         ADDRESS 'RXDLG'
         SIGNAL more
       END

     WHEN RXSUBID = 12 THEN CALL driveWindow

     WHEN RXSUBID = 13 THEN
       DO
/* rescan for new drive lists and close and reopen the main window.*/
            CALL scanDrives
            RXDLG mainWindowTitle 4
            SIGNAL begin
       END

     WHEN RXSUBID = 14 THEN
       DO
/* reread the config file and apply changes                        */
            CALL configOptions
            RXDLG mainWindowTitle 4
            initialSelectionDone = 0
            SIGNAL begin
       END

     WHEN RXSUBID = 15 THEN
/* start the separate Available Drives program                     */
       DO
            ADDRESS 'CMD'  'start /f RX.EXE ' curDir'\RxBMWdrv.cmd'
            ADDRESS 'RXDLG'
            SIGNAL more
       END

     WHEN RXSUBID = 16 THEN
/* Display/edit the Tips file                                           */
       DO
         ADDRESS 'CMD' 'start /f ' editPgm curDir'\RxBMWtip.txt'
         ADDRESS 'RXDLG'
         SIGNAL more
       END

     OTHERWISE
       RXSAY 'Group = 'RXID 'Menu = 'RXSUBID '|' 7
     SIGNAL more

END  /* select */
RETURN

viewLog:
/* View the results of the backup                                  */
logFile = curDir'\RxBMW.'drvID'dr'
IF DosIsFile(logFile)= 0  THEN
    DO
    RXSAY 'No backup log exists for drive 'srcDrv  '|' 7 mainWindowTitle
    SIGNAL more
    END
ADDRESS 'CMD' 'start /f ' logFileViewer' ' logFile
ADDRESS 'RXDLG'
RXSET mainWindowTitle 11 1 'VAL' ' '
SIGNAL more
RETURN

configOptions:
/* load general configuration options from RxBMW.cfg file          */
numPgms = IniGet('numProgs', 'General' , cfgFile)
/* get Titles of backup commands to load into List box             */
DO i = 1 TO numPgms
title.i = IniGet('TITLE', PROGRAM.i, cfgFile)
END
/* window position coordinates if window centering is not desired  */
xpixel = IniGet('xpixel', 'WINDOW', cfgFile)
ypixel = IniGet('ypixel', 'WINDOW', cfgFile)
/* editor and log viewer programs                                     */
editPgm = IniGet('editor', 'General', cfgFile)
logFileViewer = IniGet('viewer', 'General', cfgFile)
/* view the format and copy commands as they are processed, or not */
frontORback = TRANSLATE(IniGet('cmdWindow', 'General', cfgFile))
/* Get option to label NFS drives with remote mount point          */
nfsLabels = TRANSLATE(IniGet('useNFSLabels', 'General', cfgFile))

RETURN

startBackup:
/* Start the backup */
IF Symbol(LIST8.0) = 'BAD'   THEN
   DO
      RXSAY 'Select a backup command |' 7 mainWindowTitle
      RXSET mainWindowTitle 9 1  'VAL' '1'
 SIGNAL more
   END
IF RXVAL.9 = '1'  THEN
  DO
       RXSAY 'Should the target drive be formatted ?' '|' 7 mainWindowTitle
       RXSET mainWindowTitle 10 1 'VAL' ' '
       Call clearCmdWindow
       SIGNAL more
  END

ADDRESS 'CMD' 'start /'frontORback ' /c' execFile
/* clear the displayed commands and controls                       */
RXSET mainWindowTitle 5 1 'VAL' ' '
RXSET mainWindowTitle 6 1 'VAL' ' '
RXSET mainWindowTitle 7 1 'VAL' ' '
RXSET mainWindowTitle 9 1 'VAL' '1'
RXSET mainWindowTitle 10 1 'VAL' ' '
CALL clearCmdWindow
SIGNAL more
RETURN

scanDrives:
/*              numDrives                    Number of drives found*/
/*              drvInfo.#.drvLetter          Drive letter, ex. C:  */
/*              drvInfo.#.drvLetter.label    Drive label           */
/*              drvInfo.#.drvLetter.size     Total size in Mbytes  */
/*              drvInfo.#.drvLetter.free     Free space in Mbytes  */
/*              drvInfo.#.drvLetter.used     Used space in Mbytes  */
/*              drvInfo.#.drvLetter.filesys  File system type      */
/*              drvInfo.#.drvLetter.type     Either LOCAL, or REMOTE*/

IF nfsLabels = 'Y' THEN CALL nfsDrvLabels

/* Get list of all drives                                          */
RXDLG '""' 255
localDrives = SysDriveMap('A:' , 'Local')
RXDLG '""' 255
remoteDrives = SysDriveMap('C:' , 'Remote')

allDrives = localDrives ||' '|| remoteDrives
/* Place details in drvInfo compound variable                      */
count = 0
DO   i = 1 TO Words(allDrives)
     count = count + 1
     drvInfo.count.drvLetter = Word(allDrives , i)
     drvFreeSizeLabel = SysDriveInfo(drvInfo.count.drvLetter)
     freeSpace =  Word(drvFreeSizeLabel, 2)
     IF Datatype(freeSpace) <> 'NUM' THEN  freeSpace = 0
     totalSpace = Word(drvFreeSizeLabel, 3)
     IF Datatype(totalSpace) <> 'NUM' THEN totalSpace = 0
     indexOfLabel =  WordIndex(drvFreeSizeLabel, 4)
     IF indexOfLabel <> 0 THEN
     drvInfo.count.drvLetter.label = STRIP( SUBSTR(drvFreeSizeLabel, indexOfLabel), 'T')
     ELSE
         DO
            IF totalSpace = 0 THEN drvInfo.count.drvLetter.label = '**not ready**'
            ELSE drvInfo.count.drvLetter.label = ' '
         END
     drvInfo.count.drvLetter.fileSys = Dosfilesys(drvInfo.count.drvLetter)
/* get label for NFS drives - use the last 11 characters of        */
/* the NFS server mountpoint specified in the mount command        */
     IF (drvInfo.count.drvLetter.fileSys = 'NFS') & (nfsLabels = 'Y') THEN
      DO k = 1 to nfsData.0
           IF drvInfo.count.drvLetter = nfsData.k.drv
           THEN drvInfo.count.drvLetter.label = nfsData.k.drv.alias
      END

     IF drvInfo.count.drvLetter.fileSys = 'UNKNOWN' THEN
       DO
            drvInfo.count.drvLetter.size = 0.0
            drvInfo.count.drvLetter.free = 0.0
            drvInfo.count.drvLetter.used = 0.0
       END
       ELSE
         DO
            drvInfo.count.drvLetter.size =  totalSpace
            drvInfo.count.drvLetter.free =  freeSpace
            drvInfo.count.drvLetter.used  =  drvInfo.count.drvLetter.size - drvInfo.count.drvLetter.free
         END
     IF (Wordpos(drvInfo.count.drvLetter, remoteDrives) > 0) THEN
       drvInfo.count.drvLetter.type  = 'REMOTE'
       ELSE
         drvInfo.count.drvLetter.type = 'LOCAL'
END
numDrives = count
RETURN

nfsDrvLabels:
/* Use qmount.exe to get data about NFS mounted drives             */
IF  SysSearchPath('PATH', 'QMOUNT.EXE') <> '' THEN
  DO
    ADDRESS 'CMD' 'QMOUNT.exe > NFSlabel.txt'
    fileError = FILESEARCH(NFSlabel.txt, 'NFS'||TAB, 'NFSdata', 'S')
    IF fileError < 0 THEN RETURN
    IF nfsData.0 > 0 THEN
      DO i = 1 TO nfsData.0
        nfsData.i.drv = SUBSTR(nfsData.i, 8, 2)
        tempString = STRIP(SUBSTR(nfsData.i, 16) ,T)
        colonPosition = POS(':', tempString)
        nfsData.i.drv.alias = SUBSTR(tempString, colonPosition + 1)
      END
  END
RETURN

driveWindow:
/* =============== Create "Available Drives" Window ============== */
/* close the main window                                           */
RXDLG mainWindowTitle 4

/* Sized to fit a screen with 800x600 or higher resolution         */
drvWindowTitle = '"Available Drives"'
numDrvWindowControls = 8
rescan:
numDrvLines = numDrives + 2
yMax  = 455
/* set the lower left hand position for the text controls          */
/* (this is font dependent, but not considered in this version)    */
/* yposition = 75 is the lowest value allowed                      */
yPosition = MAX(TRUNC(yMax - (numDrvLines * 14) , 0), 75)

/* first control: a button to return to the main window            */
RXTYPE.1 = 'PUSH'
RXFLAGS.1 = 'END'
RXLABEL.1 = 'Return'
RXINFO.1 = '1 1 125'
RXX.1 = 510
RXY.1 = 32
RXVAL.1 = ' '

/* second control: a button to scan the drives again               */
RXTYPE.2 = 'PUSH'
RXFLAGS.2 = 'END'
RXLABEL.2 = 'UPDATE'
RXINFO.2 = '1 1 125'
RXX.2 = 310
RXY.2 = 32
RXVAL.2 = ' '

/* third control: a text window to display drive letter & Label    */
RXTYPE.3 = 'TEXT'
RXFLAGS.3 = 'LEFT'
tempLabel = ' '
RXLABEL.3 = ' '
RXINFO.3 = numDrvLines '1 160'
RXX.3 = 20
RXY.3 = yPosition
RXVAL.3 = ' '

/* fourth control: a text window to display drive capacity         */
RXTYPE.4 = 'TEXT'
RXFLAGS.4 = 'RIGHT'
tempLabel = ' '
RXLABEL.4 = ' '
RXINFO.4 = numDrvLines '1 90'
RXX.4 = 175
RXY.4 = yPosition
RXVAL.4 = ' '

/* fifth control: a text window to display drive free capacity     */
RXTYPE.5 = 'TEXT'
RXFLAGS.5 = 'RIGHT'
tempLabel = ' '
RXLABEL.5 = ' '
RXINFO.5 = numDrvLines '1 90'
RXX.5 = 275
RXY.5 = yPosition
RXVAL.5 = ' '

/* sixth control: a text window to display drive used capacity     */
RXTYPE.6 = 'TEXT'
RXFLAGS.6 = 'RIGHT'
tempLabel = ' '
RXLABEL.6 = ' '
RXINFO.6 = numDrvLines '1 90'
RXX.6 = 375
RXY.6 = yPosition
RXVAL.6 = ' '

/* seventh control: a text window to display drive file system     */
RXTYPE.7 = 'TEXT'
RXFLAGS.7 = 'LEFT'
tempLabel = ' '
RXLABEL.7 = ' '
RXINFO.7 = numDrvLines '1 90'
RXX.7 = 475
RXY.7 = yPosition
RXVAL.7 = ' '

/* eigth control: a text window to display drive location          */
RXTYPE.8 = 'TEXT'
RXFLAGS.8 = 'LEFT'
tempLabel = ' '
RXLABEL.8 = ' '
RXINFO.8 = numDrvLines '1 90'
RXX.8 = 575
RXY.8 = yPosition
RXVAL.8 = ' '

RXDLG numDrvWindowControls drvWindowTitle 'WINDOWSIZE'  'NOCLOSE'

/* load Title and spacer for each field                            */
RXSET drvWindowTitle 3 1 'VAL'  'DRIVE and LABEL'
RXSET drvWindowTitle 4 1 'VAL'  'TOTAL Mb'
RXSET drvWindowTitle 5 1 'VAL'  'FREE Mb'
RXSET drvWindowTitle 6 1 'VAL'  'USED Mb'
RXSET drvWindowTitle 7 1 'VAL'  'FILE SYS'
RXSET drvWindowTitle 8 1 'VAL'  'TYPE   '

RXSET drvWindowTitle 3 2 'VAL' '----------------'
RXSET drvWindowTitle 4 2 'VAL' '---------'
RXSET drvWindowTitle 5 2 'VAL' '--------'
RXSET drvWindowTitle 6 2 'VAL' '--------'
RXSET drvWindowTitle 7 2 'VAL' '--------'
RXSET drvWindowTitle 8 2 'VAL' '-------'

DO i = 1 TO numDrives
     j = i + 2
     RXSET drvWindowTitle 3 j 'VAL'  drvInfo.i.drvLetter||' '||drvInfo.i.drvLetter.label
     RXSET drvWindowTitle 4 j 'VAL'  Format( (drvInfo.i.drvLetter.size / 1024) / 1024 , , 2)
     RXSET drvWindowTitle 5 j 'VAL'  Format( (drvInfo.i.drvLetter.free / 1024) / 1024 , , 2)
     RXSET drvWindowTitle 6 j 'VAL'  Format( (drvInfo.i.drvLetter.used / 1024) / 1024 , , 2)
     RXSET drvWindowTitle 7 j 'VAL'  drvInfo.i.drvLetter.fileSys
     RXSET drvWindowTitle 8 j 'VAL'  drvInfo.i.drvLetter.type
END

drmore:
RXDLG drvWindowTitle 0
IF RXID < 0 THEN  CALL closeUp
/* Close drive window & return to main window                      */
IF RXID = 1 THEN
  DO
       initialSelectionDone = 0
       RXDLG drvWindowTitle 4
       SIGNAL begin
  END

/* Scan for new or updated drives                                  */
IF RXID = 2 THEN
  DO
       CALL scanDrives
       RXDLG drvWindowTitle 4
       SIGNAL reScan
  END

SIGNAL drmore
RETURN

clearCmdWindow:
/* blank out generated commands windows                           */
            formatCMD = ' '
            copyCMD = ' '
            incrCMD = ' '
            RXSET mainWindowTitle 3 1 'VAL' formatCMD
            RXSET mainWindowTitle 3 2 'VAL' copyCMD
            RXSET mainWindowTitle 3 3 'VAL' incrCMD
RETURN

soundPause:
/* add beep and pause to generated Rexx program                    */
          x = LINEOUT(execFile, 'CALL BEEP 500,120')
          x = LINEOUT(execFile, 'CALL BEEP 600,120')
          x = LINEOUT(execFile, 'CALL BEEP 700,120')
          x = LINEOUT(execFile, 'CALL BEEP 800,120')
          x = LINEOUT(execFile, 'PAUSE')
RETURN

crtExecFile:
/* create the RxBMWex.cmd file to execute all backup commands       */
ARG formatParm
     x = LINEOUT(execFile, '/* RxBMWex.cmd   generated by RxBMW.cmd */')
     x = LINEOUT(execFile, 'CALL RxFuncAdd '''RexxLibRegister''', '''REXXLIB''', '''RexxLibRegister'''')
     x = LINEOUT(execFile, 'CALL RexxLibRegister')
     x = LINEOUT(execFile, '''@ECHO OFF''')
     x = LINEOUT(execFile, 'xx = TIME(reset)')
     x = LINEOUT(execFile,  'rcSave = 0')
     x = LINEOUT(execFile,  histLogGroupCMD)
     x = LINEOUT(execFile,  histLogTitleCMD)
     x = LINEOUT(execFile,  histLogCommentCMD)
     x = LINEOUT(execFile, 'x = DOSDEL('''curDir'\RxBMW.'drvID'dr'')')
IF formatParm = 'FORMATYES' THEN
   DO
     aLine = '''Formatting with: '||formatCMD||''''
     x = LINEOUT(execFile, 'SAY 'aLine )
     x = LINEOUT(execFile,  histLogFormatCMD)
     x = LINEOUT(execFile,  "'"formatCMDout"'")
     x = LINEOUT(execFile, 'IF RC >= 'fmtErrorLevel' THEN CALL formatFailed ')
   END
IF formatParm = 'FORMATNO' THEN
   DO
     x = LINEOUT(execFile,  histLogFormatCMD)
     x = LINEOUT(execFile,  'SAY '''formatCMDout'''')
   END
     x = LINEOUT(execFile, 'SAY '''Backup with ''copyCMD'''')
     x = LINEOUT(execFile,  histLogCopyCMD)
     x = LINEOUT(execFile,  "'"CALL copyCMD||histLogRedirectCMD"'")
     x = LINEOUT(execFile, 'IF RC >= 'minErrorLevel' THEN CALL copyFailed ')
     x = LINEOUT(execFile, 'SAY '''copyCMD ||' finished''')
IF archiveCMD = 'ATTRIBCMD' THEN
   DO
     x = LINEOUT(execFile,  "'"incrCMD"'")
     x = LINEOUT(execFile, 'IF RC >= 1 THEN CALL archiverFailed ')
     x = LINEOUT(execFile, 'SAY ''Archive attribute reset'"'")
   END
     x = LINEOUT(execFile,  histLogIncrCMD)
     x = LINEOUT(execFile, 'ETIME = TRUNC(TIME(elapsed))')
     x = LINEOUT(execFile, 'TMP = 'ETIME' + 0.0000001')
     x = LINEOUT(execFile, 'HH = (' TMP '/ 3600 ) % 1')
     x = LINEOUT(execFile, 'MM = (' TMP '/ 60 - 'HH '* 60 ) % 1')
     x = LINEOUT(execFile, 'SS = ( 'TMP '- (' MM' * 60 ) - (' HH' * 3600 ) ) % 1')
     x = LINEOUT(execFile, 'TIME_FORMAT = right( 'hh', 2, 0 )|| "h : " || right( 'mm', 2, 0 )|| "m : " || right( 'ss', 2, 0 )|| "s "')
     x = LINEOUT(execFile,  '''CALL 'logger 'Elapsed time was: '''TIME_FORMAT )
IF frontORback = 'F' THEN
   DO
     x = LINEOUT(execFile,  'SAY ''Elapsed time was: '''TIME_FORMAT)
     CALL soundPause
   END
ELSE
     x = LINEOUT(execFile,  '''START /PM CMD /C RxBMWmsg.cmd 0, '''TIME_FORMAT '')
     x = LINEOUT(execFile,  'EXIT')
     x = LINEOUT(execFile, '/* Routines -------------------------------------- */')
     x = LINEOUT(execFile,  'formatFailed:')
     x = LINEOUT(execFile,  'rcSave = RC' )
     x = LINEOUT(execFile, 'SAY ''Format failed. Return code was ''rcSave')
     x = LINEOUT(execFile,  '''CALL 'logger ' Format failed. Return code was ''rcSave')
IF frontORback = 'F' THEN CALL soundPause
ELSE
     x = LINEOUT(execFile,  '''START /PM CMD /C RxBMWmsg.cmd 1, 0, '''rcSave'')
     x = LINEOUT(execFile,  'EXIT')
     x = LINEOUT(execFile,  'copyFailed:')
     x = LINEOUT(execFile,  'rcSave = RC' )
     x = LINEOUT(execFile, 'SAY ''Copy command failed. Return code was ''rcSave')
     x = LINEOUT(execFile,  '''CALL 'logger ' File copy failed. Return code was ''rcSave')
IF frontORback = 'F' THEN CALL soundPause
ELSE
     x = LINEOUT(execFile,  '''START /PM CMD /C RxBMWmsg.cmd 2, 0, '''rcSave'')
     x = LINEOUT(execFile,  'EXIT')
     x = LINEOUT(execFile,  'archiverFailed:')
     x = LINEOUT(execFile,  'rcSave = RC' )
     x = LINEOUT(execFile, 'SAY ''Reset of Archive attribute failed. Return code was ''rcSave')
     x = LINEOUT(execFile,  '''CALL 'logger 'Archive command failed. Return code was ''rcSave')
IF frontORback = 'F' THEN CALL soundPause
ELSE
     x = LINEOUT(execFile,  '''START /PM CMD /C RxBMWmsg.cmd 3, 0, '''rcSave'')
     x = LINEOUT(execFile,  'EXIT')
     x = LINEOUT(execFile)

RETURN

overRideCopyCMD:
/* check if copy command is to be modified                         */

IF RXVAL.13 = 1 THEN
     DO
       RXSET mainWindowTitle 13 1 'VAL' ' '
       CALL chgWindow
     END
RETURN

chgWindow: PROCEDURE EXPOSE copyCMD
/* Allow changes to the copy cmd selected                          */
chgWindowTitle = '"Modify Copy Command"'
numChgWindowControls = 3
chgWindowSize = '700 75 22 80'

/* first control: an entry control to edit the copy command        */

RXTYPE.1 = 'ENTRY'
RXLABEL.1 = ' '
RXFLAGS.1 = ' '
RXINFO.1 = '1 1 275'
RXX.1 = 10
RXY.1 = 10
RXVAL.1 = 'first25'
first25.1 = SUBSTR(copyCMD, 1, 25)

/* second control: an entry control to edit the copy command        */
RXTYPE.2 = 'ENTRY'
RXLABEL.2 = ' '
RXFLAGS.2 = ' '
RXINFO.2 = '1 1 275'
RXX.2 = 290
RXY.2 = 10
RXVAL.2 = 'remaining'
      IF LENGTH(copyCMD)> 25 THEN remaining.1 = SUBSTR(copyCMD, 26)
      ELSE remaining.1 = ' '

/* third control: a button to close the edit window               */
RXTYPE.3 = 'PUSH'
RXFLAGS.3 = 'END'
RXLABEL.3 = 'Save'
RXINFO.3 = '1 1 75'
RXX.3 = 600
RXY.3 = 12
RXVAL.3 = ' '


RXDLG numChgWindowControls chgWindowTitle 'CHGWINDOWSIZE'  'MODAL|NOCLOSE'
RXSET chgWindowTitle  1 1  'SIZE' '275 10'
RXSET chgWindowTitle  2 1  'SIZE' '275 10'
chgMore:

RXDLG chgWindowTitle 0

/* prevent close of change window via the system menu */
IF RXID = -98 THEN SIGNAL chgMore
else
IF RXID = 3 THEN
    DO
       copyCMD = first25.1 ||remaining.1
       RXDLG chgWindowTitle 4
    END
RETURN

windowSetup:
/* Window size & position is: 'width height xpos ypos' (in pixels) */
/* get the current resolution                                      */
   parse value GetDisplayResolution() with ,
         xResolution yResolution ColorDepth resolutionChangePending
IF xResolution < 800 | yResolution < 600 then do
RXSAY 'The display resolution is 'xResolution'x'yResolution
RXSAY 'RxBMW requires at least '||CRLF|| '800x600 resolution for proper display'  '|' 7 mainWindowTitle
end
winWidth  = 725
winHeight = 540
IF (xpixel = 0) & (ypixel = 0)  THEN
     DO
      xpos = Trunc((xResolution - winWidth) / 2)
      ypos = Trunc((yResolution - winHeight) / 2)
     END
ELSE
     DO
     xpos = xpixel
     ypos = ypixel
     END
windowSize = winWidth winHeight xpos ypos
RETURN

GetDisplayResolution: PROCEDURE
/* taken from REXX tips & Tricks                                   */
/* function: Get the current display resolution                    */
/* call:     GetDisplayResolution                                  */
/* returns:  xValue yValue depth changePending                     */
/* where:    xValue - horizontal size                              */
/*           yValue - vertical size                                */
/*           depth  - colorDepth                                   */
/*           changePending - 1 = the resolution was changed but no */
/*                               reboot occurred until now         */
/*                           0 = the resolution is active          */
/* note:  unknown1 and unknown2 are unknown values in the INI file */
/*        entry (see below).                                       */
/*        This routine needs the REXXUTIL function SYSINI and the  */
/*        subroutine LSB2MSB                                       */
/* init the return code                                            */
PARSE VALUE 0 0 0 0 WITH xValue yValue colorDepth changePending

SIGNAL ON syntax name GetDisplayValueError
/* get the current resolution                                      */
resolutionEntryInBin = SysIni("USER", "PM_DISPLAYDRIVERS", "DEFAULTSYSTEMRESOLUTION")
/* check, if a resolution change is pending                        */
resolutionChangePending = SysIni("USER", "PM_DISPLAYDRIVERS", "RESOLUTION_CHANGED")
    if resolutionChangePending = "1" || "00"x then
      resolutionChangePending = 1
    else
      resolutionChangePending = 0

/* convert the value into a hex string                             */
resolutionEntryInHex = c2x(resolutionEntryInBin)
PARSE VAR resolutionEntryInHex  1 xValue  9 yValue  17 ColorDepth  25 unknown1  33 unknown2

/* convert the values into decimal values                          */
xValue     = x2d(LSB2MSB( xValue ))
yValue     = x2d(LSB2MSB( yValue ))
ColorDepth = x2d(LSB2MSB( ColorDepth ))

/* not returned or used in this version                            */
unknown1   = x2d(LSB2MSB( unknown1 ))
unknown2   = x2d(LSB2MSB( unknown2 ))

/* this label is only used by the local error handler              */
GetDisplayValueError:

RETURN xValue yValue colorDepth resolutionChangePending

LSB2MSB: PROCEDURE
/* taken from REXX tips & Tricks                                   */
/* Converts  WORD or DWORD from LSB MSB format & vice versa        */
/* call:     LSB2MSB inputHexString                                */
/* where:    inputHexstring - input value as hexstring             */
/*                            (e.g. "3412", "78563412")            */
/* output:   value in MSB format as hexstring                      */
/*           (e.g. "1234", "12345678")                             */
   HexZiffer = arg(1)                                     /* v3.00 */
   Len = Length(HexZiffer)                                /* v3.00 */
   If (Len // 2) then                                     /* v3.00 */
      HexZiffer = Right(HexZiffer, Len + 1, '0')          /* v3.00 */
RETURN strip(translate("12345678", HexZiffer, "78563412"))/* v3.00 */


closeUp:
/* Did user click upon the CLOSE ICON? If so, then                 */
/* Unload RexxLib, RexxIni and then EXIT                           */
CALL IniDropFuncs
CALL RexxLibDeregister
EXIT
RETURN

failure:
/* NOTE: the variable RC contains the returned error message, not  */
/* a number, unless we use RXERR to set up Rexx Dialog to return   */
/* error numbers instead.                                          */
/* Because we used the default severity level, Rexx Dialog already */
/* displayed this error message to the enduser                     */
EXIT

error:
EXIT
