/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*    HISTORY
*     APR 1999 Paul Elliott               Use open class library to determine if file is directory
*     APR 1999 Paul Elliott               DISABLED causes exception at startup.
*/
#include "isdir.hpp"
#include "iexcbase.hpp"

// the code below should work but it does not.
// it causes an exception at start time.
// message box reads.
// UIL0274: Number of bitmap planes is not 1.
// message box has retry and cancel buttons.
// if anyone can tell the reason for this exceptions
// please contact Paul Elliottt pelliottt@io.com
// new code if it worked used new Open class library
#if ( __IBMCPP__  >= 400 )                             // begin new code
#include <ifilesys.hpp>

// returns true if indicated file is determined to be a directory.
Boolean IsDir(const IString& str)
{
   try {
      IFileSystemEntity file_system_ent(str);
      return file_system_ent.isA( IDirectory::kKind );
   }
   catch(IException& exc)
   {
      return false;
   };
}
#else
                                  // end new code
                                  // comment out old code
#include <sys\types.h>
#include <sys\stat.h>

// returns true if indicated file is determined to be a directory.
Boolean IsDir(const IString& str)
{
     struct stat our_stat;
     if ( stat( str, &our_stat) ) return false;

     return ( ( our_stat.st_mode & S_IFDIR) ? true : false );
};
#endif                            // comment out old code