/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998,1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*    HISTORY
*     APR 1999 Paul Elliott               Check for unknown exception is not needed with IBMCPP V40
*/
#include "listrun.hpp"          // declares DisplayFile function
#include "list.hpp"             // declares list frame object.
#include "listthrd.hpp"         // list thread starter.
#include "timeshow.hpp"         // show a window for a while.
#include "exwmbox.hpp"         // Message box exception handler for a window.

#include <stdlib.h>

#include <istring.hpp>
#include <ifiledlg.hpp>

#include "listpm.h"
#include "IsDir.hpp"

#if __TOS_OS2__
#define INCL_WINERRORS
#include <pmerr.h>
#endif


// This code is is called to display a file in a frame window
// on the current thread!
void DisplayFile( IString file )
{
   ExcWinMsgBox       embox;      // message box exception function.

   // handle excetion on windows.
   IWindow::setExceptionFunction( &embox );

   try
   {

      // if we have been asked to list a directory.
      if ( IsDir(file) )
      {
          // space for the fullfile name in the dialog.
          char fullfile[_MAX_PATH];

          // create the fullpath of the current file.
          _fullpath(fullfile,file,sizeof(fullfile));

          // space to store the parts of the current file.
          char drive[_MAX_DRIVE],dir[_MAX_DIR],fname[_MAX_FNAME],ext[_MAX_EXT];

          // split the file into parts.
          _splitpath(fullfile,drive,dir,fname,ext);

          // space to store desired file
          char usepath[_MAX_PATH];

          // make a wild card file path.
          _makepath(usepath,drive,dir,"*","");


          // settings for the dialog.
          IFileDialog::Settings fsettings;

          // set files to chose from. all
          fsettings.setFileName( IString(fullfile) + "\\*" );

          // set the initial drive discovered.
          fsettings.setInitialDrive(drive);

          // set the title of this dialog.
          fsettings.setTitle(STR_TITLEREPLACE);

          // This is an open dialog, choose amoung existing files.
          fsettings.setOpenDialog();


          // returned OK, is it directroy name of file which is chosen.
          Boolean is_dir , ok ;
          IString chosen_file;

          do
          {
             // create the dialog.
             IFileDialog dlg( IWindow::desktopWindow(),
                IWindow::desktopWindow(),
                IFileDialog::defaultStyle() | IFileDialog::multiSelection ,
                fsettings);
             // constructor will return when dialog has run to completion.

             ok =  dlg.pressedOK();

             if ( ok ) chosen_file = dlg.fileName();

             // requested file is a directory.
             is_dir =  dlg.pressedOK() && IsDir( dlg.fileName() ) &&
                       ( dlg.selectedFileCount() == 1 ) ;

             if (is_dir) fsettings.setFileName( ( chosen_file + "\\*" ) );
             else if ( ok)
             {
                 // for each file selected by the dialog.
                 for(int i=0; i< dlg.selectedFileCount() ; i++)
                 {

                    // start a whole new thread to handle the new frame.
                    // the new ListThreadFn will be stored in a managed pointer
                    // and will be destroyed when the thread exits!
                    IThread list ( new ListThreadFn ( dlg.fileName(i) ) );
                 };
                 return;
             };

          } while ( is_dir );
      };

      // display copyright;
      {
           IFrameWindow copy(DLG_COPYRIGHT);
           copy.setFocus();
           // display for 1/2 second.
           TimShow(copy,500);
      };


      // declare frame window which displays file
      ListFrame list(file);

      // process messages on this thread.
      IThread::current().processMsgs();
   }


   // catch exceptions that might have been thrown when showing frame.
   catch(IException& exc)
   {
      long error = exc.errorId();
      #ifdef DEBUG
      const char * exctext = exc.text();
      for ( int i=0; i < exc.locationCount() ; i++)
      {
         const IExceptionLocation & loc = * exc.locationAtIndex(i);
         const char * file_name = loc.fileName();
         const char * function_name = loc.functionName();
         long ln = loc.lineNumber();


         // set debugger break point here for debugging.
         int k=i;
      };
      int kk=__IBMCPP__;
      #endif // DEBUG
      switch (error)
      {
      //#if __TOS_OS2__
      //case PMERR_INVALID_HACCEL:     // I do not know why this exception happens
      //  return;       // but it must be ignored to avoid error message.
      //  break;
      //#endif

        default:
          // display exception in error message.
          IMessageBox ( IWindow::desktopWindow() )
            .show(exc);
      };
      throw;
   };

};
