/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*    HISTORY
*     APR 1999 Paul Elliottt         NOOP OS/2  specific code.
*/

// If not OS/2 then noop OS specific task list call.
#if ( __TOS_OS2__ )
#define INCL_WINSWITCHLIST 1
#include <pmshl.h>
#include <os2.h>
#endif

#include "switch.hpp"
#include <string.h>


// If not OS/2 then noop OS specific task list call.
#if ( __TOS_OS2__ )


unsigned long changeSwitch(int hwnd,int pid,const char * str)
{
   HWND shwnd = WinQuerySwitchHandle( hwnd, pid );

   SWCNTRL    swctlSwitchData;  /*  Switch control data. */
   ULONG rc = WinQuerySwitchEntry( shwnd , & swctlSwitchData);

   if ( rc ) return rc;

   strncpy( swctlSwitchData.szSwtitle , str , MAXNAMEL + 4 - 1 );

   rc = WinChangeSwitchEntry( shwnd, &swctlSwitchData );

   return rc;

};
#else
unsigned long changeSwitch(int hwnd,int pid,const char * str)
{
   return 0;
};
#endif
