/*  Spike.c  */

/*  We need to include the presentation manager prototypes  */
#define INCL_PM

/*  Include os2 prototypes  */
#include <os2.h>

/*  Everything includes standard stuff  */
#include <stdlib.h>
#include <stdio.h>

/*  We need memory allocation and stirng prototypes  */
#include <malloc.h>
#include <string.h>

int main(int argc, char **argv)
{
	HAB hab;
	HMQ hmq;
	char SpikeFile[CCHMAXPATH];

	/*  Set up a default filename in case none was passed  */
	strcpy(SpikeFile,"SpikeFile");
	if(argc > 1) {
		/*  if we got a filename as a command parameter, use it instead  */
		strcpy(SpikeFile,argv[1]);
	}
	/*  All pm programs need an anchor block  */
	hab=WinInitialize(0);
	if(hab != 0) {
		/*  A pm program needs a message que, even if it's not gonna be used */
		hmq=WinCreateMsgQueue(hab,0);
		if(hmq != 0) {
			/*  Open the clipboard  */
			if(WinOpenClipbrd(hab)) {
				PSZ Handle;
				/*  Get a pointer to the plain text in the clipboard  */
				Handle=(PSZ)WinQueryClipbrdData(hab,CF_TEXT);
				if(Handle != NULL) {
					PSZ ThisText;
					FILE *f;
					/*  We got some text ok, so copy it into local storage  */
					ThisText=malloc(strlen(Handle)+2);
					strcpy(ThisText,Handle);
					/*  Open the file in append mode */
					f=fopen(SpikeFile,"ab");
					if(f != NULL) {
						/*  Write out a separator  */
						fprintf(f,"\n+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+\n");
						/*  Now write out the stuff that came from the clipboard  */
						fwrite(ThisText,1,strlen(ThisText),f);
						/*  and finally we close the file  */
						fclose(f);
					}
					/*  free the memory we allocated  */
					free(ThisText);
				}
				/*  Close the clipboard  */
				WinCloseClipbrd(hab);
			}
			/*  Destroy the message que we never used  */
			WinDestroyMsgQueue(hmq);
		}
		/*  Clean up the pm instance  */
		WinTerminate(hab);
		/*  Return success  */
		return 0;
	}
	/*  Return failure  */
	return 1;
}
