/*
InJoy log analyzer
 1998 - 2000 by Charles H McKinnis,  Sandia Park, NM (USA) 04 Feb 2000
mckinnis@attglobal.net

REXX Program to extract and totalize monthly time-ons by
analyzing the InJoy dialer log
*/
Trace 'N'
version = '7.1'
what_r_we = 'IJOYLOG  v'||version ' 1998 - 2000 by Charles H McKinnis'
irc = 0                                        /* ijoylog return code */

If Rxfuncquery('SysDropFuncs') Then
   Do
      Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call SysLoadFuncs
   End

If Rxfuncquery('RxExtra') Then
   Do
      Call Rxfuncadd 'RxExtra', 'RxExtras', 'RxExtra'
      Call RxExtra 'LOAD'
   End

/* Where are we ? */
Parse Source . . install_path .
install_path = Filespec('D',install_path) || Filespec('P',install_path)
ini_file = install_path || 'INETLOG.INI'
cfg_file = install_path || 'inetcfg.cfg'
cfg_save = install_path || 'inetcfg.sav'
save_path = Directory()
our_path = Strip(install_path, 'T', '\')
our_path = Directory(our_path)
Parse Upper Arg otherparms

If Wordpos('/PMREXX', otherparms) > 0 Then
   pmrexx = 1
Else
   pmrexx = 0

Call Initialize_parms

If irc = 0 Then
   Call Analyze_logfile   /* gets, calculates, totalizes connect times. 
                                        Mostly a bunch of conditionals with a Call to a
                                        data-formatting routine. All is stored in
                                        variables for output all at once */

If irc = 0 Then
   Call Outputter        /* Outputs everything to console and to disk */

irc = Cleanup(irc)                                           /* Exits */
Return irc

Analyze_logfile:
trace_save = Trace('N')
/* Now find all lines in connect.log that contain the key_phrase
   string.  A typical line generated in the connect.log after
   disconnect is:
     DATE 21.02.1998, START 10:54:25, END 11:33:30, DURATION 39  min, 2345  sec
   which we would parse as follows:
	'DATE' date ','  . 'END' word2 ',' . 'min,' connect_time 'sec' */

/* this section will read through the connection log files
   data and assign account information and userid to each
   connection log record */
line. = ''
line.0 = 0
Do m = 1 To Words(injoy_logs)
   log_file = Word(injoy_logs, m)
   injoy_acct = Word(injoy_accts, m)
   injoy_user = Word(injoy_users, m)
   last_time.injoy_acct.injoy_user = Word(injoy_times, m)

   lrc = SysFileSearch(key_phrase, log_file, 'temp.')

   If lrc <> 0 | temp.0 < 1 Then
      Iterate                        /* the log may have been cleared */

   Do i = 1 To temp.0
      j = line.0 + 1
      line.j = Space(Injoyformat(temp.i) injoy_acct injoy_user)
      line.0 = j
   End
End

/* this is a great way to sort the entries */
Call RxSort 'line.', 'A'

Do i = 1 To line.0
   Parse Var line.i time_stamp connect_time acctid userid .
   acctid = Strip(acctid)
   userid = Strip(userid)
   connect_time = Strip(connect_time)
   year = Substr(time_stamp, 2, 4)
   t_yr = year
   mm = Substr(time_stamp, 6, 2)
   dd = Substr(time_stamp, 8, 2)
   mins = connect_time % 60                            /*... and mins */
   secs = connect_time - (mins * 60)                 /*...and seconds */
   /* Calculate time_on for that connection */
   time_on = (mins + (1/60)*secs)
   If time_stamp > last_time.acctid.userid Then
      Call Monthly_update

   If old_d = 0 Then
      Do                            /* for very first connection line */
         old_m = mm
         old_d = dd
         old_y = year
         signons_each_day = 1                           /* reset to 1 */
         signons_each_month = 1
         /* This and next one are timeons in minutes */
         daily_time_on = time_on
         monthly_time_on = time_on
      End

   Else         /* continue to accumulate times if same month and day */
      If old_m = mm & old_d = dd & month <> 0 Then
      Do
         old_y = year
         signons_each_day = signons_each_day + 1
         signons_each_month = signons_each_month + 1
         daily_time_on = daily_time_on + time_on
         monthly_time_on = monthly_time_on + time_on
      End

   Else                                      /* new day of same month */
      If old_m = mm & old_d <> dd Then
      Do
         Call Prepare_data
         dcounter = dcounter + 1
         year.dcounter = year
         year.mcounter = year
         dayline.dcounter = year.dcounter month.old_m old_d d_signons d_mins d_hhmmss d_hrs

         old_d = dd
         old_y = year
         signons_each_day = 1            /* Start counting over again */
         signons_each_month = signons_each_month + 1
         daily_time_on = time_on
         monthly_time_on = monthly_time_on + time_on
      End

   Else   /* for any new month, which by definition is also a new day */
      If old_m <> mm & old_m <> 0 Then
      Do
         Call Prepare_data
         dcounter = dcounter + 1
         year.dcounter = old_y
         dayline.dcounter = year.dcounter month.old_m old_d d_signons d_mins d_hhmmss d_hrs

         mcounter = mcounter + 1
         year.mcounter = old_y
         monthline.mcounter = year.mcounter month.old_m m_signons m_mins m_hhmmss m_hrs

         old_m = mm
         old_d = dd
         old_y = year
         signons_each_day = 1
         signons_each_month = 1
         daily_time_on = time_on
         monthly_time_on = time_on
      End

End             /* end of all these If's and Else If's of searching for 
                   key_phrase in all possible lines in the connect.log */

/* Now, since last day and last month is done: */
Call Prepare_data
dcounter = dcounter + 1
year.dcounter = year
dayline.dcounter = year.dcounter month.old_m old_d d_signons d_mins d_hhmmss d_hrs

mcounter = mcounter + 1
year.mcounter = year
monthline.mcounter = year.mcounter month.old_m m_signons m_mins m_hhmmss m_hrs
time_stamp = ''
Do m = 1 To Words(injoy_logs)
   injoy_acct = Word(injoy_accts, m)
   injoy_user = Word(injoy_users, m)
   time_stamp = time_stamp last_time.injoy_acct.injoy_user
End
/* save the last */
injoy_times = Space(time_stamp)
Call Write_config
Trace (trace_save)
return	                                      /* from Analyze_logfile	 */

Injoyformat: Procedure
Parse Arg line
Parse Var line 'DATE' date ',' . 'END' word2 ',' . 'min,' connect_time 'sec' .
date = Strip(date)
Parse Var date dd '.' mm '.' year
word2 = Strip(word2)
/* Extract for time stamp and save */
Parse Var word2 t_hr ':' t_min ':' t_sec
t_yr = year
time_stamp = 'T' || t_yr || mm || dd || t_hr || t_min || t_sec
connect_time = Strip(connect_time)
line = time_stamp connect_time
Return line

Monthly_update:
s_yr = Strip(t_yr)
s_mo = Strip(mm)
If summary.acctid.userid.s_yr.s_mo <> '' Then
   Do
      Parse Var summary.acctid.userid.s_yr.s_mo s_yr s_mo s_stamp s_sess s_min .
      If time_stamp > s_stamp Then
         Do
            s_sess = s_sess + 1
            s_min = s_min + time_on
            summary.acctid.userid.s_yr.s_mo = s_yr s_mo time_stamp s_sess s_min
         End
   End
Else
   Do
      x = monthly.0 + 1
      monthly.x = acctid userid s_yr s_mo
      monthly.0 = x
      summary.acctid.userid.s_yr.s_mo = s_yr s_mo time_stamp '1' time_on
   End
last_time.acctid.userid = time_stamp
Return

Prepare_data:
/* Calculates and formats what is to be put into an output line */

/* Signons per day or month, as, e.g.: '4X' */
d_signons = Format(signons_each_day, sig_x)||'X'
m_signons = Format(signons_each_month, sig_x)||'X'

/* Minutes/day, minutes/month, hrs/day, hrs/month as, e.g.: '105.50 mins or hrs' */
d_mins = Format(daily_time_on, sig_min, 2) 'mins'
d_hrs = Format((daily_time_on/60), sig_hr, 2) 'hrs'
m_mins = Format(monthly_time_on, sig_min, 2) 'mins'
m_hrs = Format((monthly_time_on/60), sig_hr, 2) 'hrs'

/* minutes, seconds per day or month, as 2-digit numbers; hrs can exceed 2 digs */
dy_hh = Format(Trunc(daily_time_on/60),sig_hr)			
dy_mm = Right(Trunc(daily_time_on//60),2,'0')
dy_ss = Right(Trunc(60*((daily_time_on//60) - Trunc(daily_time_on//60))),2,'0')
mo_hh = Format(Trunc(monthly_time_on/60),sig_hr)
mo_mm = Right(Trunc(monthly_time_on//60),2,'0')
mo_ss = Right(Trunc(60*((monthly_time_on//60) - Trunc(monthly_time_on//60))),2,'0')

/* hours, minutes, seconds per day or month, as, e.g.: '1:45:30'*/
d_hhmmss = '  '||dy_hh||':'||dy_mm||':'||dy_ss
m_hhmmss = '  '||mo_hh||':'||mo_mm||':'||mo_ss

Return                                                /* Prepare_data */

Outputter:
/* Now output everything to console and to file */

/* get the screen size; rows is what we are interested in */
Parse Value SysTextScreenSize() With rows cols
Call Stream stdin, 'C', 'OPEN READ'
/* Tell us all */
intro = what_r_we
Call Say_out intro
If otherparms <> '' Then
   Do
      Call Say_out crlf || 'Running with parms =' otherparms
      Call Lineout output_file crlf || 'Running with parms =' otherparms
   End
Call Lineout output_file, intro
intro = crlf || 'Analysis of InJoy log file(s)' injoy_logs '(' || Date() '@' Time() || ')'
Call Say_out intro
Call Lineout output_file, intro
If daily_report Then
   Call Say_out crlf || daily totals
Call Lineout output_file, crlf || daily totals
Do j = 1 To dcounter
   If daily_report Then
      Call Say_out dayline.j
   Call Lineout output_file, dayline.j
   If one_screen_at_a_time & daily_report & \quiet & \pmrexx then			
   If (j - rows + 6) // (rows - 5) = 0 Then
      answer = Say_message('               Press any key to continue...')
End

If one_screen_at_a_time & daily_report & \quiet & \pmrexx then			
If (j - rows + 6) // (rows - 5) > 5 Then
   Do                                   /* If at about 5 lines to end */
      answer = Say_message('   Daily Totals done, press any key for Monthlies...')
      /* If decision is to do a 'Press-Any-Key to continue', reset to 0 */
      j = 0
   End
If \ daily_report Then
   j = 0

/* back up the summary file and delete it */
If RxFileExists(summary_file) Then
   Do
      Parse Var summary_file fname '.' ext
      Address cmd '@COPY' summary_file fname || '.bak > NUL'
      Call SysFileDelete summary_file
   End
rc = File_cmd(summary_file,'W')
acct_user_save = ''

Call RxSort 'monthly.', 'A' /* sort the summary data */

call summary_sample /* get the header information */
/* insert the header info into the summary data */
do k = summary_sample.0 to 1 by -1
   call rxsteminsert 'monthly.', 1, summary_sample.k
end

Do k = 1 To monthly.0
   If Abbrev(monthly.k,'*') Then
      Do                                   /* write comments back out */
         Call Lineout summary_file, monthly.k
         Iterate k
      End
   Parse Var monthly.k acctid userid s_yr s_mo
   acct_user = acctid userid
   Call Lineout summary_file, acctid userid '*' summary.acctid.userid.s_yr.s_mo
   Parse Var summary.acctid.userid.s_yr.s_mo . . . s_sess s_mins
   m_sess = Format(s_sess, sig_x) || 'X'
   m_mins = Format(s_mins, sig_min, 2) 'mins'
   mo_hh = Format(Trunc(s_mins / 60),sig_hr)
   mo_mm = Right(Trunc(s_mins // 60),2,'0')
   mo_ss = Right(Trunc(60 * ((s_mins // 60) - Trunc(s_mins // 60))),2,'0')
   m_hhmmss = '  '||mo_hh||':'||mo_mm||':'||mo_ss
   m_hrs = Format((s_mins / 60), sig_hr, 2) 'hrs'
   a_sess = s_mins / s_sess
   If a_sess < 60 Then
      a_sess = Format(a_sess,2,0) 'mins'
   Else
      a_sess = Format((a_sess / 60),2,2) 'hrs'
   a_sess = '- Ave =' a_sess
   monthline = s_yr month.s_mo m_sess m_mins m_hhmmss m_hrs a_sess
   If acct_user <> acct_user_save Then
      Do
         intro = crlf || 'MONTHLY TOTALS for Account(' || acctid || ') Userid(' || userid || '}'
         Call Say_out intro
         Call Lineout output_file, intro
         acct_user_save = acct_user
      End
   Call Lineout output_file, monthline
   monthline = s_yr month.s_mo m_sess m_hrs a_sess
   Call Say_out monthline
   If one_screen_at_a_time & \quiet & \pmrexx Then
      If (k + j - rows + 6) // (rows - 6) = 0 Then
      answer = Say_message('               Press any key to continue...')
End
rc = File_cmd(summary_file,'C')
finished = crlf || 'End of analysis of InJoy log file(s)'
Call Say_out finished
Call Lineout output_file, finished

Return                                              /* from Outputter */

Initialize_parms:
trace_save = Trace('N')
Trace 'N'
quiet = 0
irc = 0

Do i = 1 To Words(otherparms)
   Parse Value Word(otherparms, i) With key_word '=' key_value
   Select
      When Abbrev(key_word, '/Q') Then
         quiet = 1
      Otherwise Nop
   End
End

Call Read_config

Call Update_config

/* Get full paths for output file and summary file */
output_file = data_path || injoy_output_file
summary_file = data_path || injoy_summary_file
Call Set_monthly_summary

/* initialize variables */
crlf = D2c(13) || D2c(10)               /* carriage return + linefeed */
esc = D2c(27)                                     /* Escape character */
time_stamp = ''                  /* Time stamp of each connect record */

Do i = 1 To 12                                   /* initialize months */
   x = Right(i,2,'0')
   month.x = Word('Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec',i)
End

/* calculated variables
   signons_each_day    Accumulate number of connects daily
   signons_each_month  Accumulate number of connects monthly
   time_on             Time, each connect  (minutes)
   daily_time_on       Accumulated minutes, daily
   monthly_time_on     Accumulated minutes, monthly */

/* More variables: these we initialize as follows: */
old_m = 0                 /* Storage of a 2-digit month (eg 05 = May) */
old_d = 0                                    /* ... and a 2-digit day */
dcounter = 0              /* Counter increments each sign-on in a day */
mcounter = 0	                     /* Same for each sign-on in a month */
monthline. = ''           /* Initialize both of these as null strings */
dayline. = ''       /* These are for monthly and daily output strings */

/* A typical line generated in the default.log upon disconnect looks like
      DATE 20.02.1998, START 16:22:32, END 16:22:33, DURATION 0   min, 1     sec
   We search for a key_phrase using the RexxUtil function SysFileSearch */

key_phrase = 'DATE'                /* Word or phrase we'll search for */

Do i = 1 To Words(injoy_logs)
   If \RxFileExists(Word(injoy_logs, i)) Then
      Do
         Say 'Log file' Word(injoy_logs, i) 'does not exist.'
         Say 'It may have been cleared and will be bypassed.'
      End
   /* make sure that we have control of the log file */
   Else
      Do
         rc = File_cmd(Word(injoy_logs, i), 'W')
         If \ rc Then
            Do Until rc
               Say 'Log file' Word(injoy_logs, i) 'returned' result
               rc = File_cmd(Word(injoy_logs, i), 'C')
               Say 'Unable to open' Word(injoy_logs, i)
               Say 'Press Esc to abort run'
               answer = Say_message('Press any other key to wait 5 seconds')
               If answer = esc Then
                  irc = Cleanup(24)
               Call SysSleep 5
               Call SysCls
               rc = File_cmd(Word(injoy_logs, i), 'W')
            End
      End
   rc = File_cmd(Word(injoy_logs, i), 'C')
End

/* Here is where we Check if the output file exists.  If it does, we
   overwrite it, and if not we create it.  BUT....  we don't want to
   do something stupid like try to erase a vital file or the connect
   logfile... */

/* Backup any output file of the same name if it exists, then erase orig. */
If RxFileExists(output_file) Then
   Do
      Parse Var output_file fname '.' ext
      Address cmd '@COPY' output_file fname||'.bak > NUL'
      Call SysFileDelete output_file
   End

Trace (trace_save)
Return                                            /* Initialize_parms */

Set_monthly_summary:                           /* set monthly summary */
monthly. = ''
monthly.0 = 0
summary. = ''
s_time = 'T00000000000000'
If RxFileExists(summary_file) Then
   Do
      Call RxRead 'data.', summary_file
      Do i = 1 To data.0
         If \ Abbrev(data.i,'*') & data.i <> '' Then
            Do
               Parse Var data.i acctid userid '*' s_yr s_mo s_time s_data
               If s_yr = '' Then
                  Do
                     acctid = 'unknown'
                     userid = 'unknown'
                     Parse Var data.i s_yr s_mo s_data
                  End
               acctid = Strip(acctid)
               userid = Strip(userid)
               s_yr = Strip(s_yr)
               s_mo = Strip(s_mo)
               j = monthly.0 + 1
               monthly.j = acctid userid s_yr s_mo
               monthly.0 = j
               summary.acctid.userid.s_yr.s_mo = s_yr s_mo s_time s_data
            End
      End
      Call RxSort 'monthly.0', 'A'
   End
Else
   s_time = 'T00000000000000'       /* reset timestamp to get updates */
Return                                         /* Set_monthly_summary */

/* read the config file */
Read_config:
trace_save = Trace('N')
Trace 'N'
If RxFileExists(cfg_file) Then            /* do we have a config file */
   input_file = cfg_file
Else
   Do
      If RxFileExists(cfg_save) Then
         input_file = cfg_save
      Else
         Do
            Call Config_sample               /* use the sample values */
            input_file = 'sample'
         End
   End

If input_file <> 'sample' Then
   Call RxRead 'data.', input_file
Else
   Call RxStemCopy 'cfg_sample.', 'data.'
config. = ''
config.0 = data.0
Do i = 1 To data.0
   config.i = data.i
   If Abbrev(data.i, ';') | Abbrev(data.i, '[') Then
      Nop
   Else
      Do
         Parse Var data.i key_id '=' key_value
         key_id = Strip(key_id)
         key_value = "'" || Strip(key_value) || "'"
         Interpret key_id '=' key_value
      End
End
Trace(trace_save)
Return

/* update the config file */
Update_config:
trace_save = Trace('N')
Trace 'N'
/* path to data files */
If data_path = '' Then
   Do
      data_path = install_path || 'data\'
      Call Write_config
   End
/* create the data path sub-directory if needed */
If \RxFileExists(data_path || '*.*') Then
   xrc = SysMkDir(Strip(data_path, , '\'))
/* IBM dialer support */
If ibm_dialer = '' Then
   Do
      Say 'Support the IBM dialer (y/N)?'
      Parse Upper Pull ans .
      key_value = Abbrev(ans, 'Y')
      ibm_dialer = key_value
      Call Write_config
   End
/* InJoy dialer support */
If injoy_dialer = '' Then
   Do
      Say 'Support the InJoy dialer (y/N)?'
      Parse Upper Pull ans .
      key_value = Abbrev(ans, 'Y')
      injoy_dialer = key_value
      Call Write_config
   End

/* process IBM dialer entries */
If ibm_dialer Then
   Do
      /* dialer ini file */
      If ibm_dialer_ini_file = '' Then
         Do
            Say 'Please select your IBM dialer by number'
            Say '   1 - DIALER.EXE (1.67 and below)'
            Say '   2 - TCPDIAL.EXE (1.69 and above)'
            Parse Upper Pull ans .
            Select
               When ans = 1 Then
                  key_value = 'dialer.ini'
               When ans = 2 Then
                  key_value = 'tcpdial.ini'
               Otherwise Do
                  Say 'You did not chose a supported dialer'
                  key_value = ''
               End
            End
            ibm_dialer_ini_file = key_value
            Call Write_config
         End
   End

/* process InJoy dialer entries */
If injoy_dialer Then
   Do
      If injoy_logs = '' Then
         Do
            /* get path to InJoy */
            Say 'Enter the full path to the InJoy Dialer logs or hit enter to quit.'
            Parse Upper Pull ans .
            If ans <> '' Then
               Do
                  /* get all *.log file names */
                  log_path = ans
                  rc = SysFileTree(log_path || '\*.log', 'logs.', 'FO')
                  /* loop through log file names to see the user wants them included */
                  If rc = 0 & logs.0 > 0 Then
                     Do i = 1 To logs.0
                        Say 'Found InJoy log file -' logs.i
                        Say 'Analyze this log (y/N)'
                        Parse Upper Pull ans
                        If Abbrev(ans, 'Y') Then
                           Do
                              injoy_logs = Space(injoy_logs logs.i)
                           End
                     End
                  Else
                     Do
                        Say 'Unable to locate any logs in InJoy log path -' ans
                        Say 'InJoy logs in' ans 'will not be processed.'
                     End
               End
            Else
               Say 'InJoy logs will not be processed'
            injoy_accts = ''
            injoy_users = ''
            injoy_times = ''
            Do i = 1 To Words(injoy_logs)
               joylog = Word(injoy_logs, i)
               joyacct = Word(injoy_accts, i)
               joyuser = Word(injoy_users, i)
               joytime = Word(injoy_times, i)
               If joyacct = '' Then
                  Do
                     Say 'Enter an account id for InJoy log -' joylog
                     Parse Pull joydata
                     injoy_accts = Strip(injoy_accts joydata)
                  End
               If joyuser = '' Then
                  Do
                     Say 'Enter an user id for InJoy log -' joylog
                     Say 'and account id -' joydata
                     Parse Pull joydata
                     injoy_users = Strip(injoy_users joydata)
                  End
               If joytime = '' Then
                  Do
                     joydata = 'T00000000000000'
                     injoy_times = Strip(injoy_times joydata)
                  End
            End
            Call Write_config
         End
   End
Trace(trace_save)
Return

/* write the config file */
Write_config:
trace_save = Trace('N')
Trace 'N'
If RxFileExists(cfg_file) Then            /* do we have a config file */
   Do
      If RxFileExists(cfg_save) Then
         Call SysFileDelete(cfg_save)
      Address cmd '@rename' cfg_file Filespec('N', cfg_save) '> nul'
   End
Do i = 1 To config.0
   If Abbrev(config.i, ';') | Abbrev(config.i, '[') Then
      Nop
   Else
      Do
         Parse Var config.i key_id '=' key_value
         key_id = Strip(key_id)
         config.i = key_id '=' Value(key_id)
      End
End
Call RxWrite 'config.', cfg_file
Trace(trace_save)
Return

Cleanup:
Parse Arg irc
Return irc

Say_out:                             /* performs output to the screen */
Procedure Expose quiet
If quiet Then
   Return
trace_save = Trace('N')
Parse Arg line
Say line
Trace (trace_save)
Return

Say_message:       /* performs message output and returns key entered */
Procedure Expose quiet
trace_save = Trace('N')
Parse Arg msg
Say msg
answer = SysGetKey('NOECHO')
Trace (trace_save)
Return answer

/* performs common Stream commands and returns 1 or a date if successful */
File_cmd: Procedure Expose result
trace_save = Trace('N')
Trace 'N'
Parse Arg file_name, command
command = Translate(command)
Select
   When command = 'X' Then
      Do
         result = Stream(file_name, 'C', 'QUERY EXISTS')
         answer = (result <> '')
      End
   When command = 'C' Then
      Do
         result = Stream(file_name, 'C', 'CLOSE')
         answer = Abbrev(result,'READY') | (result = '')
      End
   When command = 'W' Then
      Do
         result = Stream(file_name, 'C', 'OPEN WRITE')
         answer = Abbrev(result,'READY')
      End
   When command = 'R' Then
      Do
         result = Stream(file_name, 'C', 'OPEN READ')
         answer = Abbrev(result,'READY')
      End
   When command = 'D' Then
      Do
         result = Stream(file_name, 'C', 'QUERY DATETIME')
         If result <> '' Then
            Do
               Parse Var result date time
               date = Dateconv(Translate(date, '/', '-'), 'U', 'S')
               Parse Var time hr ':' min ':' sec
               answer = Strip(date) || Strip(hr) || Strip(min) || Strip(sec)
            End
         Else
            answer = '00000000000000'
      End
   Otherwise answer = 0
End
Trace (trace_save)
Return answer

Summary_sample: Procedure Expose summary_sample.
trace_save = Trace('N')
Trace 'N'
data_queue = INetSmp('summary')
old_queue = Rxqueue('Set', data_queue)
summary_sample.0 = Queued()
Do i = 1 To summary_sample.0
   Parse Pull summary_sample.i
End
rx_queue = Rxqueue('Delete', data_queue)
Trace(trace_save)
Return
