/* Install/UnInstall script for ConfigTool */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL RxFuncAdd  'FastIniStart','FastIni','FastIniStart'
CALL RxFuncAdd  'FastIniEnd','FastIni','FastIniEnd'

CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit

/* End of Install.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY ' '
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'I' THEN CALL InstallMe
    WHEN ans = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN

/* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

PARSE ARG noinstmsg
SAY ' '
SAY noinstmsg
SAY 'Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit

/* End of NoAction */

/* InstallMe - install ConfigTool */

InstallMe:  PROCEDURE

progname = 'ConfigTool 1.3.0'
compname = 'ConfigCompare 1.3.0'
required = 'CFGtool.exe CFGcomp.exe CFGTOOL.DAT CFGTOOL.CHK Cfgbmp32.dll CWRxUtil.dll drusrctl.dll ENGLISH.INI'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||progname||' can not be installed in root directory.'
    SAY 'Create directory for '||progname||', copy files there and start this procedure again.'
    SAY 'Press any key to exit ...'
    ans = SysGetKey('NOECHO')
    Exit
END

CALL SysCls
SAY 'Welcome to '||progname||' Installation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will create Folder "OS/2 System Tools"'
SAY 'and Program objects for '||progname||','
SAY 'Press "Y" to start Installation, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'Installation aborted.'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(required)
    SAY '- '||WORD(required,i)
    IF STREAM(WORD(required,i),'C','QUERY EXISTS') = '' THEN DO
        CALL NoAction WORD(required,i)||' - Missing file. Installation failed!'
    END
END

SAY ' '
SAY 'Checking boot drive'
cfgpath = TRANSLATE(VALUE('PATH',,'OS2ENVIRONMENT'))
bootdrv = SUBSTR(cfgpath,POS(':\OS2\SYSTEM',cfgpath)-1,1)
SAY 'Press Enter if OS/2 boot drive is   '||bootdrv||': ('||WORD(SysDriveInfo(bootdrv||':'),4)||')'
SAY 'or type correct boot drive and press Enter.'
PARSE PULL bootdrive
SELECT
    WHEN STRIP(bootdrive) = '' THEN bootdrive = bootdrv
    OTHERWISE bootdrive = TRANSLATE(LEFT(bootdrive,1))
END
os2ver = SysOS2Ver()
SELECT
    WHEN os2ver = '2.30' THEN myver = 1
    WHEN os2ver = '2.40' THEN myver = 2
    WHEN os2ver = '2.45' THEN myver = 3
    OTHERWISE myver = 2
END

SAY ' '
inifile = 'CFGTOOL.INI'
inikey.1 = 'BackupDir'
inival.1 = Directory()
inikey.2 = 'ColorB'
inival.2 = '#0'
inikey.3 = 'Comment'
inival.3 = '0 1 1 File changed with ConfigTool 1.3.0'
inikey.4 = 'Configuration'
inival.4 = bootdrive||' 3 2 1 2 1 1 '||myver||' 1'
inikey.5 = 'CurrLang'
inival.5 = 'ENGLISH'
inikey.6 = 'FontP'
inival.6 = '9.WarpSans'
inikey.7 = 'General'
inival.7 = '0 0 1 0 0 50 5 1 '||Directory()
inikey.8 = 'Tooltip'
inival.8 = '#255 255 1329.WarpSans3003'
inikey.9 = 'Viewer'
inival.9 = 'View.exe'
inikey.0 = 9

iniRc = FastIniStart(inifile,'IniHandle')
SAY 'Writing values to '||inifile
DO i = 1 TO inikey.0
    CALL SysIni inifile, 'Settings', inikey.i, inival.i
END
CALL SysIni inifile, 'Language', 'ENGLISH', 'English.inf'
iniRc = FastIniEnd('IniHandle')

SAY ' '
InstallDir = Directory()

FoldTitle='OS/2 System Tools'
Icon1=Directory()||'\Folder1.ico'
Icon2=Directory()||'\Folder2.ico'
Icon='ICONFILE='Icon1||';ICONNFILE=1,'||Icon2
Setup='OBJECTID=<GISYSTOOLS_FOLD>;'||Icon||''
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<WP_DESKTOP>',Setup,Action)
SAY FoldTitle||' Folder - '||rc1(dummy)

FoldTitle='Help'
Setup='OBJECTID=<GISYSTOOLS_HELP>'
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<GISYSTOOLS_FOLD>',Setup,Action)
SAY FoldTitle||' Folder - '||rc1(dummy)

title.1 = progname
setup.1 = 'OBJECTID=<CFGTOOL130_PROG>;EXENAME='InstallDir'\CFGtool.exe;ICONFILE='InstallDir'\CFGtool.ico;STARTUPDIR='InstallDir''
title.2 = compname
setup.2 = 'OBJECTID=<CFGCOMP130_PROG>;EXENAME='InstallDir'\CFGcomp.exe;ICONFILE='InstallDir'\CFGcomp.ico;STARTUPDIR='InstallDir''
title.3 = progname||'^Database (INF)'
setup.3 = 'OBJECTID=<CFGTOOL130_DATINF>;EXENAME=View.exe;PARAMETERS='InstallDir'\CFGDAT.INF;STARTUPDIR='InstallDir''
title.0 = 3
DO i = 1 TO title.0
    dummy = SysCreateObject('WPProgram',title.i,'<GISYSTOOLS_FOLD>',setup.i,'U')
    SAY TRANSLATE(title.i,' ','^')||' - '||rc1(dummy)
END
title.1 = progname||'^English manual'
setup.1 = 'OBJECTID=<CFGTOOL130_HLPENG>;EXENAME=View.exe;PARAMETERS='InstallDir'\English.inf;STARTUPDIR='InstallDir''
title.0 = 1
DO i = 1 TO title.0
    dummy = SysCreateObject('WPProgram',title.i,'<GISYSTOOLS_HELP>',setup.i,'U')
    SAY TRANSLATE(title.i,' ','^')||' - '||rc1(dummy)
END

SAY ' '
SAY 'Installation finished. Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit

/* End of InstallMe */

/* UnInstallMe - uninstall ConfigTool */

UnInstallMe: PROCEDURE

progname = 'ConfigTool 1.3.0'
CALL SysCls
SAY 'This is '||progname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will destroy '||progname||' Program objects'
SAY 'Press "Y" to start UnInstall, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'UnInstall aborted.'
END
SAY ' '
SAY 'Destroying '||progname||' Program objects'

CALL SysDestroyObject '<CFGTOOL130_PROG>'
CALL SysDestroyObject '<CFGCOMP130_PROG>'
CALL SysDestroyObject '<CFGTOOL130_DATINF>'
CALL SysDestroyObject '<CFGTOOL130_DATHTM>'
CALL SysDestroyObject '<CFGTOOL130_DATTXT>'
CALL SysDestroyObject '<CFGTOOL130_HLPENG>'
CALL SysDestroyObject '<CFGTOOL130_HLPFRE>'
CALL SysDestroyObject '<CFGTOOL130_HLPRUS>'
CALL SysDestroyObject '<CFGTOOL130_HLPSWE>'

SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||progname||' again, start Install I. Press any key to exit...'
ans = SysGetKey('NOECHO')
Exit

/* End of UnInstallMe */

/* rc1 - return code - SysCreateObject */

rc1:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysCreateObject = 0 THEN rc1 = 'Error'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1

/* End of rc1 */
