/* Update 2 - Slovenian NLS */

IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
SAY 'Ŀ'
SAY 'INI tools Version 1.10                                                       '
SAY 'Update 2 (2000-08-25): Slovenian Language support                            '
SAY ''
SAY ''
IF SysIni('USER','ToolsByGoran','INItoolsWorkDir') = 'ERROR:' THEN DO
    errmsg = 'INI tools are not installed! Please install INI tools (Install.exe).'
    CALL IsError errmsg
END
CALL SysFileTree DIRECTORY()||'\INITOOLS.INI','found','F'
IF found.0 = 0 THEN DO
    errmsg = 'INITOOLS.INI not found in: '||DIRECTORY()||'. Please correct error.'
    CALL IsError errmsg
END
CALL SysFileTree DIRECTORY()||'\INSTALL.INI','found','F'
IF found.0 = 0 THEN DO
    errmsg = 'INSTALL.INI not found in: '||DIRECTORY()||'. Please correct error.'
    CALL IsError errmsg
END
SAY ' '
CALL SysFileTree DIRECTORY()||'\SLOVENIA.INI','found','F'
SELECT
    WHEN found.0 = 0 THEN DO
	dummy = BEEP(400,250)
	SAY 'SLOVENIA.INI not found in: '||DIRECTORY()||'.'
	SAY 'Slovenian Language support will not be installed.'
    END
    OTHERWISE DO
	SAY 'Updating INITOOLS.INI (Slovenian Language support).'
	dummy = SysIni('INITOOLS.INI','Language','SLOVENIA','English.inf')
	IF dummy = 'ERROR:' THEN DO
	    CALL Problem 'SLOVENIA'
	END
	SAY 'Updating INSTALL.INI (Slovenian Language support).'
	dummy = SysIni('INSTALL.INI','INI','LanguageSLOVENIA','English.inf')
	IF dummy = 'ERROR:' THEN DO
	    CALL Problem1 'SLOVENIA'
	END
    END
END
SAY ' '
SAY 'Finished! Press Enter to exit...'
PULL answer
Exit

/* Kraj Update */

Problem:	PROCEDURE

PARSE ARG problang
SAY ''
SAY 'Problem!'
SAY problang||' Language support not added to INI tools.'
SAY 'Open INITOOLS.INI with INI editor and add new Key in Application Language:'
SAY 'Key - '||problang||', Value - English.inf'
Return

Problem1:	PROCEDURE

PARSE ARG problang
SAY ''
SAY 'Problem!'
SAY problang||' Language support not added to INSTALL.INI.'
SAY 'Open INSTALL.INI with INI editor and add new Key in Application INI:'
SAY 'Key - Language'||problang||', Value - English.inf'
Return

IsError:	PROCEDURE

PARSE ARG errmsg
SAY 'Error !!!'
dummy = BEEP(400,250)
SAY errmsg
SAY 'Then run this procedure again.'
SAY ''
SAY 'Press Enter to exit...'
PULL answer
Exit

/* Kraj IsError */