/*******************************************************************/
/*                                                                 */
/* Function:            LAD2ST11                                   */
/*                                                                 */
/* Version:             1.0 (April 30, 1993)                       */
/*                                                                 */
/* Description:         Transfers data from a LAD/2 workgroup      */
/*                      directory into IBM LAN NetView Start 1.1   */
/*                      (Start) migration files.                   */
/*                                                                 */
/* Input:                                                          */
/*        /LADPATH=source pathname of the LAD/2 main directory     */
/*        /CUSTOMER=customer name                                  */
/*        /WGNAME=workgroup name                                   */
/*        /USERNAME=user name                                      */
/*          (optional - if not specified, all the users in the     */
/*          workgroup are migrated)                                */
/*        /OFILE=fully qualified override file name                */
/*          (optional - if not specified, no node, LAN adapter, or */
/*          LAN Server parameters will be overridden)              */
/*        /MIGPATH=target pathname of an existing directory for    */
/*          the generated Start migration files (optional -        */
/*          defaults to the current directory)                     */
/*                                                                 */
/* Output:   IBM LAN NetView Start 1.1 migration files             */
/*                                                                 */
/* Notes:                                                          */
/*        Possible return codes:                                   */
/*           0 - Successful                                        */
/*           1 - Bad or missing parameter                          */
/*           2 - File not found                                    */
/*           3 - Unable to load RexxUtil                           */
/*           4 - Could not find workgroup entry                    */
/*           5 - No users (or clients) found for processing        */
/*           6 - Could not generate one or more migration files    */
/*           7 - Could not find the migration directory            */
/*                                                                 */
/* Dependencies:         RexxUtils (REXX utilities function)       */
/*                                                                 */
/* DISCLAIMER OF WARRANTIES:                                       */
/* The following [enclosed] code is an applet program created by   */
/* the IBM Corporation.  This code is provided "AS IS", without    */
/* warranty or support of any kind.  IBM shall not be liable for   */
/* any damages arising out of the use of this applet code, even if */
/* the users have been advised of the possibility of such damages. */
/* IBM reserves the right to make improvements or changes to this  */
/* applet code at any time without any notice to you.  This applet */
/* can be further copied and redistributed without restriction.    */
/*                                                                 */
/*******************************************************************/

parse upper arg parm.1 parm.2 parm.3 parm.4 parm.5 parm.6 rest

if ((parm.1 = '?') | (parm.1 = '')) then
     do
      say 'LAD2ST11.CMD - Transfers data from a LAD/2 workgroup directory'
      say 'into IBM LAN NetView Start 1.1 (Start) migration files.'
      say ' '
      say 'Parameters:'
      say '   /LADPATH=source pathname of the LAD/2 main directory'
      say '   /CUSTOMER=customer name'
      say '   /WGNAME=workgroup name'
      say '   /USERNAME=user name'
      say '     (optional - if not specified, all the users in the workgroup'
      say '     are migrated)'
      say '   /OFILE=fully qualified override file name'
      say '     (optional - if not specified, no node, LAN adapter,'
      say '     or LAN Server parameters will be overridden)'
      say '   /MIGPATH=target pathname of an existing directory for'
      say '     the generated Start migration files (optional -'
      say '     defaults to the current directory)'
      say ' '
      say 'Example call:'
      say '   lad2st11 /ladpath=y:\lad2\ /customer=market /wgname=sales'
      exit 1
     end

ladpath = ''
cpath = ''
wgpath = ''
migpath = ''
ofile = ''
username = ''
customer = ''
wgname = ''
exitrc = 0

do i = 1 to 6
   parmfound = false
   currparm = translate(parm.i)
   if (substr(currparm,1,9) = '/LADPATH=') then
      do
         parmfound = true
         ladpath = strip(substr(currparm,10,length(currparm)))
         if (ladpath = '') then
             do
                say 'A value was not specified with the /LADPATH parameter.'
                say '   The parameter is ignored.'
             end
      end
   if (substr(currparm,1,10) = '/CUSTOMER=') then
      do
         parmfound = true
         customer = strip(substr(currparm,11,length(currparm)))
         if (customer = '') then
             do
                say 'A value was not specified with the /CUSTOMER parameter.'
                say '   The parameter is ignored.'
             end
      end
   if (substr(currparm,1,9) = '/MIGPATH=') then
      do
         parmfound = true
         migpath = strip(substr(currparm,10,length(currparm)))
         if (migpath = '') then
             do
                say 'A value was not specified with the /MIGPATH parameter.'
                say '   The parameter is ignored.'
             end
      end
   if (substr(currparm,1,8) = '/WGNAME=') then
      do
         parmfound = true
         wgname = strip(substr(currparm,9,length(currparm)))
         if (wgname = '') then
             do
                say 'A value was not specified with the /WGNAME parameter.'
                say '   The parameter is ignored.'
             end
      end
   if (substr(currparm,1,10) = '/USERNAME=') then
      do
         parmfound = true
         username = translate(strip(substr(currparm,11,length(currparm))))
         if (username = '') then
             do
                say 'A value was not specified with the /USERNAME parameter.'
                say '   The parameter is ignored.'
             end
      end
   if (substr(currparm,1,7) = '/OFILE=') then
      do
         parmfound = true
         ofile = strip(substr(currparm,8,length(currparm)))
         if (ofile = '') then
             do
                say 'A value was not specified with the /OFILE parameter.'
                say '   The parameter is ignored.'
             end
      end
   if ((parmfound = false) & \(currparm = '')) then
      do
         say 'Parameter ' || currparm || ' is not recognized.  It is being ignored.'
      end
end

say ''

if (ladpath = '') then
   do
      say '/LADPATH parameter missing.'
      say '   Specify the LAD2 directory path and retry.'
      exit 1
    end

if \(substr(ladpath,length(ladpath),1) = '\') then
   ladpath = ladpath || '\'

if (customer = '') then
   do
      say '/CUSTOMER parameter missing.'
      say '   Specify the customer name and retry.'
      exit 1
    end
else
   do
      cpath = ladpath || translate(customer) || '\'
      say 'Customer path is ' || cpath || '.'
   end

if (wgname = '') then
   do
      say '/WGNAME parameter missing.'
      say '   Specify the workgroup name parameter and retry.'
      exit 1
    end
else
   do
      wgpath = cpath || translate(wgname) || '\'
      say 'Workgroup path is ' || wgpath || '.'
   end

if (migpath = '') then
   do
      say '/MIGPATH parameter not specified.'
      say '   The target directory for generated Start migration files will default to the current directory.'
      migpath = directory()
   end
else
   do
      currDir = directory()
      newDir = migpath
      if (substr(newDir,length(newDir),1) = '\') then
         newDir = substr(newDir,length(newDir),length(newDir)-1)
      newDir = directory(newDir)
      currDir = directory(currDir)
      if (newDir = '') then
         do
            say 'ERROR:  Cannot find migration directory path ' || migpath || '.'
            exit 7
         end
   end

if \(substr(migpath,length(migpath),1) = '\') then
   migpath = migpath || '\'
say 'Target migration path ' || migpath || '.'

/* Load REXX utilities and initialize variables */

rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
if \((rc = 0) | (rc = 1)) then
   do
      say 'ERROR:  Could not load RexxUtils.'
      say '   Insure that you have it installed on your workstation and try again.'
      exit 3
   end
call SysLoadFuncs

/****************************************************/
/* Read values from the override file, if it exists */
/****************************************************/

defNum = 0
if \(ofile = '') then
   do
      call SysFileTree ofile, 'file', 'F'
      if (file.0 = 0) then
         do
            say 'ERROR:  Could not find override file:  ' || ofile
            say '   Check your invocation parameters and if the override file exists and retry.'
            exit 2
         end
      say '   Reading in override file ' || ofile || '.'
      rc = stream(ofile, 'c', 'open read')
      do until lines(ofile) = 0
         line = linein(ofile)
         if \(line = '') then
            do
               defNum = defNum + 1
               def.defNum.1 = translate(word(line,1))
               posBlank = pos(' ', line)
               if (posBlank > 0) then
                  def.defNum.2 = strip(substr(line,posBlank+1,length(line)))
               else
                  def.defNum.2 = ' '
            end
      end
      rc = stream(ofile, 'c', 'close')
   end

/* fileStruct.1.1 = filename
   fileStruct.1.2.1..n = lines
   fileStruct.1.3 = size
*/
   fileStructNum = 4
   fileStruct.1.1 = 'EXTD.TBL'
   fileStruct.2.1 = 'LAPS.TBL'
   fileStruct.3.1 = 'LS30.TBL'
   fileStruct.4.1 = 'RECEIVER.TBL'

do j = 1 to fileStructNum
   filename = wgpath || fileStruct.j.1
   call SysFileTree filename, 'file', 'F'
   if (file.0 = 0) then
      do
         say 'ERROR:  Could not find ' || filename
         exit 2
      end
   rc = stream(filename, 'c', 'open read')
   i = 1
   do until lines(filename) = 0
      fileStruct.j.2.i = linein(filename)
      i = i + 1
   end
   rc = stream(filename, 'c', 'close')
   fileStruct.j.3 = i - 1
end

/****************************/
/* Find the workgroup file. */
/****************************/

filename = ladpath || 'LADCODE\WORKGRP.TBL'
call SysFileTree filename, 'file', 'F'
if (file.0 = 0) then
   do
      say 'ERROR:  Could not find ' || filename
      exit 2
   end
rc = stream(filename, 'c', 'open read')
wgLine = ''
do until lines(filename) = 0
   line = linein(filename)
   if ((substr(line,1,8) = customer) & (substr(line,9,7) = wgname)) then
      wgLine = line
end
rc = stream(filename, 'c', 'close')

if (wgLine = '') then
   do
      say 'Could not find the corresponding customer/workgroup entry in' || filename || '.'
      say '   Check your parameters and/or the contents of ' || filename || ' and retry.'
      exit 4
   end

/********************************/
/* Find the user/client name(s) */
/********************************/

userNum = 0
do i = 1 to fileStructNum - 1
   do k = 1 to fileStruct.i.3
      found = false
      newUser = substr(fileStruct.i.2.k,1,7)
      do j =1 to userNum
         /* Skip over DEFAULT and TEST. */
         if ((user.j = newUser) | ((newUser = 'DEFAULT') | (newUser = 'TEST'))) then
            found = true
      end
      if (found = false) then
         do
            if (username = '') then
               do
                  userNum = userNum + 1
                  user.userNum = newUser
               end
            else
               if (newUser = username) then
                  do
                     userNum = userNum + 1
                     user.userNum = newUser
                  end
         end
   end
end

if (userNum = 0) then
   do
      say 'Could not find the specified username ' || username || '  in the workgroup.'
      say '   Check your invocation parameters and retry.'
      exit 5
   end

do userPos = 1 to userNum
   /* Find the correct line for EXTD */
   extdLine = ' '
   do i = 1 to fileStruct.1.3
      if (substr(fileStruct.1.2.i,1,7) = user.userPos) then
         do
            extdLine = fileStruct.1.2.i
         end
   end

   /* Find the correct line for LAPS */
   lapsLine = ' '
   do i = 1 to fileStruct.2.3
      if ((substr(fileStruct.2.2.i,1,8) = customer) & (substr(fileStruct.2.2.i,9,7) = wgname)) then
         do
            lapsLine = fileStruct.2.2.i
         end
   end
   /* The TEST entry in LAPS.TBL applies to all the clients in the workgroup. */
   if (lapsLine = '') then
      do i = 1 to fileStruct.2.3
         if ((substr(fileStruct.2.2.i,1,8) = 'TEST') & (substr(fileStruct.2.2.i,9,7) = 'TEST')) then
            do
               lapsLine = fileStruct.2.2.i
            end
      end
   
   /* Find the correct line for LS30 */
   ls30Line = ' '
   do i = 1 to fileStruct.3.3
      if (substr(fileStruct.3.2.i,1,7) = user.userPos) then
         do
            ls30Line = fileStruct.3.2.i
         end
   end

   /* Find the correct line for receiver */
   receiverLine = ' '
   do i = 1 to fileStruct.4.3
      if (substr(fileStruct.4.2.i,8,7) = user.userPos) then
         do
            receiverLine = fileStruct.4.2.i
         end
   end
   
   NodeName = strip(user.userPos)
   outfilename = migpath || NodeName || '.IMP'
   say 'On Migration File: ' || outfilename

   node.0.1 = '*NODE*'
   node.0.2 = ''
   node.1.1 = 'EMAdapterNum'
   node.1.2 = '3'
   node.2.1 = 'DBType'
   node.2.2 = 'stop'
   node.3.1 = 'LANType'
   node.3.2 = 'stop'
   node.4.1 = 'EMType'
   node.4.2 = 'stop'
   node.5.1 = 'GWType'
   node.5.2 = ' '
   node.6.1 = 'EMDFTSess'
   node.6.2 = '0'
   emdftSessNum = substr(extdLine,92,1)
   node.7.1 = 'EMNDFTSess'
   node.7.2 = '0'
   emnondftSessNum = substr(extdLine,28,1)
   node.8.1 = 'DEFLOCALCP'
   node.8.2 = NodeName

   localNodeID = substr(extdLine,151,8)
   if \(localNodeID = '') then
      node.8.2 = localNodeID

   node.9.1 = 'CPALIAS'
   node.9.2 = node.8.2
   
   localNodeAlias = substr(extdLine,159,8)
   if \(localNodeAlias = '') then
      node.9.2 = localNodeAlias

   node.10.1 = 'OSversion'
   node.10.2 = 'os/2 2.0'
   node.11.1 = 'BootDrive'
   node.11.2 = c2d(substr(wgLine,106,1)) - 64
   if \(lapsDrive = '') then
      do
         lapsDrive = translate(substr(lapsLine,16,1))
         if \(lapsDrive = 'C')  then
            do
               say '   When migrating the node, Start will set the LAPS drive to C.'
               say '   In LAD/2, the LAPS drive was set to drive ' || lapsDrive || '.'
            end
      end

   node.12.1 = 'DBInstalled'
   node.12.2 = '0'
   node.13.1 = 'CMInstalled'
   node.13.2 = '0'
   node.14.1 = 'LANInstalled'
   node.14.2 = '0'
   
   node.15.1 = 'MachineType'
   node.15.2 = '0000'
   node.16.1 = 'MachineNum'
   node.16.2 = '000'
   node.17.1 = 'MfgPlant'
   node.17.2 = '00'
   node.18.1 = 'SerialNum'
   node.18.2 = '0000000'

   if \(ls30Line = '') then
      do
         node.15.2 = substr(ls30Line,43,4) /* MachineType */
         node.16.2 = substr(ls30Line,47,3) /* MachineNum */
         node.17.2 = substr(ls30Line,50,2) /* MfgPlant */
         node.18.2 = substr(ls30Line,58,7) /* SerialNum */
      end

   do i = 19 to 23
      digit = d2c(i+30)
      node.i.1 = 'StartDFTSess' || digit
      node.i.2 = ' '
      y = i+5
      node.y.1 = 'StartNDFTSess' || digit
      node.y.2 = ' '
   end
   node.29.1 = 'WKSTComment'
   node.29.2 = ' '
   node.30.1 = 'NodeID'
   node.30.2 = ' '
   if \(extdLine = '') then
      node.30.2 = substr(extdLine,146,5)

/****************************/
/* work on database section */
/****************************/

   if (substr(wgLine,181,1) = 'I') then
      do
         num = substr(extdLine,145,1)
         node.12.2 = c2d(substr(wgLine,185,1)) - 64
         select
            when (num = 0) then
               do
                  node.2.2 = 'local'
                  say '   Start does not support standalone database functionality.'
                  say '   Start will migrate the node without database functionality.'
               end
            when (num = 1) then
               node.2.2 = 'svr'
            when (num = 2) then
               node.2.2 = 'req'
            when (num = 3) then
               do
                  /* Migration won't accept reqsvr when num=3 */
                  node.2.2 = 'svr'
                  say '   The Start migration facility does not support requester/server functionality.'
                  say '   Start will migrate the node with server functionality.'
               end
            otherwise nop
         end  
      end

/*******************************/
/* work on emdftparms sections */
/*******************************/
   
   emdftparms.0.1 = '*EMDFTPARMS*'
   emdftparms.0.2 = ' '
   emdftparms.1.1 = 'SessionNum'
   emdftparms.1.2 = ' '
   emdftparms.2.1 = 'SessionType'
   emdftparms.2.2 = '1'
   emdftparms.3.1 = 'SessShortID'
   emdftparms.3.2 = ' '
   emdftparms.4.1 = 'PresSpace'
   emdftparms.4.2 = '2'
   emdftparms.5.1 = 'PresSpaceRow'
   emdftparms.5.2 = ' '
   emdftparms.6.1 = 'PresSpaceCol'
   emdftparms.6.2 = ' '
   emdftparms.7.1 = 'SessionName'
   emdftparms.7.2 = emdftparms.3.2

   do i = 1 to 5
      j = 95 + (10 * (i - 1))
      dftshort.i = substr(extdLine,j,1)
      dftsess.i = substr(extdLine,j+1,8)
      dftsize.i = substr(extdLine,j+9,1)
   end

   emdftprinterBool = false
   emdftSessTotal = emdftSessNum
   if (substr(extdLine,93,1) = 'Y') then
      do
         emdftprinterBool = true
         emdftSessTotal = emdftSessNum + 1
      end

   /* Don't process dft sessions if CM is not installed and dft adapter <> 3,
   and if there are no config_3270_dft sessions. */
   if \( (substr(wgLine,211,1) = 'Y') & ( (substr(wgLine,180,1) = 'I') & (substr(extdLine,91,1) = '3' ))) then
        emdftSessTotal = 0

   if (emdftSessTotal > 0) then
    do
        node.6.2 = emdftSessTotal
        do i = 1 to emdftSessTotal
           do j = 0 to  7
               emdft.j.1.i = emdftparms.j.1
               emdft.j.2.i = emdftparms.j.2
           end
           emdft.1.2.i = i
           if \(dftshort.i = '') then
               emdft.3.2.i = dftshort.i
           if \(dftsess.i = '') then
               emdft.7.2.i = dftsess.i
           if \(dftsize.i = '') then
               emdft.4.2.i = dftsize.i
           if ((emdftprinterBool = true) & (i = emdftSessTotal)) then
               do
                  emdft.2.2.i = '2'
                  emdft.4.2.i = ' '
               end
           if (substr(extdLine,94,1) = 'Y') then
               do
                  num = 18 + i
                  node.num.2 = dftsess.i
               end
      end
    end

/**********************************/
/* work on emnondftparms sections */
/**********************************/
   
   emnondftparms.0.1 = '*EMNONDFTPARMS*'
   emnondftparms.0.2 = ' '
   emnondftparms.1.1 = 'SessionNum'
   emnondftparms.1.2 = ' '
   emnondftparms.2.1 = 'SessionType'
   emnondftparms.2.2 = '1'
   emnondftparms.3.1 = 'SessShortID'
   emnondftparms.3.2 = ' '
   emnondftparms.4.1 = 'PresSpace'
   emnondftparms.4.2 = '2'
   emnondftparms.5.1 = 'PresSpaceRow'
   emnondftparms.5.2 = ' '
   emnondftparms.6.1 = 'PresSpaceCol'
   emnondftparms.6.2 = ' '
   emnondftparms.7.1 = 'LUName'
   emnondftparms.7.2 = emnondftparms.3.2
   emnondftparms.8.1 = 'LULocalAdd'
   emnondftparms.8.2 = ' '
   emnondftparms.9.1 = 'ForAdapter'
   emnondftparms.9.2 = '0'
   emnondftparms.10.1 = 'AdapType'
   emnondftparms.10.2 = 'LAN'            

   do i = 1 to 5
      j = 31 + (12 * (i - 1))
      nondftshort.i = substr(extdLine,j,1)
      nondftsesn.i = substr(extdLine,j+1,8)
      nondftnau.i = substr(extdLine,j+9,2)
      nondftsize.i = substr(extdLine,j+11,1)
   end

   emnondftprinterBool = false
   emnondftSessTotal = emnondftSessNum
   if (substr(extdLine,29,1) = 'Y') then
      do
         emnondftprinterBool = true
         emnondftSessTotal = emnondftSessNum + 1
      end

   /* Don't process non-dft sessions if CM is not installed
   and if there are no config_3270_non_dft sessions. */
   if \((substr(wgLine,212,1) = 'Y') & (substr(wgLine,180,1) = 'I')) then
        emnondftSessTotal = 0

   if (emnondftSessTotal > 0) then
    do
        node.7.2 = emnondftSessTotal
        do i = 1 to emnondftSessTotal
           do j = 0 to 10
               emnondft.j.1.i = emnondftparms.j.1
               emnondft.j.2.i = emnondftparms.j.2
           end
           emnondft.1.2.i = i
           if \(nondftshort.i = '') then
               emnondft.3.2.i = nondftshort.i
           if \(nondftsesn.i = '') then
               emnondft.7.2.i = nondftsesn.i
           if \(nondftnau.i = '') then
               emnondft.8.2.i = nondftnau.i
           if \(nondftsize.i = '') then
               emnondft.4.2.i = nondftsize.i
           if ((emnondftprinterBool = true) & (i = emnondftSessTotal)) then
               do
                  emnondft.2.2.i = '2'
                  emnondft.4.2.i = ' '
               end
           if (substr(extdLine,30,1) = 'Y') then
               do
                  num = 23 + i
                  node.num.2 = nondftsesn.i
               end
      end
    end

/******************************/
/* work on dftadapter section */
/******************************/

   dftadapterBool = false
   dftadapter.0.1 = '*ADAPTER*'
   dftadapter.0.2 = ' '
   dftadapter.1.1 = 'AdapterNum'
   dftadapter.1.2 = '3'
   dftadapter.2.1 = 'AdapterType'
   dftadapter.2.2 = 'dft 3270'

   /* If CM is installed and the dft adapter = 3
   create a dft adapter entry. */
   if (substr(wgLine,180,1) = 'I') then
      do
         node.13.2 = c2d(substr(wgLine,107,1)) - 64
         if (substr(extdLine,91,1) = '3' ) then
            do
               dftadapterBool = true
               node.4.2 = 'dft'
            end
         else
            do
               say '   Specified DFT adapter type is not 3270 Connection'
               say '          and was not included in the migration file.'
               if (substr(extdLine,91,1) = '1' ) then
                  say '          The DFT adapter type was 3278/79.'
               if (substr(extdLine,91,1) = '2' ) then
                  say '          The DFT adapter type was Advanced 3278/79.'
            end
      end

/***************************/
/* work on adapter section */
/***************************/

   lanadapterBool = false
   lanadapter.0.1 = '*ADAPTER*'
   lanadapter.0.2 = ' '
   lanadapter.1.1 = 'AdapterNum'
   lanadapter.1.2 = '0'
   lanadapter.2.1 = 'AdapterType'
   lanadapter.2.2 = ' '
   lanadapter.3.1 = 'AdapterSpeed'
   lanadapter.3.2 = ' '
   lanadapter.4.1 = 'LocalAdminAdd'
   lanadapter.4.2 = '000000000000'
   lanadapter.5.1 = 'EMDestAdd'
   lanadapter.5.2 = ' '
   lanadapter.6.1 = 'EMRUsize'
   lanadapter.6.2 = '1920'
   lanadapter.7.1 = 'CSMLANID'
   lanadapter.7.2 = 'CASMID'
   lanadapter.8.1 = 'EthernetType'
   lanadapter.8.2 = '802.3'

   if \(lapsLine = '') then
      do
         lanadapterBool = true

         /* If non-dft sessions are defined, add LAN EMType functionality. */
         if (emnondftSessTotal > 0) then
            node.4.2 = node.4.2 || ' lan'

         adapterNum = substr(lapsLine,213,1)
         select
            when (adapterNum = 0) then
               do
                  lanadapter.2.2 = 'tr-unknown'
                  lanadapter.3.2 = '4'
                  lanadapter.8.1 = ' '
                  lanadapter.8.2 = ' '
                  say '   IBM Token Ring adapter specified.'
                  say '      Start will assume it is type Token Ring 16/4 /a with a set speed of 4.'
               end
            when (adapterNum = 1) then
               do
                  lanadapter.3.1 = ' '
                  lanadapter.2.2 = 'ibm ethernet /a'
               end
            when (adapterNum = 2) then
               do
                  lanadapter.3.1 = ' '
                  lanadapter.2.2 = '3comethermc'
               end
            when (adapterNum = 3) then
               do
                  lanadapter.3.1 = ' '
                  lanadapter.2.2 = 'ungermann-bass niups2'
               end
            when (adapterNum = 4) then
               do
                  lanadapter.2.2 = 'bus master token ring'
                  lanadapter.3.2 = '4'
                  lanadapter.8.1 = ' '
                  lanadapter.8.2 = ' '
                  say '   IBM Bus Master Token Ring adapter specified.'
                  say '      Assuming it has a set speed of 4.'
               end
            otherwise nop
         end  

         if \(receiverLine = '') then
            do
               /* Get the LocalAdminAdd if it exists, otherwise, 
               it's a UAA and needs to be defaulted to 000000000000. */
               str = substr(wgLine,99,1)
               if (str = 'Y') then
                  lanadapter.4.2 = substr(receiverLine,194,12)
               else
                  say '   Universal Adapter Address defaulted to 000000000000.'
            end

         if \(extdLine = '') then
            do
               /* Get the EMDestAdd. */
               lanadapter.5.2 = substr(extdLine,8,12)

               /* Default the CSMLANID to the NETWORK_ID. */
               lanadapter.7.2 = substr(extdLine,20,8)

               /* Check if DIX was specified. */
               str = substr(wgLine,97,1)
               if (str = '2') then
                  if ((adapterNum = '1') | ((adapterNum = '2') | (adapterNum = '3'))) then
                     lanadapter.8.2 = 'DIX'
            end

         /* Put the Ethernet or Token Ring prefix before the LocalAdminAdd. */
         if ((adapterNum = '1') | ((adapterNum = '2') | (adapterNum = '3'))) then
            lanadapter.4.2 = 'I' || lanadapter.4.2
         else
            lanadapter.4.2 = 'T' || lanadapter.4.2

      end

/***********************/
/* work on LAN section */
/***********************/
   
   lanBool = false
   lansrparms.0.1 = '*LANSRPARMS*'
   lansrparms.0.2 = ' '
   lansrparms.1.1 = 'AdapterNum'
   lansrparms.1.2 = '0'
   lansrparms.2.1 = 'DomainName'
   lansrparms.2.2 = ' '
   lansrparms.3.1 = 'COMPUTERNAME'
   lansrparms.3.2 = ' '
   lansrparms.4.1 = 'FileAccessMode'
   lansrparms.4.2 = '3'  /* defaulting to mixed */

   if (substr(wgLine,182,1) = 'I') then
      do
         lanBool = true
         node.14.2 = c2d(substr(ls30Line,25,1)) - 64
         lanType = translate(substr(ls30Line,26,1))
         if (lanType = 'R') then
            node.3.2 = 'req'
         if (lanType = 'D') then
            node.3.2 = 'dom'
         if ((lanType = 'A') | (lanType = 'B')) then
            node.3.2 = 'svr'

         domainName = substr(ls30Line,16,8)
         if \(domainName = '') then
           lansrparms.2.2 = domainName
         
         computerName = substr(ls30Line,8,8)
         if \(computerName = '') then
            lansrparms.3.2 = computerName
         else
            lansrparms.3.2 = nodeName
        
      end

/*******************/
/* override values */
/*******************/

   do i = 1 to defNum
      /* Are there any values in the nodes section? */
      do j = 1 to 30
         if (translate(node.j.1) = def.i.1) then
            do
               say '   Overriding ' || node.j.1 || ' old value ''' || node.j.2 || ''' with new value ''' || def.i.2 || '''.'
               node.j.2 = def.i.2
            end
      end 

      /* Are there any values in the LAN adapter section? */
      do j = 1 to 8
         if (translate(lanadapter.j.1) = def.i.1) then
            do
               say '   Overriding ' || lanadapter.j.1 || ' old value ''' || lanadapter.j.2 || ''' with new value ''' || def.i.2 || '''.'
               lanadapter.j.2 = def.i.2
            end
      end 

      /* Are there any values in the LAN parameters section? */
      do j = 1 to 4
         if (translate(lansrparms.j.1) = def.i.1) then
            do
               say '   Overriding ' || lansrparms.j.1 || ' old value ''' || lansrparms.j.2 || ''' with new value ''' || def.i.2 || '''.'
               lansrparms.j.2 = def.i.2
            end
      end 
   end

/**********************/
/* Create output file */
/**********************/

   rc = SysFileDelete(outfilename)
   if (rc = 0) then
       say '   Deleted old file.'

   rc = stream(outfilename, 'c', 'open')
   if ((substr(rc,1,5) = 'ERROR') | (substr(rc,1,8) = 'NOTREADY')) then
      do
         say 'ERROR:  Could not open file ' || outfilename || '.'
         say '   Check your migration path and retry.'
         exitrc = 6
      end
   else
   do

   do i = 0 to 30
      outline = insert(node.i.2,node.i.1,18)
      rc = lineout(outfilename,outline)
   end

   do i = 1 to emdftSessTotal
      rc = lineout(outfilename,' ')
      do j = 0 to 7
         outline = insert(emdft.j.2.i,emdft.j.1.i,18)
         rc = lineout(outfilename,outline)
      end
   end

   do i = 1 to emnondftSessTotal
      rc = lineout(outfilename,' ')
      do j = 0 to 10
         outline = insert(emnondft.j.2.i,emnondft.j.1.i,18)
         rc = lineout(outfilename,outline)
      end
   end
   
   if (dftadapterBool = true) then
      do
         rc = lineout(outfilename,' ')
         do j = 0 to 2
            outline = insert(dftadapter.j.2,dftadapter.j.1,18)
            rc = lineout(outfilename,outline)
         end
      end

   if (lanadapterBool = true) then
      do
         rc = lineout(outfilename,' ')
         do j = 0 to 8
            outline = insert(lanadapter.j.2,lanadapter.j.1,18)
            rc = lineout(outfilename,outline)
         end
      end

   if (lanBool = true) then
      do
         rc = lineout(outfilename,' ')
         do j = 0 to 4
            outline = insert(lansrparms.j.2,lansrparms.j.1,18)
            rc = lineout(outfilename,outline)
         end
      end

   rc = lineout(outfilename,' ')
   rc = lineout(outfilename,'*ENDPARMS*')
   rc = stream(outfilename, 'c', 'close')

   end
end

exit exitrc
