/* A simple DjVu viewer based on djvutopnm from DjVu 2.2 Reference Library
   by LizardTech, Inc. */
CONVERT = "djvu2pnm.exe"	/* djvutopnm name/path */
VIEW = "pmview.exe"		/* pnm viewer name/path */

error=0
IF Stream(convert,'C','QUERY EXISTS')='' THEN DO
   SAY 'ERROR: cannot find file' convert
   error=1
END
IF Stream(view,'C','QUERY EXISTS')='' THEN DO
   SAY "ERROR: can't find file" view
   error=1
END

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

PARSE ARG infile

IF Left(infile,1)='"' THEN PARSE VAR infile '"' infile '"' .

IF infile<>'' THEN DO
   IF Stream(infile,'C','QUERY EXISTS')='' THEN infile = ''
END
if infile="" then do
   say "USAGE: DjView <DjVu file>"
   error=1
end
if error>0 THEN exit(255)

tempfile = Value('TMP',,'ENVIRONMENT')
if tempfile="" then tempfile = Value('TEMP',,'ENVIRONMENT')
if tempfile<>"" then if right(tempfile,1)<>"\" then tempfile=tempfile||"\"
tempfile=SysTempFileName(tempfile||"DJVI????.TMP")

'@"'CONVERT'" "'infile'"' tempfile
IF Stream(temfile,'C','QUERY EXISTS')<>'' THEN DO
   '@"'VIEW'"' tempfile
   CALL SysFileDelete tempfile
END

EXIT
