/* Enhanced Command Line Processor */

/*
If you put parameters on the program object, the command will be executed as if typed, before the interactive mode starts.
For example, the following object definition will make the command line processor connect to database 'RAILWAYS' (if it exists) on startup:
Title: ECLP Railways
Program: ECLP.CMD
Parameters: CONNECT TO RAILWAYS

Multiple objects can be made for different databases.
*/

"@MODE 80 102" /* Get more lines on the screen */
CALL SYSCURPOS 101,0
CALL SQLDBS "START DATABASE MANAGER" /* Automatically start the database manager on startup */

/* Display message similar to the default CLP */
SAY "ECLP.CMD (c) Copyright Chris Angelico 2000-2001"
SAY "DB2.EXE (c) Copyright IBM Corporation 1993,1997"
SAY "Command Line Processor for DB2 SDK 5.2.0"
SAY
SAY "You can issue database manager commands and SQL statements from the command"
SAY "prompt. For example:"
SAY "    db2 => connect to sample"
SAY "    db2 => bind sample.bnd"
SAY
SAY "For general help, type: ?."
SAY "For command help, type: ? command, where command can be"
SAY "the first few keywords of a database manager command. For example:"
SAY " ? CATALOG DATABASE for help on the CATALOG DATABASE command"
SAY " ? CATALOG          for help on all of the CATALOG commands."
SAY
SAY "To exit db2 interactive mode, type QUIT at the command prompt. Outside"
SAY "interactive mode, all commands must be prefixed with 'db2'."
SAY "To list the current command option settings, type LIST COMMAND OPTIONS."
SAY
SAY "For more detailed help, refer to the Online Reference Manual."
SAY
PARSE ARG ARGS
IF ARGS\="" THEN DO /* If argument passed, execute it first as if typed */
	SAY "db2 => "ARGS
	"@DB2.EXE "ARGS
END
RESTART:
SIGNAL ON SYNTAX NAME RESTART /* Enable syntax trap */
DO UNTIL TRANSLATE(CMD)="QUIT"
	CALL CHAROUT ,"db2 => " /* Prompt similar to default CLP */
	CMD=CMDLINE()
	IF TRANSLATE(CMD)="EXIT" THEN CMD="QUIT" /* Default CLP supports QUIT command, but OS/2 supports EXIT. ECLP supports both. */
	IF TRANSLATE(WORD(CMD,1))="MODE" THEN DO; CMD; CMD=""; END /* Execute MODE as OS/2 command so user can change rows/cols */
	IF TRANSLATE(WORD(CMD,1))="ROWS" THEN DO; "@MODE "TRUNC(8192/WORD(CMD,2)) WORD(CMD,2); CMD=""; END
	IF TRANSLATE(WORD(CMD,1))="COLS" THEN DO; "@MODE "WORD(CMD,2) TRUNC(8192/WORD(CMD,2)); CMD=""; END
	IF CMD\="" THEN DO
		CMD=QUOTEREDIR(CMD) /* Tell OS/2 not to interpret < and > as redirection commands */
		"@DB2.EXE "CMD /* Pass the command to the default DB2 CLP */
	END
END
EXIT

QUOTEREDIR: PROCEDURE
PARSE ARG IN
OUT=""
DO I=1 TO LENGTH(IN)
	C=LEFT(IN,1)
	IN=SUBSTR(IN,2)
	IF POS(C,"<>|&")>0 THEN OUT=OUT"^"
	IF C="%" THEN OUT=OUT"%"
	OUT=OUT||C
END
RETURN OUT

BACKSLASHQUOTES: PROCEDURE
PARSE ARG IN
OUT=""
DO I=1 TO LENGTH(IN)
	C=SUBSTR(IN,I,1)
	IF C='"' THEN OUT=OUT"\"
	OUT=OUT||C
END
RETURN OUT

CMDLINE: PROCEDURE EXPOSE !HISTORY. /* Based on Albert Crosby's code - thanks Albert! */
SIGNAL ON SYNTAX NAME CMDLINEERROR
PARSE VALUE SYSCURPOS() WITH X Y
IF SYMBOL("!HISTORY.INSERT")="LIT" THEN !HISTORY.INSERT=1
IF SYMBOL("!HISTORY.0")="LIT" THEN !HISTORY.0=0
HISTORICAL=-1
WORD=""
POS=0
SIGNAL ON HALT NAME KEEPGOING
KEEPGOING:
DO FOREVER
	KEY=SYSGETKEY("NOECHO")
	SELECT
		WHEN KEY="0D"x THEN LEAVE
		WHEN KEY="08"x THEN IF POS>0 THEN DO
			WORD=DELSTR(WORD,POS,1)
			CALL RUBOUT 1
			POS=POS-1
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)" "COPIES("08"x,LENGTH(WORD)-POS+1)
		END
		WHEN KEY="1B"x THEN DO
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
			CALL RUBOUT LENGTH(WORD)
			WORD=""
			POS=0
		END
		WHEN KEY="0A"x THEN NOP /* Ctrl-Enter ignored */
		WHEN KEY="09"x THEN NOP /* Tab ignored */
		WHEN (KEY="E0"x)|(KEY="00"x) THEN DO
			KEY=SYSGETKEY("NOECHO")
			SELECT
				WHEN KEY="<" THEN DO /* F2 */
					SAY
					SAY "Enter file/device name to dump history to:"
					PARSE PULL FILE
					DO I=1 TO !HISTORY.0
						CALL LINEOUT FILE,!HISTORY.I
					END
					CALL LINEOUT FILE
					WORD=""
					LEAVE
				END
				WHEN KEY="U" THEN DO /* Shift-F2 */
					PARSE SOURCE . . ME
					'@START E 'ME
				END
				WHEN (KEY="k")|(KEY="=") THEN DO /* Alt-F4, F3 */
					WORD="QUIT"
					LEAVE
				END
				WHEN KEY="H" THEN CALL HISTORYSCAN -1
				WHEN KEY="P" THEN CALL HISTORYSCAN  1
				WHEN KEY="B" THEN CALL HISTORYSCAN -1,LEFT(WORD,POS) /* F8 */
				WHEN KEY="[" THEN CALL HISTORYSCAN  1,LEFT(WORD,POS) /* Shift-F8 */
				WHEN KEY="K" THEN IF POS>0 THEN DO
					CALL CHAROUT ,D2C(8)
					POS=POS-1
				END
				WHEN KEY="M" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,SUBSTR(WORD,POS+1,1)
					POS=POS+1
				END
				WHEN KEY="s" THEN IF POS>0 THEN DO
					NEWPOS=LASTPOS(" ",WORD,POS)
					IF NEWPOS=POS THEN NEWPOS=LASTPOS(" ",WORD,POS-1)
					CALL CHAROUT ,COPIES("08"x,POS-NEWPOS)
					POS=NEWPOS
				END
				WHEN KEY="t" THEN IF POS<LENGTH(WORD) THEN DO
					IF POS=0 THEN NEWPOS=POS(" ",WORD); ELSE NEWPOS=POS(" ",WORD,POS)
					IF NEWPOS=POS THEN NEWPOS=POS(" ",WORD,POS+1)
					IF NEWPOS=0 THEN NEWPOS=LENGTH(WORD)
					CALL CHAROUT ,SUBSTR(WORD,POS+1,NEWPOS-POS)
					POS=NEWPOS
				END
				WHEN KEY="S" THEN IF POS<LENGTH(WORD) THEN DO
					WORD=DELSTR(WORD,POS+1,1)
					CALL CHAROUT ,SUBSTR(WORD,POS+1)" "
					CALL CHAROUT ,COPIES("08"x,LENGTH(WORD)-POS+1)
				END
				WHEN KEY="R" THEN !HISTORY.INSERT=\!HISTORY.INSERT
				WHEN KEY="O" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,SUBSTR(WORD,POS+1)
					POS=LENGTH(WORD)
				END
				WHEN KEY="G" THEN IF POS>0 THEN DO
					CALL CHAROUT ,COPIES("08"x,POS)
					POS=0
				END
				WHEN KEY="u" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,COPIES(" ",LENGTH(WORD)-POS)COPIES("08"x,LENGTH(WORD)-POS)
					WORD=LEFT(WORD,POS)
				END
				WHEN KEY="w" THEN IF POS>0 THEN DO
					IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
					CALL RUBOUT LENGTH(WORD)
					WORD=SUBSTR(WORD,POS+1)
					CALL CHAROUT ,WORD||COPIES("08"x,LENGTH(WORD))
					POS=0
				END
				OTHERWISE NOP
			END
		END
		OTHERWISE
			CALL CHAROUT ,KEY
			IF !HISTORY.INSERT THEN WORD=INSERT(KEY,WORD,POS); ELSE WORD=OVERLAY(KEY,WORD,POS+1)
			POS=POS+1
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)COPIES("08"x,LENGTH(WORD)-POS)
	END
END
SAY SUBSTR(WORD,POS+1)
IF WORD\="" THEN DO
	I=!HISTORY.0
	IF WORD\=!HISTORY.I THEN DO
		!HISTORY.0=!HISTORY.0+1
		I=!HISTORY.0
		!HISTORY.I=WORD
	END
END
CMDLINEERROR:
RETURN WORD

RUBOUT:
DO !I=1 TO ARG(1)
	CALL CHAROUT ,"082008"x
END
RETURN

HISTORYSCAN:
PARSE ARG DIR,PREFIX
IF !HISTORY.0>0 THEN DO
	IF HISTORICAL=-1 THEN IF DIR>0 THEN HISTORICAL=0; ELSE HISTORICAL=!HISTORY.0+1
	PREVHISTORICAL=HISTORICAL
	DO UNTIL ABBREV(!HISTORY.HISTORICAL,PREFIX)|(HISTORICAL=PREVHISTORICAL)
		HISTORICAL=HISTORICAL+DIR
		IF HISTORICAL=0 THEN HISTORICAL=!HISTORY.0
		IF HISTORICAL>!HISTORY.0 THEN HISTORICAL=1
	END
	IF PREVHISTORICAL=HISTORICAL THEN RETURN
	IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
	CALL RUBOUT LENGTH(WORD)
	WORD=!HISTORY.HISTORICAL
	CALL CHAROUT ,WORD
	IF PREFIX="" THEN POS=LENGTH(WORD)
	ELSE DO
		POS=LENGTH(PREFIX)
		CALL CHAROUT ,COPIES("08"x,LENGTH(WORD)-POS)
	END
END
RETURN
