/* TABLESIZE.CMD
Calculates the tablespace size of a given table from a CREATE TABLE statement.
*/
SAY "Enter CREATE TABLE command:"
CREATE=READLINE()
PARSE VALUE CREATE WITH "CREATE TABLE "TABLE" ("COLS
COLS=LEFT(COLS,LASTPOS(")",COLS)-1)
SIZE=0
DO WHILE COLS\=""
	PARSE VALUE COLS WITH CUR","COLS
	PARSE VALUE CUR WITH NAME TYPE ATTR
	IF (NAME="PRIMARY")|(NAME="FOREIGN") THEN ITERATE /* Primary/foreign key defn */
	IF TYPE="LONG" THEN DO; TYPE=TYPE WORD(ATTR,1); ATTR=SUBWORD(ATTR,2); END
	SIZE=SIZE+COLSIZE(TYPE)+(POS("NOT NULL",ATTR)=0)
END
SAY
SAY "Table "TABLE" will require "SIZE" bytes in its primary tablespace."
PULL
EXIT

COLSIZE: PROCEDURE
PARSE ARG TYPE"("SIZE")"
SELECT
	WHEN TYPE="INTEGER" THEN RETURN 4
	WHEN TYPE="SMALLINT" THEN RETURN 2
	WHEN TYPE="BIGINT" THEN RETURN 8
	WHEN TYPE="FLOAT" THEN RETURN 8
	WHEN TYPE="DECIMAL" THEN DO; PARSE VALUE SIZE WITH P","S; IF P="" THEN P=5; IF S="" THEN S=0; RETURN TRUNC(P/2+1); END
	WHEN (TYPE="CHAR")|(TYPE="CHARACTER") THEN IF SIZE="" THEN RETURN 1; ELSE RETURN SIZE
	WHEN TYPE="VARCHAR" THEN RETURN SIZE+4
	WHEN TYPE="LONG VARCHAR" THEN RETURN 24
	WHEN TYPE="GRAPHIC" THEN RETURN SIZE*2
	WHEN TYPE="VARGRAPHIC" THEN RETURN SIZE*2+4
	WHEN TYPE="LONG VARGRAPHIC" THEN RETURN 24
	WHEN TYPE="DATE" THEN RETURN 4
	WHEN TYPE="TIME" THEN RETURN 3
	WHEN TYPE="TIMESTAMP" THEN RETURN 10
	OTHERWISE RETURN 0
END
RETURN "**"

READLINE: PROCEDURE /* Basic data entry; uppercases */
STR=""
DO FOREVER
	K=TRANSLATE(SYSGETKEY("NOECHO"))
	SELECT
		WHEN K="0D"x THEN LEAVE
		WHEN K="08"x THEN DO; STR=DBRRIGHT(STR,1); CALL CHAROUT ,"082008"x; END
		OTHERWISE STR=STR||K; CALL CHAROUT ,K
	END
END
SAY
RETURN STR
