/*   Install ODBC Command Processor Workplace Shell Objects */

CALL RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
Call SysLoadFuncs

/*  My interface to DosCopy  */
call RxFuncAdd 'COPYFILE', 'RXIODGC', 'COPYFILE'
rc =  RxFuncAdd('COPYFILE', 'RXIODGC', 'COPYFILE')

dir = Directory()
dir = translate(dir)       /* in case its not all uppercase */

rc  = SysFileTree( "SQL_OS2.EXE", "FILE1", "FO" )
rc  = SysFileTree( "SQL_OS2X.EXE", "FILE2", "FO" )
IF rc \= 0 THEN Signal ABORT

rc = SysCreateObject("WPProgram", "ODBC Command Processor - No DragText", "<WP_DESKTOP>","PROGTYPE=PM;EXENAME="||file1.1||";OBJECTID=<DATA_SHELL>;STARTUPDIR="dir";","F")
rc = SysCreateObject("WPProgram", "ODBC Command Processor - with DragText", "<WP_DESKTOP>","PROGTYPE=PM;EXENAME="||file2.1||";OBJECTID=<DATA_SHELLX>;STARTUPDIR="dir";","F")

fname = sysbootdrive()||"\CONFIG.SYS"


/* --- copy existing config.sys file to a new name - in case we screw up ----- */
msg = "Saving backup of CONFIG.SYS - temp name"
savedname = systempfilename(sysbootdrive()||"\CONFIG.???")
if (savedname='') then signal FAILED

newname = systempfilename(sysbootdrive()||"\CONFIGX.???")
if (newname='') then signal FAILED

msg = "Saving backup of CONFIG.SYS - copy"
rc = copyFile(fname,savedname)
if (rc\=0) then signal FAILED



/* ---- loop through new file and  ---- */

lflag=0
hflag = 0
configFlag=0
do while (lines(fname))

	linex = strip(linein(fname))
	parse value linex with tag ' ' name '=' nvalue

	if (lflag=0) then do
       if (translate(substr(tag,1,7))='LIBPATH') then do   /* LIBPATH processing */
          	    lflag = 1
		        lline = translate(linex)
          	    parse value lline with tag '=' lvalue

          	/*   add current directory to libpath */

			if (pos(dir,lvalue)=0) then do
				linex=changestr('=.;',linex,'=.;'||dir||';')
				configFlag=1
			end
		end
	end
/****
	name = translate(name)

	if (hflag=0) then do
		if (name='HELP') then do
			hflag = 1
			lline = translate(nvalue)
			if (pos(dir,translate(lline))=0) then do
				linex=changestr('=',linex,'='||parms.driverspath||';')
				configFlag=1
				if (substr(parms.debug,6,1)='X') then say 'config.sys help gets 'parms.driverspath
			end
		end
	end
****/

	rc = lineout(newname,linex)

end
rc = lineout(newname)		/* close the file */
rc = stream(fname,'C','CLOSE')

if (configFlag=1) then do
	rc = copyFile(newname,fname)
	if (rc\=0) then do
		msg = 'Could not copy newly edited config.sys file ('newname') back on top of CONFIG.SYS'
		signal FAIL
	end
   say ''
   say 'Your CONFIG.SYS file has been changed.'
   say 'Your old CONFIG.SYS was saved as 'savedName
   say 'You must re-boot before running the ODBC Command Processor'
   say ''

end



call sysfiledelete newname

return


FAILED:
  SAY "Failed trying to" msg
  RETURN
