/* Run a report on a DBase file */

/* Get information - database (required), report file (required), output file (required), filter (optional), and page length (optional) */
SAY "Enter database file name:"
PARSE PULL DBF
IF DBF="" THEN EXIT
SAY "Enter report file name:"
PARSE PULL REP
IF REP="" THEN EXIT
SAY "Enter output file name:"
PARSE PULL OUT
IF OUT="" THEN EXIT
SAY "Enter filter (or null for all records):"
PARSE PULL FILTER
SAY "Enter page length (or null for no page breaks):"
PARSE PULL PAGELEN
IF PAGELEN="" THEN PAGELEN=99999999999

/* Open the database */
CALL REXXBASE_OPENDBF "DBF"
CALL REXXBASE_FILTERDBF "DBF",FILTER /* Set filter */
SAY /* Move cursor to next line */

/* Begin RunReport code by Chris Angelico */
CALL READREPORT REP /* Read .REP file into stem - can be done only once if you want to use the same report several times */
PGLNS=0
PAGE=1
DO I=1 TO REPORT.COVER.0
    CALL DOREPORTLINE REPORT.COVER.I
END
DO I=1 TO REPORT.HEADING.0
    CALL DOREPORTLINE REPORT.HEADING.I
END
CALL REXXBASE_GOTORECORD "DBF","TOP"
RECSPRINTED=0
DO WHILE REXXBASE_READDBF("DBF")=""
    DO I=1 TO REPORT.DETAIL.0
        CALL DOREPORTLINE REPORT.DETAIL.I
    END
    RECSPRINTED=RECSPRINTED+1
END
DO I=1 TO REPORT.FOOTING.0
    CALL DOREPORTLINE REPORT.FOOTING.I
END
DO I=1 TO REPORT.TOTAL.0
    CALL DOREPORTLINE REPORT.TOTAL.I
END
/* End RunReport code by Chris Angelico */

CALL CHAROUT OUT
CALL REXXBASE_CLOSEDBF "DBF"
EXIT

/* Begin RunReport functions by Chris Angelico */
READREPORT: PROCEDURE EXPOSE REPORT.
PARSE ARG REP
SECT="NULL"
REPORT.=0
I=0
DO WHILE CHARS(REP)>0
    L=LINEIN(REP)
    IF LEFT(L,1)=":" THEN DO
        REPORT.SECT.0=I
        SECT=DBRLEFT(L,1)
        I=0
    END
    ELSE DO
        I=I+1
        REPORT.SECT.I=L
        IF LEFT(L,1)="/" THEN REPORT.SECT.LINES=REPORT.SECT.LINES+SUBSTR(L,2)
    END
END
REPORT.SECT.0=I
CALL STREAM REP,"C","CLOSE"
RETURN

DOREPORTLINE: 
PARSE ARG L
IF POSN="POSN" THEN POSN=0
SELECT
    WHEN L=".GROUP" THEN DO; NOBLANKS=1; BLANKS=0; END /* Group lines together */
    WHEN L=".EGROUP" THEN NOBLANKS=0 /* End of group */
    WHEN L=".EGROUP R" THEN DO BLANKS; CALL LINEOUT OUT,""; NOBLANKS=0; END /* End of group; put blank lines at end */
    WHEN ABBREV(L,"@") THEN DO
        PARSE VALUE L WITH "@"OPT VALUE
        OPTION.OPT=VALUE
    END
    WHEN ABBREV(L,".") THEN NOP /* Special command eg .GROUP or .IF, but not caught */
    WHEN ABBREV(L,'"') THEN DO
        /* Literal text */
        PARSE VALUE L WITH '"'TXT'"'
        CALL CHAROUT OUT,TXT
        POSN=POSN+LENGTH(TXT)
    END
    WHEN ABBREV(L,"/") THEN DO
        /* Number of line breaks; /1 is most common. */
        CALL EOL SUBSTR(L,2)
    END
    WHEN ABBREV(L,"<")|ABBREV(L,"[") THEN DO
        /* Trimmed field eg <NAME> or padded field eg [NAME] */
        TRIMMED=LEFT(L,1)="<"
        IF TRIMMED THEN PARSE VALUE L WITH "<"F">"
        ELSE PARSE VALUE L WITH "["F"]"
        SELECT
            WHEN POS(",",F)>0 THEN DO
                PARSE VALUE F WITH F","S","L
                TXT=SUBSTR(DBF.F,S,L)
                IF TRIMMED THEN TXT=STRIP(TXT)
            END
            WHEN F="DATE*" THEN TXT=DATE("M") DATE("D") WORD(DATE("N"),3)
            WHEN F="TIME*" THEN TXT=TIME("C")
            WHEN F="COUNT*" THEN TXT=RECSPRINTED
            WHEN F="PAGE*" THEN TXT=PAGE
            WHEN F="SELECT*" THEN TXT=SELECTCRITERIA
            WHEN F="SORT*" THEN TXT=DBF.INDEXFIELDS.1
            WHEN F="RECORDS*" THEN TXT=DBF.RECORDCOUNT
            WHEN RIGHT(F,1)="*" THEN TXT="**UNSUPPORTED**"
        OTHERWISE IF TRIMMED THEN TXT=STRIP(DBF.F); ELSE TXT=LEFT(DBF.F,DBF.F.LENGTH)
        END
        CALL PUTTEXT TXT
    END
    WHEN ABBREV(L,"=") THEN DO
        P=SUBSTR(L,2)
        IF POSN=0 THEN POSN=1
        IF POSN<P THEN DO; CALL CHAROUT OUT,COPIES(" ",P-POSN); POSN=P; END
    END
    WHEN ABBREV(L,"*") THEN DO
        /* REXX Expression */
        INTERPRET "VAL="SUBSTR(L,2)
        CALL PUTTEXT VAL
    END
OTHERWISE NOP
END
RETURN

IIF: /* Function call version of IF, like C/C++ ?: operator */
IF ARG(1) THEN RETURN ARG(2)
RETURN ARG(3)

PUTTEXT: /* Put text into the output file */
PARSE ARG V
IF (OPTION.TILDEFLIP="ON")&(POS("~",V)>0) THEN DO
    PARSE VALUE V WITH Q"~"W
    V=W Q
END
CALL CHAROUT OUT,V
POSN=POSN+LENGTH(V)
RETURN ""

EOL: /* Puts end of line */
PARSE ARG L
IF L="" THEN L=1
IF NOBLANKS=1 THEN DO; N=POSN>0; BLANKS=BLANKS+L-N; END
ELSE N=L
POSN=0
DO N; CALL LINEOUT OUT,""; END
IF PGLNS="PGLNS" THEN PGLNS=L
ELSE PGLNS=PGLNS+L
IF PGLNS>PAGELEN-1-REPORT.FOOTING.LINES THEN DO
    PGLNS=-1
    DO J=1 TO REPORT.FOOTING.0
        CALL DOREPORTLINE REPORT.FOOTING.J
    END
    PGLNS=0
    PAGE=PAGE+1
    CALL CHAROUT OUT,"C"x
    DO J=1 TO REPORT.HEADING.0
        CALL DOREPORTLINE REPORT.HEADING.J
    END
END
RETURN ""
/* End RunReport functions by Chris Angelico */
