# CHANGELOG for DB4S

All notable changes to the **Database Browser for SQLite** -
DB4S - project will be documented in this file.

The format is based on
[Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to
[Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased - nightly] - 2023-05-05

_Add bullet points to the subheadings below as you commit changes. <br>
When a new version is released, incorporate the changes <br>
into that version's description, and create a new <br>
"[Unreleased - nightly] - yyyy-mm-dd" <br>
entry at the head of this file._

### Added
- dbhub: Add text to upload button (7c6ef2ae)
- Add zooming to image viewer in the Edit Dialog (d3c69ad2)
- New setting for having close button on tabs (default) or not (896b0daa)
- New setting for configuring brace matching background (662dbcf9)
- New settings for changing the selection appearance in editors (0562f16d)
- Improvements for working in the SQL Execution area using keyboard (946d408a)
- Fall back to asking SQLite when parsing a table schema has failed (139de669)
- Update schema after attaching/detaching a database in an Execute SQL tab (b16017e1)
- Scale large images in ImageViewer to fit the viewport by default (23b1021d)
- Rename 'Open tab' to 'New tab' in the Execute SQL area (f5590265)
- Add iif SQL function to the list of known functions in Execute SQL tab (ff37c901)
- dbhub: Add refresh button to both tool bars (9a8bcafa)
- dbhub: Log in by only selecting an identity, no need to press a button (5cdda286)
- dbhub: Add context menu actions to all tree views (4c4e55f8)
- dbhub: Add toolbar action for fetching the latest commit (2e958036)
- dbhub: Add context menu action for saving a revision to another file (ab5b6337)
- Add GUID display format (e51aa2ee)
- Bar charts did not display labels in x axis when NULL values present (3485a52e)
- Add more options for setting font sizes (0eb01fe0)
- dbhub: Add view of all checked out databases (c776af98)
- dbhub: Add context menu action to delete local databases (dd323faf)
- dbhub: Add button for cloning databases from a link (e2783b68)
- dbhub: Add some line breaks to the input dialog text for cloning (595d845a)
- dbhub: Add link to webUI page of currently opened database (12ba01ff)
- Add status message when opening a file from the recent file list (d5b9d809)
- Move recent files items to new submenu and add clear recent file function (#2347) (ec6ff6a4)
- Add new action to close project file and return to initial state (aaa628bf)
- dbhub: Add "Upload Database" action to context menu of local file list (8db6e16f)
- Add file, line number and function to Error Log (ed226f1d)
- Add 'Don't ask again' button to collation message box (8323f2a1)
- Allow multiple TableBrowser tabs in the Browse Data tab (1e1e87e6)
- Add .NET DateTime.Ticks to date display format (b24c1f06)
- dbhub: Allow pushing to other user accounts to which you have access (dfc76450)
- Add the ability to support custom config files (#2390) (0644bc09)
- Add new option to freeze columns in the Browse Data tab (a15f81bc)
- Allow users to export or import user-settings file in a GUI environment (#2394) (27c2f64d)
- Add new menu item to import from CSV data in the system clipboard (9d87b963)
- Enable HiDPI on Windows (#2469) (1dc7ffee)
- Add "Save Database As..." action (c8cd8586)
- Enable HiDPI on all platforms by default (59778379)
- Add new menu item to show the row counts of all tables (efb9f9c9)
- Add Ctrl+Enter as shortcut for executing query (af84e89b)
- ImageViewer: Add mouse wheel zoom (f749f38f)
- Import: Add import-csv option to command line to import CSV files (09aaacca)
- parser: Add support for IS (NOT) DISTINCT FROM expressions (5c57622f)
- Add an extra tab for editing foreign keys to the Edit Table dialog (53b5493f)
- Add an extra tab for editing check constraints to the Edit Table dialog (54d82eab)
- Add auto completion for math functions (#2631) (fb80d3bc)
- Execute SQL: add Ctrl+Shift+T for "Open SQL file(s)" (128babb6)
- Add a refresh button to the Database Structure tab (d5c66088)
- macOS ARM version (e4435e67aad8d15569684074681c7200d55f5ac6)

### Fixed
- Fix crash when trying to open non-existing table via command line (112e0089)
- Fix possible crashes when loading outdated project file (31ded8a8)
- Fix possible crash when loading project files (fa04d72f)
- Fix empty filters in project files (60f12143)
- Fix a harmless warning when searching for an empty font name (ea6d0089)
- Fix executing selected SQL text when there are multi-byte characters (d089a60b)
- Fix SQL import of files with BOM (7c3cce56)
- Fix warning in SQL error log when creating an in-memory database (f4f014e7)
- dbhub: Fix port number mismatch when using port 443 (910ca3d2)
- Fix colour assigned to plot being always black (651c1999)
- dbhub: Fix sporadic crashes when selecting an identity (5341112b)
- Fix bug which made tables from other schemas inaccessible in Browse Data (b6e3db34)
- Fix crash when a format is applied and one or more columns are selected (4f9e7c5d)
- dbhub: Fix updating branch list when database name is changed (9274e24e)
- dbhub: Fix reply handler for push actions (cefb4b70)
- dbhub: Fix saving latest commit to file (d76d6c25)
- dbhub: Fix creating new branches (8c12ee01)
- Fix problems when showing help message in rich text format (0963cacc)
- Fixed incorrect display of SQL calltips containing non-US-ASCII characters (852faf6b)
- Fix to 'Window Layout' options work properly (bdabc446)
- parser: Fix unquoting when using square brackets (9a3e5b1a)
- Fix possible crash when trying to modify a table (b0762119)
- Fix formatting and syntax of the help message in Spanish (1a2de374)
- Fix saving the list of extensions in the Preferences dialog (9b387d20)
- Fix remaining issue with optimised SELECT statements (6f499054)
- Fix filter row losing focus when changing filter values (c951c1cb)
- Fix issues with executing SQL statements (367665e7)
- Fix editing of tables without rowid (1c0cf443)
- Fix running ALTER TABLE statements in Execute SQL tab (5d80f987)
- Fix 'Set Encryption': don't reuse current file after closing (967780d0)
- Fix possible crash when removing constraints from table definition (7c1454e7)
- Fix #2583: quote identifiers, not expressions (6b03a33e)
- Fix filters for tables with display formats (910a2e10)
- Fix changes to constraints in Edit Table dialog not always being applied (ef87dc63)
- Fix browsing tables without rowid and multiple primary key columns (0b1ff641)
- Fix possible memory leak when trying to open an encrypted database (13e17579)
- Fix title, which must be non-empty (c13fb733)
- Fix possible crash when browsing a table with multiple PK columns (b3fab20c)
- parser: Fix string literals used as column ids in indexed columns (594aa020)
- Fix repositioning of filter widgets after the second click on the header (13b372ca)
- Fix possible crash when opening a project without SQL tabs (f5e07452)
- Fixes for hiding the title bar of the single Table Browser (a1f6d2c7)
- [Fix  Can't parse db name in .env file (302a5fe0)
- Fix type on TableBrowser.ui (33639dd2)
- Fix crash when removing the only index constraint from a table (a5a3d7fd)
- Fix error messages in Execute SQL tab (c0adfe43)
- Fix altering tables with generated as columns (39e9eb0e)


### Changed
- Show a useful icon in SQL tabs (#2153) (81b9b5a1)
- Use Ctrl+PgUp to set focus to editor inside the SQL Execution Area. (971b5ce5)
- Open SQL tabs for modifying views and triggers (ebeef140)
- Font change in Browse Data table not applied to RTL Text editor (a803069d)
- No longer force Light theme on macOS when "Follow the desktop style" is chosen (0bb3b230)
- Also update schema when clicking the Refresh button in Browse Data tab (a09df5bc)
- dbhub: Improve support for different branches (6c2e38c2)
- dbhub: Show some information on the currently opened database file (8428c934)
- dbhub: Automatically switch to the correct identity when opening file (635dba93)
- Restore original default for having condition format in filter line (5f53d630)
- dbhub: Show list of commits in Remote dock (5d89bb89)
- dbhub: Use current locale for formatting all timestamps (f6f28855)
- dbhub: Refresh commit list after pushing a new commit (0942fad6)
- dbhub: Show a warning when trying to push unsaved changes (e285de6d)
- dbhub: Highlight current commit in commit list (c05b92e9)
- dbhub: Do not allow pushing in-memory databases (2ea87e7e)
- dbhub: Do no show error message when download was cancelled (10214b31)
- Better error messages when CSV import fails due to an unexpected EOF (f75a3587)
- dbhub: Better explanations for the Clone button (f81e4c2f)
- dbhub: Clear branches combo box when closing database (7842f2a1)
- Clear currently opened database file name when closing database (9fcba5a8)
- dbhub: Improve default settings table views in Remote dock a bit (fbfcdbe4)
- dbhub: Some UI improvements (fa193013)
- Use native path separators in Preferences dialog (f67d72df)
- dbhub: Allow checking out different commits and different branches (065adabe)
- dbhub: In Push dialog preselect the current branch (fc4deeb9)
- dbhub: Only show warning about losing unsaved changes when downloading (1af81359)
- Select column in table results when column header is pressed (aaf671f4)
- dbhub: Show more information in tree views (8b5f34c4)
- Hide filters when table is empty (fc78fc2f)
- GUI improvements in Edit Table Dialog (de28943e)
- Edit Table: Change the key icons from header to tooltips (424dd57d)
- Edit Table: alternating row colors in tables for better readability (4bf7adfa)
- Cut to clipboard operation in data browsers (09320c20)
- Remove filter widgets when the table is empty (0e1eb7db)
- Update remote database information when an upload is completed (40c132e9)
- Comment out additional gotReply() signal connection (aa3d2814)
- dbhub: When deleting last local database of a user, remove user too (70eb15a8)
- Resize rows to contents only for visible rows (c77cb972)
- dbhub: Redownload database when checking out current commit (69eec2b6)
- Avoid attaching the plot when the signal is notifying the row count since the data wouldn't be available yet. (20e94984)
- Return the configured font for data browser in the model (47aa591d)
- Avoid possible database busy message when using the Browse Table action (73b2a1c2)
- Use table name as tab text in Browse Data tabs (c96c393d)
- Always load settings for Browse Data tabs (e9ec07e1)
- Save custom tab title flag in project files (c33b8be8)
- Allow the user can change MaxRecentFiles (#2373) (54ee47b5)
- Change tabbed table browisng to use docks instead (28ae7417)
- Always raise new Data Browser tabs to the foreground (539657e5)
- Allow multiple -t/--table parameters on the command line (ab682a32)
- detach additional database connection (29635e9e)
- Refresh table views when using --table command line option (598dd545)
- Tweak the output wording for command line options (153e0290)
- Show preformatted text for output from command line arguments in Windows (175ff737)
- Remove the Default property of the fetching dialog (c791a9ff)
- Unify message in About dialog and version argument (fd54bf1a)
- Change to 'Preference' expression for consistent (d9fd0e17)
- dbhub: Make HTML text of commit message field non-translateable (a6acb6cc)
- Destroy the Temporary Fiel object so it is not kept open (d8ca11f5)
- Open in external application: apply saved data directly to the cell (7c147456)
- Adjust the bottom buttons layout (b5a0d531)
- User can disable 'Save Project' dialog (#2420) (04d53c6e)
- Correct to tab instead of space (bd8e6bfd)
- Evaluation mode in the Edit Database Cell editor (9a70af79)
- Store a relative filename if the path to project and to DB is the same (2390b9e6)
- Allow selecting fixed format for big integer numbers (7d041020)
- Avoid type conversion warnings in Plot Dock (8b98df14)
- Warn user to apply or discard unsaved changes in cell editor (1e4a88dd)
- Allow opening recent files in read-only mode using a different shortcut (11058633)
- Export SQL: fix quoting of BLOB values and non-printable strings (e5734d4f)
- CSV Import: give option to use system locale conventions (f9314b6d)
- CSV Import: fix importing into existing table (dafa873d)
- CSV Import: fixes of the local convention option (e0b40ad9)
- Data Browser: avoid showing BLOBs containing unprintable characters as text (5e0c56a4)
- SQL Execution Editor: appropriate helping message in reload dialog (df853b30)
- Plot: fix selecting points to select corresponding line in table (223a7cd6)
- CSV Export: binary BLOB to base64 (a86c196a)
- Complete menu accelerators in File and Tools entries (be041e5e)
- Give alternate shorcuts to the ones using F keys (576bbe7e)
- Binary detection: end-of-line characters where not treated as text (fb7248b7)
- Avoid running SELECT statements twice in Execute SQL tab (99ee8fa1)
- Enable buttons for editing/deleting tables and similar on first click (b3d30cad)
- For sorted column remember column name instead of column index (94023a55)
- Change WHERE clauses of queries to use column names instead of indexes (18c7e9c4)
- Import: support importing the single file argument as a CSV file (cfa4dee3)
- Import: announce support for CSV files in Desktop file (efa1cdf2)
- Import: do not remove characters from CSV header fields (248a630d)
- Update appdata to pass validation (b553c088)
- src: rename sqlb::Query::setColumNames (38cdd94e)
- Import: allow CSV separator and quote to be passed from command line (36c5b1ba)
- Export query results as JSON (e225dc1e)
- Save as view: allow any state in the table (2826e7b9)
- Data Browser: export query results as JSON (a5cc259b)
- Store table constraints in a vector instead of a set (4e1d1ff4)
- Import: "Yes to All" to skip all further prompts (035a541c)
- Table Browser: "Clear Filters" button to clear the global filter (580e86e2)
- Table Browser: give hint of table sorted or filtered state in the toolbar (78edc8f9)
- Import: don't assume an empty file is a text file (93a5c2d0)
- update plotwindow's selection in tablebrowser (a51d6c10)
- Table Browser: Support extended selections (c5199f55)
- Show tables in foreign key editor in alphabetical order (d7074bb8)
- Avoid multiple error messages when deleting cell values (50b48bc7)
- Do not always refresh the table browser dock when opening a database (3be5969b)
- Use LIMIT + OFFSET when generating SELECT statements instead (bbfaca2e)
- When modifying a view use DROP VIEW IF EXISTS instead of just DROP VIEW (6cde3f51)
- Add basic support for new RETURNING keyword (6f6113c2)
- fix indentation (4 spaces) (bb44fc15)
- Improve support for BLOB columns as primary key (6510bb10)
- CSV Import: use file before it is removed by destructor (5097760f)
- Export SQL: option to keep original CREATE statements (df700d19)
- Avoid error messages when checking for updates (3af4c3db)
- CipherSettings: fix crash with empty RawKey (1e77bc78)
- CipherDialog: Improve password fields validation (b7f5ef3f)
- Permit dollar signs ($) after the first char in unquoted IDs (c5853727)
- AboutDialog: Change layout to fit large font better (2df29fad)
- CLI: Reuse `--table` as table name for a CSV Import (6bdacf65)
- Settings: fix file check in "-S" option for Windows (dc855711)
- Execute SQL editor: Use tabs for indentation (9ba1a2ed)
- Do not add SQL keywords multiple times to auto completion (a92ab5e6)
- Swap sort order indicators (03ce1405)
- Only show numbered sort indicators when more than one column is sorted (d2746c0f)
- Icon in data browser for primary key fields (636662b3)
- Open SQL files are now linked when saving project file (3a4d7d8d)
- Data Browser: use font style to indicate keys (b6c5024d)
- Add copy column name to table viewer (32c99f0f)
- Use a separate enum for table constraint types in the Edit Table dialog (42c5de72)
- Respect the sqlite_sequence table when generating PK value for new rows (e6556585)
- Plot Dock: use more precision for small numbers and less for big numbers (974954f1)
- Edit Database Cell: fixed potential for data loss and better feedback (8f5c17e2)
- DB Schema: drag & drop SELECT queries (8bb16d1d)
- Change mouse cursor to the pointing hand when Ctrl+Shift are pressed (f18611ae)
- Do not show the titlebar for the Table Browser dock when there is only one (c40fb07b)
- Associate copy table column menu entry to action. (2e39408f)
- Refactor the constraints tab in the Edit Table dialog (dd625778)
- parser: Refactor parsing and handling of constraints (13b15ddc)
- Project files: fix crash when tables does not match DB file (f3247297)
- sqlite3 API: Prevent that busy DB are left open (0280d98a)
- Project files: prevent SQL tabs loss while closing the application (fb43e067)
- Save some screen space and reduce number of unnecessary borders (a78dd029)
- Export: fix no error check for export errors (e56051ce)
- Export: more error checks (b466cfa9)
- Optimise executing large SQL files in the Execute SQL tab (a4a19693)
- Speed up execution of many SQL statements by delaying the log output (21c7f76e)
- Plot: show x and y values on a tooltip when hovering over the plot (ce176be2)
- Export: use QSaveFile to get better error check on full partition (496d39db)
- appimage: Update to SQLite 3.41.1 (9426509ac8a8422d8b164c2acfb6a849ea37e306)

### Removed
- 

### Translation
- Fix translation to match UI (f10bdbdb)
- Add Dutch translation (308e6ec7, 30413802)
- Add Indonesian translation (b9391212)
- Add Swedish translation (f69f66cc)
- Update Arabic translation (f0e7fe22)
- Update Brazilian Portuguese translation (ab2df420e4cb714d29437f2e94b938191f0ef886)
- Update Chinese translations (24c1fa73, 4a475757)
- Update French translation (fa3a0f57, 759efc68, e31d9fe7, 06200bfb, c902183c, 4eef0080, 2903ce1d, 6a641297)
- Update German translation (bbb8d1a6, 2a6acbfa, 48c8de6e, efcb24ae)
- Update Italian translation (5fd2cea5, be07d48c) 
- Update Japanese translation (c894c4cb)
- Update Korean translation (bee8cfc6, 39026bc2, 81af52af, 5df98099, 4c404000)
- Update Polish translation (957de605)
- Update Spanish translation (a3360cc2, 579ab4e0, 4a2179ba)

## [3.12.2] - 2021-05-17

Release version of DB4S - DB Browser for SQLite.
The basic features of the program are described in the
[README.](https://github.com/sqlitebrowser/sqlitebrowser)

Download release versions from
[https://sqlitebrowser.org/dl/](https://sqlitebrowser.org/dl/)
