@echo off
rem 27-03-2007 JvW Rename script to 'dfsdproc' to avoid users running it directly (8.14)
rem 09-08-2016 JvW Use 'dfsrunas.exe' to elevate Windows to admin, ignoring explicit window sizes
rem 16-08-2016 JvW Remove the Windows/DOS code, CMD is used for OS/2 only
echo.
echo Generate DFSDISK analysis files

if "%0"=="DISKTEST"     echo on
if "%0"=="disktest"     echo on

set dfsexe=dfsos2.exe

set disk=*
if "%1" == "?"   goto usage
if "%1" == "/?"  goto usage
if "%1" == "-?"  goto usage
if "%1" == ""    goto rvalid
set disk=%1

:rvalid
%dfsexe% -b -q query RValid
if not errorlevel 1 goto work
echo.
echo NOTE: Your DFSee version is not properly registred, this will cause
echo       some extra delays and reminder messages to be displayed  ...
echo.

:work
%dfsexe% -b -w -t dfsdisk %disk% %2 %3 %4 %5 %6 %7 %8 %9
if errorlevel 235 goto failure
if errorlevel 234 goto noscript
if errorlevel 001 goto failure

echo.
echo Check at least one of the resulting files  *.sk*  for obvious errors!
echo                                           -------
echo When needed, fix and run %0 again.                 When it looks OK:
echo.
echo email these file(s) to support@dfsee.com for analysis (ZIP if possible)
echo Include as many details about the disk partitions as you remember.
echo.
goto end

:noscript
echo.
echo ERROR: The required DFSee script 'DFSDPROC.DFS' was not found.
echo Check if it is in the current directory, the same directory
echo as the executable %dfsexe% or a directory on the PATH
goto end

:failure
echo.
echo WARNING: Execution of the DFSDISK script seems to have failed.
echo This could be the result of unexpected disk geometry or
echo other strange behaviour of disk-drivers, BIOS and so on
echo.
echo Also check if %dfsexe% and the script file DFSDPROC.DFS can be
echo found in the current directory, or a directory on the PATH.
goto end

:usage
%dfsexe% dfsdisk -?
echo.
echo You can use the '-screen-' option to the command to prevent
echo the final completion message, requiring manual confirmation.
:end
