/* installation and INI setup */
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'VInit','VRexx','VInit'

arg par1
if par1='/?' | par1='?' then signal usage
if translate(par1)='/I' then do
    inionly=1
    signal inimake
end

if translate(par1)='/O' then do
    objonly=1
    signal objmake
end

CurrDir=directory()
do until allok=1
    call SysCls
    call SysCurPos 12,0
    say "Which directory do you wish to install DriveCheck to?"
    call charout ," : "
    parse pull instdir
    if directory(instdir)='' then do until valid=1
        call SysCls
        if valid=0 then do
            call SysCurPos 10,0
            say "Please answer with Y or N."
        end
        call SysCurPos 10,0
        call charout ,"Directory not found.  OK to create? (Y/N) :"
        reply=SysGetKey('echo')
        if translate(reply)\='Y' & translate(reply)\='N' then valid=0
        else do
            valid=1
            if translate(reply)='Y' then do
                rc=SysMkDir(instdir)
                if rc\=0 then do
                    allok=0
                    call SysCls
                    call SysCurPos 12,0
                    say "Invalid directory name."
                    say ""
                    say "Press any key to continue..."
                    junk=SysGetKey('noecho')
                end
                else allok=1
            end
            else allok=0
        end        
    end    
    else do until confirm=1
        call SysCls
        if confirm=0 then do
            call SysCurPos 10,0    
            say "Please answer with either Y or N."
        end
        call SysCurPos 12,0
        call charout ,"Directory already exists, OK to continue? (Y/N) :"
        ans=SysGetKey('echo')
        if translate(ans)\='Y' & translate(ans)\='N' then confirm=0        
        else do
            confirm=1
            if translate(ans)='Y' then allok=1
            else allok=0
        end
    end
end
call directory CurrDir
'*@copy drivechk.cmd '||instdir||' > nul'
'*@copy readme.txt '||instdir||' > nul'
'*@copy drivechk.ico '||instdir||' > nul'
'*@copy install.cmd '||instdir||' > nul'
call directory instdir

inimake:

if inionly=1 then do
    call SysCls
    call SysCurPos 12,0
    say "Please enter the directory where DriveCheck is located."
    call charout ,': '
    pull instdir
    if directory(instdir)='' then do
        say ""
        say "Directory not found."
        exit
    end
    else call directory instdir
end
call SysCls
call SysCurPos 12,0
say "We will now create an initialization file that will determine"
say "the default behavior of the visual portion of DriveCheck."
say ""
say "Press Q to skip this part or any other key to continue..."
ch=SysGetKey('noecho')
if translate(ch)='Q' then skipini=1
else skipini=0
if skipini=0 then do

    crlf='0d0a'x
    rtable=crlf                             ||,
           '         1) 640x480'crlf        ||,
           '         2) 800x600'crlf        ||,
           '         3) 1024x768'crlf       ||,
           '         4) 1280x1024'crlf      ||,
           '         5) 1600x1200'crlf      ||,
           crlf                             ||,
           'Your choice? :'
    rstring.1="Please select a number corresponding to a resolution on the list."
    rstring.2="If your resolution isn't listed, pick the closest one."
    do until rok=1
        call SysCls
        if rok=0 then do
            call SysCurPos 3,0
            do i=1 to 2
                call lineout ,rstring.i
            end
        end
        call SysCurPos 6,0
        say "Select the screen resolution your desktop is set to:"
        call charout ,rtable
        ans=SysGetKey('echo')
        if datatype(ans)\='NUM' then rok=0
        else if datatype(ans,'W')\=1 then rok=0
        else if ans<1 | ans>5 then rok=0
        else do
            rok=1
            ScrRes=ResID(ans)
        end
    end
    cstring='Please select a color-corresponded number from the list.'    
    table=crlf                                           ||,
          '     1) Black                 5) Blue'crlf    ||,          
          '     2) White                 6) Cyan'crlf    ||,
          '     3) Red                   7) Yellow'crlf  ||,
          '     4) Green                 8) Pink'crlf    ||,
          crlf                                           ||,
          'Your choice? :'
    
    do until mok=1
        call SysCls
        if mok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the main window background color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            MainColor='WHITE'
            mok=1
        end
        else if datatype(ans)\='NUM' then mok=0
        else if datatype(ans,'W')\=1 then mok=0
        else if ans<1 | ans>8 then mok=0
        else do
            mok=1
            MainColor=ColorID(ans)
        end    
    end    
    mok=''
    do until mok=1
        call SysCls
        if mok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the main window text color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            MainTextColor='BLACK'
            mok=1
        end
        else if datatype(ans)\='NUM' then mok=0
        else if datatype(ans,'W')\=1 then mok=0
        else if ans<1 | ans>8 then mok=0
        else do
            mok=1
            MainTextColor=ColorID(ans)
            if MainTextColor=MainColor then do
                say crlf    
                say "Note:  You have chosen the same color for both the"
                say "foreground and background of the Main window.  You"
                say "won't be able to see a damn thing unless you change it."
                say ""
                say "Press any key to continue..."
                junk=SysGetKey('noecho')
            end    
        end
    end
    do until dok=1
        call SysCls
        if dok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the directory window background color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            DirColor='CYAN'
            dok=1
        end
        else if datatype(ans)\='NUM' then dok=0
        else if datatype(ans,'W')\=1 then dok=0
        else if ans<1 | ans>8 then dok=0
        else do
            dok=1
            DirColor=ColorID(ans)
        end
    end    
    dok=''
    do until dok=1
        call SysCls
        if dok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the directory window text color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            DirTextColor='BLACK'
            dok=1
        end
        else if datatype(ans)\='NUM' then dok=0
        else if datatype(ans,'W')\=1 then dok=0
        else if ans<1 | ans>8 then dok=0
        else do
            dok=1
            DirTextColor=ColorID(ans)
            if DirTextColor=DirColor then do
                say crlf    
                say "Note:  You have chosen the same color for both the"
                say "foreground and background of the Directory window.  You"
                say "won't be able to see a damn thing unless you change it."
                say ""
                say "Press any key to continue..."
                junk=SysGetKey('noecho')
            end    
        end
    end
    do until fok=1
        call SysCls
        if fok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the file window background color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            FileColor='CYAN'
            fok=1
        end
        else if datatype(ans)\='NUM' then fok=0
        else if datatype(ans,'W')\=1 then fok=0
        else if ans<1 | ans>8 then fok=0
        else do
            fok=1
            FileColor=ColorID(ans)
        end
    end
    fok=''
    do until fok=1
        call SysCls
        if fok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the file window text color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            FileTextColor='BLACK'
            fok=1
        end
        else if datatype(ans)\='NUM' then fok=0
        else if datatype(ans,'W')\=1 then fok=0
        else if ans<1 | ans>8 then fok=0
        else do 
            fok=1
            FileTextColor=ColorID(ans)
            if FileTextColor=FileColor then do
                say crlf    
                say "Note:  You have chosen the same color for both the"
                say "foreground and background of the File window.  You"
                say "won't be able to see a damn thing unless you change it."
                say ""
                say "Press any key to continue..."
                junk=SysGetKey('noecho')
            end        
        end
    end
    do until gok=1
        call SysCls
        if gok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the graph window background color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            GraphColor='BLACK'
            gok=1
        end
        else if datatype(ans)\='NUM' then gok=0
        else if datatype(ans,'W')\=1 then gok=0
        else if ans<1 | ans>8 then gok=0
        else do
            gok=1
            GraphColor=ColorID(ans)
        end
    end
    gok=''
    do until gok=1
        call SysCls
        if gok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the graph window text color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            GraphTextColor='WHITE'
            gok=1
        end
        else if datatype(ans)\='NUM' then gok=0
        else if datatype(ans,'W')\=1 then gok=0
        else if ans<1 | ans>8 then gok=0
        else do
            gok=1
            GraphTextColor=ColorID(ans)
            if GraphTextColor=GraphColor then do
                say crlf
                say "Note:  You have chosen the same color for both the"
                say "foreground and background of the Graph window.  You"
                say "won't be able to see a damn thing unless you change it."
                say ""
                say "Press any key to continue..."
                junk=SysGetKey('noecho')
            end        
        end
    end
    do until freeok=1
        call SysCls
        if freeok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the graph free space color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            FreeColor='WHITE'
            freeok=1
        end
        else if datatype(ans)\='NUM' then freeok=0
        else if datatype(ans,'W')\=1 then freeok=0
        else if ans<1 | ans>8 then freeok=0
        else do
            freeok=1
            FreeColor=ColorID(ans)
        end        
    end
    do until usedok=1
        call SysCls
        if usedok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the graph used space color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            UsedColor='GREEN'
            usedok=1
        end
        else if datatype(ans)\='NUM' then usedok=0
        else if datatype(ans,'W')\=1 then usedok=0
        else if ans<1 | ans>8 then usedok=0
        else do
            usedok=1
            UsedColor=ColorID(ans)
        end        
    end
    do until wasteok=1
        call SysCls
        if wasteok=0 then do
            call SysCurPos 4,0
            say cstring
        end
        call SysCurPos 6,0
        say "Choose the graph wasted space color from the list,"||crlf||,
            "or press S to skip this choice and use the default:"
        call charout ,table
        ans=SysGetKey('echo')
        if translate(ans)='S' then do
            WasteColor='RED'
            wasteok=1
        end
        else if datatype(ans)\='NUM' then wasteok=0
        else if datatype(ans,'W')\=1 then wasteok=0
        else if ans<1 | ans>8 then wasteok=0
        else do
            wasteok=1
            WasteColor=ColorID(ans)
        end        
    end
    if FreeColor=UsedColor | FreeColor=WasteColor |,
        WasteColor=UsedColor then do
            say crlf
            say "Warning:  One or more graph colors are the same, and will"
            say "inhibit the usefulness of the graph.  You should change"
            say "them to different colors."
            say ""
            say "Press any key to continue..."
            junk=SysGetKey('noecho')
    end
    inifile='drivechk.ini'
    call SysFileDelete inifile
    call lineout inifile,MainColor
    call lineout inifile,MainTextColor
    call lineout inifile,DirColor
    call lineout inifile,DirTextColor
    call lineout inifile,FileColor
    call lineout inifile,FileTextColor
    call lineout inifile,GraphColor
    call lineout inifile,GraphTextColor
    call lineout inifile,FreeColor
    call lineout inifile,UsedColor
    call lineout inifile,WasteColor
    call lineout inifile,ScrRes     
    do 5
        call lineout inifile,''
    end
    call charout inifile,'Line 1: Background color of main window.'crlf
    call charout inifile,'Line 2: Foreground color of main window.'crlf
    call charout inifile,'Line 3: Background color of directory window.'crlf
    call charout inifile,'Line 4: Foreground color of directory window.'crlf
    call charout inifile,'Line 5: Background color of file window.'crlf
    call charout inifile,'Line 6: Foreground color of file window.'crlf
    call charout inifile,'Line 7: Background color of graph window.'crlf
    call charout inifile,'Line 8: Foreground color of graph window.'crlf
    call charout inifile,'Line 9: Free space color of graphs.'crlf
    call charout inifile,'Line 10: Used space color of graphs.'crlf
    call charout inifile,'Line 11: Wasted space color of graphs.'crlf
    call charout inifile,'Line 12: Screen resolution.'crlf
    call SysCls
    call SysCurPos 12,0
    say "INI file written ("||instdir||"\drivechk.ini)."
    say ""
    say "Press any key to continue..."
    junk=SysGetKey('noecho')
end
if inionly=1 then exit

objmake:
if objonly=1 then do
    call SysCls
    call SysCurPos 12,0
    say "Please enter the directory where DriveCheck is located."
    call charout ,': '
    pull instdir
    if directory(instdir)='' then do
        say ""
        say "Directory not found."
        exit
    end
end        

call SysCls
call SysCurPos 6,0
say "We will now create a desktop object for DriveCheck.  If you don't"
say "plan on using the Visual REXX portion, you're better off skipping"
say "this and just running DriveCheck from the command line."
say ""
say "The object will be located at the center of your desktop, and its"
say "object ID will be '<DriveCheck>' (case sensitive)."
say ""
say "Press Q to abort object creation, or any other key to continue..."
ans=SysGetKey('noecho')
if translate(ans)='Q' then skipobj=1
else skipobj=0
if skipobj=0 then do
     type='WPProgram'
     name='DriveCheck'
     loc='<WP_DESKTOP>'
     options='OBJECTID=<DriveCheck>;'                           ||,
             'ICONPOS=50,50;'                                   ||,
             'EXENAME='||instdir||'\drivechk.cmd;'              ||,
             'ICONFILE='||instdir||'\drivechk.ico;'             ||,
             'MINIMIZED=YES;'                                   ||,
             'PROGTYPE=WINDOWABLEVIO'

rc=SysCreateObject(type,name,loc,options,'R')
say ""
if rc=1 then say "DriveCheck object successfully created."
else say "Unable to create DriveCheck object."
say ""
if objonly=1 then exit
end
say ""
say "DriveCheck installation is complete."
exit

usage:

say ""
say "DriveCheck installation program."
say ""
say "Usage: install.cmd [/I | /O]"
say ""
say "/I   -  Only prompts for information to create INI file."
say "/O   -  Only creates desktop object."
say ""
say "Run with no parameters to copy the DriveCheck files to a specified"
say "directory, create an INI file, and create a desktop object."
say ""
exit

/* Translate number into color */
ColorID: Procedure

arg cnum
if cnum=1 then cr='BLACK'
if cnum=2 then cr='WHITE'
if cnum=3 then cr='RED'
if cnum=4 then cr='GREEN'
if cnum=5 then cr='BLUE'
if cnum=6 then cr='CYAN'
if cnum=7 then cr='YELLOW'
if cnum=8 then cr='PINK'

return cr
/**/

/* Translate number into resolution */
ResID: Procedure

arg rnum
if rnum=1 then res='640x480'
if rnum=2 then res='800x600'
if rnum=3 then res='1024x768'
if rnum=4 then res='1280x1024'
if rnum=5 then res='1600x1200'

return res
/**/
