/* Code */


/* --------------------------------------------------------- */
/* Revision History                                          */
/* ++++++++++++++++                                          */
/*                                                           */
/* [001]  10/28/96 by Anand Pandit                           */
/*                 For adding README object in the folder    */
/*                                                           */
/*                                                           */
/*                                                           */
/*                                                           */
/* --------------------------------------------------------- */



parse  arg DestDrv option.0 option.1

/*****************************************************************/
/* If only options are passed, no drive letter, set directory name to c:\hd_mon  */
/* If 1st parm passed is not a blank and not an option (/x),                      */
/*		set destination directory with drive information                    */
/* If the 1st parm is options, offset the options to the correct parms            */
/*****************************************************************/

if DestDrv= '' | Substr(DestDrv,1,1) = '/' Then
   DestDir = 'C:\HD_MON'
else do
   DestDir = Substr(DestDrv ,1,1) || ':\HD_MON'
end

if Substr(DestDrv,1,1) = '/' Then do
   option.1 = option.0
   option.0 = DestDrv
   DestDrv = 'C:'
end

'@echo off'

/* if 1st parm passed is ? OR not x:  OR is an option OR not blank                   */
/* AND the 1st byte passed is not an option AND the 1st parm passed is not blank   */
/* PRINT HELP                                                                           */
/*                                                                                         */
/* Examples:    hd_inst                 do NOT print help                               */
/*               hd_inst   d:            do NOT print help                               */
/*               hd_inst   /r            do NOT print help                               */
/*               hd_inst   ?             PRINT Help                                     */
/*               hd_inst   hdmon        PRINT Help                                     */
/*                                                                                         */

if  DestDrv = '?' | ( (Substr(DestDrv,2,2) \= ': ' | Pos('/',DestDrv) \= 0 | Substr(DestDrv,1,1) = '' ) & Substr(DestDrv,1,1) \= '/' & DestDrv \= '' ) then do
  say
  say
  say "syntax  : hd_install  [ [<dest_drive>] [<option>] ]"
  say
  say "where <dest_path>   : Location of destination drive:  default--->c:"
  say "       <option>       : '/s' ->  create a shadow of the program in the startup folder"
  say "                         '/r' ->   reinstall"
  say
  say
  say "example : hd_install  c: /s "
  say
  say "Note : Verify that the destination drive has enough space to install"
  say
  exit
end

/* if destination drive is blank, print defaults  */

if DestDrv = '' then do
   say
   say " TARGET program will be installed on drive C: "
   say " Press enter to proceed or type the desired drive location, x: "
   pull DestDrv

   if DestDrv \= '' then
        DestDir = Substr(DestDrv,1,1) || ':\HD_MON'
end

/* validate source location */

say " SOURCE files will be obtained from the current directory. "
say " Press enter to proceed or type the desired complete path, x:<path> "
parse upper pull ScrDrv

if ScrDrv = '' then
   SourceDir = '.'
else
   SourceDir = ScrDrv

/* set source files for indexing */

source_file.0 = SourceDir || '\HDMON.EXE'
source_file.1 = SourceDir || '\HDMON.HLP'
source_file.2 = SourceDir || '\HDMON.ICO'
source_file.3 = SourceDir || '\README.TXT'
source_file.4 = SourceDir || '\HDMON.TXT'
source_file.5 = SourceDir || '\HDDEINST.CMD'
source_file.6 = SourceDir || '\XHDMON.ICO'
source_file.7 = SourceDir || '\ASPIPFA.SYS'

dest_file.0 = DestDir || '\HDMON.EXE'
dest_file.1 = DestDir || '\HDMON.HLP'
dest_file.2 = DestDir || '\HDMON.ICO'
dest_file.3 = DestDir || '\README.TXT'
dest_file.4 = DestDir || '\HDMON.TXT'
dest_file.5 = DestDir || '\HDDEINST.CMD'
dest_file.6 = DestDir || '\XHDMON.ICO'
dest_file.7 = DestDir || '\ASPIPFA.SYS'

/* register for OS/2 functions */

call RxfuncAdd 'SysLoadFuncs' , 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* If options do not equal /R (replace), create directory and copy files */

parse upper var option.0 opt '/' opt1
parse upper var option.0 opt '/' opt2

if opt1 \= 'R' & opt2 \= 'R' Then Do
    call SysMkDir DestDir
    Say " Extracting file..."
    Say

    Do i=0 to 7
       call Sysfiletree source_file.i, 'file' , 'f'
       if file.0 = 0  then do
          Say  source_file.i " not present.  Exiting...."
          EXIT
       End

       Say 'Copying' source_file.i 'to' DestDir' Directory...'
        COPY source_file.i dest_file.i '>nul'
    End
End

/* If options equal /R (replace), ensure all source files exist */

Else Do
     Say
     Say "Checking files..."
     Say

     Do i=0 to 7
         call Sysfiletree dest_file.i, 'file' , 'f'
         if file.0 = 0  then do
            Say  dest_file.i " not present.  Exiting...."
            EXIT
         End
      End
End

/* [001]                           */
/*                                 */
/* Make the README.TXT "readonly"  */


temp1 = "+R " || dest_file.3
 ATTRIB  temp1



Say

/* Create a folder on the desktop.  Place install and deinstall objects in the folder. */

   If ( SysCreateObject("WPFolder","HARD FILE MONITOR","<WP_DESKTOP>","ICONFILE="dest_file.2";OBJECTID=<HD_MONITOR>;ICONFILE=1",'R') ) = 0 then Do
        Say "Can't create folder. "
        exit
   end

   If SysCreateObject("WPProgram","HD_MONITOR","<HD_MONITOR>","ICONFILE="dest_file.2";OBJECTID=<HD_MON_PROG>;EXENAME="dest_file.0";HELPLIBRARY="dest_file.1";HELPPANEL=12000;PARAMETERS=-M;STARTUPDIR="DestDir";PROGTYPE=PM;CCVIEW=YES",'R') Then
         Say " Install Program Object created in new folder"
   Else Do
        Say "Installation of Install Program folder failed.  "
        SysDestroyObject("<HD_MONITOR>")
        exit
   End

 If SysCreateObject("WPProgram","HD_MONITOR DE-INSTALLATION","<HD_MONITOR>","ICONFILE="dest_file.6";OBJECTID=<HD_MON_DE_PROG>;EXENAME="dest_file.5";HELPLIBRARY="dest_file.1";HELPPANEL=12000;STARTUPDIR="DestDir";PROGTYPE=PM;CCVIEW=YES",'R') Then
         Say " De-Install Program Object created in new folder"
   Else Do
        Say "Installation of Install Program folder failed.  "
        SysDestroyObject("<HD_MONITOR>")
        exit
   End

/* [001]                                             */
/*                                                   */
/* Add an Object for README in the folder            */

  If SysCreateObject("WpProgram","README","<HD_MONITOR>","OBJECTID=<HD_MON_README>;EXENAME="e.exe";PARAMETERS="dest_file.3";CCVIEW=YES",'R') Then

         Say " README object created in new folder"
   Else Do
        Say "Creation of README failed.  "
        SysDestroyObject("<HD_MONITOR>")
        exit
   End


/* if options = /S, create shadows */

if opt1 = 'S' & opt2 = 'S' Then Do

   If SysCreateshadow("<HD_MON_PROG>","<WP_START>") Then
      Say " Program Object copied to startup folder"
   else
      Say "Can't copy to startup folder.  Error..."
end

say
say "Your config.sys needs the following device statement:  "
say
say "DEVICE = \path\ASPIPFA.SYS  "
say
say "Do you wish me to update your config.sys?  Y (yes) or N (no)  "
say

Do FOREVER

   parse upper pull ConfAns

   if ConfAns = 'Y' | ConfAns = 'N' Then
       Leave

End

if ConfAns = 'N' then do
	say "You need to change your config.sys and reboot for this install to take effect. "
	say "Installation Complete"
	exit
end

say "Config.sys will be updated on drive C:  "
say
say "Press enter to proceed else type the desired drive (x:)  "
say
parse upper pull ConfDrv

if ConfDrv = '' then
    ConfDrv = 'C:'

if SubStr(ConfDrv,2,1) \= ':' then
    ConfDrv = ConfDrv || ':'


infile = ConfDrv'\config.sys'
tempfile = SysTempFileName(ConfDrv'\config.H??')

outfile = tempfile
remark = "REM (by Hard File Monitor) "
newDev = "DEVICE=" || DestDir || "\ASPIPFA.SYS"

/*******************************************************************/
/* If BASEDEV=OS2ASPI.DMD driver not in config.sys   and not exist */
/*  in C: Dont add the entry in  config.sys   and exit             */
/*******************************************************************/

filespec.0 = ConfDrv'\OS2\BOOT\OS2ASPI.DMD'
filespec.1 = ConfDrv'\OS2\OS2ASPI.DMD'

Do i=0 to 1
         call Sysfiletree filespec.i, 'file' , 'f'
         if file.0 \= 0 then do
            leave
         end
end

if i > 1 then do
         say "Driver OS2ASPI.DMD not exist on hard disk . "
         Say "Exiting without updating config.sys ..... "
         exit

end

found= 'NO'
do until lines(infile) = 0	
	input = linein(infile)			
	parse upper var input parm '=' rest	

	if parm = "BASEDEV" then do
	   if Pos('OS2ASPI.DMD', rest) \= 0 then do
		/* if /ALL option not specified add this option and jump to next check */
             found = 'YES'
             if Pos('/ALL' ,rest) =0 then do
                   input = input || ' /ALL'
             end
             call lineout outfile,  input		
           end
          else call lineout outfile,  input		
        end
        else call lineout outfile,  input		
end

if Found = 'NO' then do
 say "Entry for OS2ASPI.DMD not found in config.sys "
 say "Adding BASEDEV=OS2ASPI.DMD /ALL in config.sys"
 call lineout outfile ,"BASEDEV=OS2ASPI.DMD /ALL"
end

call lineout outfile				/* close input & output files */
call lineout infile
'copy' outfile infile '>NUL'
call SysfileDelete outfile


/****************************************************************/
/* If DEVICE=\path\ASPIPFA.SYS is in config.sys   			      */
/*	end without making any changes					      */
/* If DEVICE=\path\ASPIPFA.SYS has a different path,                          */
/*	remark it out								      */
/* Otherwise just copy each line in to output 	                              */
/* Add new DEVICE= statement to end of output				      */
/****************************************************************/

do until lines(infile) = 0	
	input = linein(infile)			
	parse upper var input parm '=' rest	
	if parm = "DEVICE" then do
	    if Pos('ASPIPFA.SYS', rest) \= 0 then do

		if Substr(rest,1,length(DestDir)) = DestDir then do
		    call SysfileDelete outfile

	            say "Reboot the system for this install to take effect. "
		    say "Installation Complete"
		    exit
		end
		else call lineout outfile, remark || input
	    end
	    else call lineout outfile, input 	
	end
	else call lineout outfile, input
end

call lineout outfile, newDev
call lineout outfile				/* close input & output files */
call lineout infile
'copy' outfile infile '>NUL'
say "Installation Complete"

say "Reboot the system for this install to take effect. "

call SysfileDelete outfile
exit
