/* Install of PMDUP */

call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

CALL SysCls

say 'Rexx Installer'
say '--------------------------------------------'
say
say '   Installation...'
say
say '   copies files to destination directory'
say '   creates folder and objects on desktop'
say

/* Ask Directory */

say 'Enter target directory (e.g.: C:\PMDUP):'
say '(<return> = current directory, object creation only, no copy operation)'
PARSE PULL InstDir
InstDir = STRIP(InstDir, 'T', '\')

IF InstDir="" THEN
 DO
   InstDir=directory()
   SIGNAL MakeIcons
 END

/* Create Directory */
say
say '--------------------------------------------'
say 'creating directories'
say '--------------------------------------------'

if InstDir <> "." then
   DO
     call SysFileTree InstDir, "SearchDir", "D"
     if SearchDir.0 = 0 then do
         rc = SysMkDir(InstDir)
            if rc <> 0 then do
                 say "Error: Cannot create directory!" InstDir
                 exit
            end
     end
end

/* Copy files */
say
say '--------------------------------------------'
say 'copying files'
say '--------------------------------------------'

'@Copy pmdup.exe 'InstDir'\pmdup.exe'
'@Copy read.me 'InstDir'\read.me'

MakeIcons:
/* Make icons */
say
say '--------------------------------------------'
say 'creating icons on your desktop'
say '--------------------------------------------'

mydir=Directory()

classname = 'WPProgram'
title     = 'PMDUP 1.03'
location  = '<WP_DESKTOP>'
exename   = 'EXENAME='||InstDir||'\pmdup.exe'
WorkDir   = InstDir
setup     = 'OBJECTID=<PMDUP_PROGRAM>; STARTUPDIR='||InstDir||';STARTUPDIR='||Workdir||';'||exename
rc        = SysCreateObject(classname, title, location, setup, 'U')

say
say 'Ready.'
