/* $Id: netstub.c,v 1.4 2004/01/01 13:13:21 root Exp $ */

/* This allows network libraries to be linked on-demand */

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#define INCL_BASE
#include <os2.h>

#ifndef _LNK_CONV
#define _LNK_CONV _System
#endif

/* A Q'n'D wrapper for DosQueryProcAddr */

static void get_bv(PFN *pf, char *dll, unsigned int ord, char *ent)
{
 HMODULE hmod;
 int rc;
 char sfmt[320];

 *pf=NULL;
 if((rc=DosLoadModule(NULL, 0, dll, &hmod)))
 {
  fprintf(stderr, "SYS2070: %s not loaded rc=%d\n", dll, rc);
  exit(101);
 }
 rc=DosQueryProcAddr(hmod, ord, ent, pf);
 DosFreeModule(hmod);
 if(rc)
 {
  if(ent!=NULL)
   sprintf(sfmt, "%s.%s", dll, ent);
  else
   sprintf(sfmt, "%s.%u", dll, ord);
  fprintf(stderr, "SYS2070: %s\n", sfmt);
  exit(102);
 }
}

/* Panic (should not happen) */

static void panic(char *dll, unsigned int ord)
{
 fprintf(stderr, "SYS1459: %s.%u -> NULL\n", dll, ord);
 exit(103);
}

/* This macro generates the forwarder routines based on the number of
   parameters. Expect some overhead due to repetitive calls to
   DosLoadModule and check for NULL pointer during execution. */

#define fwd_by_ord(name, dll, ord, nparm) \
 struct sf__##name {int sf[nparm];}; \
 static int (* _LNK_CONV f__##name)(struct sf__##name sf); \
 int _LNK_CONV name(struct sf__##name sf) \
 { \
  if(f__##name==NULL) \
  { \
   get_bv((PFN *)&f__##name, dll, ord, NULL); \
   if(f__##name==NULL) \
    panic(dll, ord); \
  } \
  return(f__##name(sf)); \
 }

/*
 * The TCP/IP hooks
 */

#ifdef NEWSTACK

static char tcp[]="TCPIP32";

fwd_by_ord(htons, tcp, 205, 1)
fwd_by_ord(connect, tcp, 3, 3)
fwd_by_ord(send, tcp, 13, 4)
fwd_by_ord(socket, tcp, 16, 3)
fwd_by_ord(soclose, tcp, 17, 1)
fwd_by_ord(sock_init, tcp, 26, 1)

#else

static char tcp[]="TCP32DLL";
static char so[]="SO32DLL";

fwd_by_ord(bswap, tcp, 4, 1)
fwd_by_ord(connect, so, 3, 3)
fwd_by_ord(send, so, 13, 4)
fwd_by_ord(socket, so, 16, 3)
fwd_by_ord(soclose, so, 17, 1)
fwd_by_ord(sock_init, so, 26, 1)

#endif
