/* $Id: uniftime.c,v 1.1 2002/08/07 22:07:41 root Exp $ */

#include <time.h>

#include "uniftime.h"

static char monthdays[12]={31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

/* Returns 1 if there's a leap year */

static int isleapyear(int year)
{
 if(year%400==0)
  return(1);
 if(year%100==0)
  return(0);
 if(year%4==0)
  return(1);
 return(0);
}

/* Converts a DOS timestamp to unified timestamp */

unsigned long dos2unif(unsigned long dos_time)
{
 unsigned int y, m, d, hh;
 unsigned long u=0;
 int i;
 unsigned long rc;                      /* Can't use signed (time_t) here */
 long tzshift;
 #ifndef TZ_VAR
  long shiftd1, shiftd2;
  struct tm *stm;
 #endif

 y=ts_year(dos_time);
 m=ts_month(dos_time);
 d=ts_day(dos_time);
 hh=ts_hour(dos_time);
 if(y>=2001)
 {
  i=y-2001;
  u=11323;
  /* The following piece of code is rather paranoid in 16/32-bit world, where the
     timestamps are limited to year 2108. */
  if(i>=400)
  {
   u+=1022679L*(i/400);
   i%=400;
  }
  if(i>=100)
  {
   u+=36524L*(i/100);
   i%=100;
  }
  u+=1461L*(i/4);
  u+=365L*(i%4);
 }
 else if(y>=1973)
  u=1096+(y-1973)/4*1461L+((y-1973)%4)*365L;
 else
  u=(y-1970)*365L;
 for(i=1; i<m; i++)
 {
  u+=(int)monthdays[i-1];
  if(i==2)
   u+=isleapyear(y);
 }
 rc=24*(unsigned long)(u+d-1)+(unsigned long)hh;
 /* If we have to use the timezone variable, do it now */
 #ifdef TZ_VAR
  tzshift=-TZ_VAR;
  tzshift/=3600;
  if(_daylight)
   tzshift++;
 #else
  stm=localtime(&rc);
  debug_assert(stm!=NULL);              /* LIBCS.DLL returns NULL for unixtime beyond
                                           0x7FFFFFFF */
  tzshift=(long)stm->tm_hour;
  shiftd1=stm->tm_mday;
  stm=gmtime(&rc);
  debug_assert(stm!=NULL);
  shiftd2=stm->tm_mday;
  /* Local time overruns GMT, add 24 hours for safety */
  if(shiftd1<shiftd2&&shiftd1==1&&shiftd2>=28)
   tzshift+=24;
  else if(shiftd1>shiftd2&&shiftd1>=28&&shiftd2==1)
   tzshift-=24;
  else if(shiftd1>shiftd2)
   tzshift+=24;
  else if(shiftd1<shiftd2)
   tzshift-=24;
  tzshift-=(long)stm->tm_hour;
  tzshift%=24;
 #endif
 /* Fix the timezone if it does not roll over the zero */
 return((tzshift>0&&rc<tzshift)?rc:rc-tzshift);
}

/* Decompose a unified timestamp into hour/day/month/year */

void exp_unif(struct ts_exp *pexp, unsigned long t)
{
 unsigned long ut, timepart;
 int year, month, mdays;

 ut=t-TZ_VAR/3600;
 if(_daylight)
  ut++;
 timepart=ut%24L; ut/=24L;
 for(year=1970; 365+isleapyear(year)<=ut; year++)
  ut-=365+isleapyear(year);
 pexp->year=year;
 month=0;
 while(1)
 {
  if(month==1)
   mdays=isleapyear(year)?29:28;
  else
   mdays=monthdays[month];
  if(mdays>ut||month==11)
   break;
  ut-=mdays;
  month++;
 }
 pexp->month=month+1;
 pexp->day=ut+1;
 pexp->hour=(unsigned char)timepart;
}
