/* TVFS.CONF / TVFS Configuration Utility / release 2C    */
/* written by Byron Q. Desnoyers Winmill                  */
/*                                                        */
/* Revision History:                                      */
/* 16-Sep-97 : release 1                                  */
/*     original release                                   */
/* 26-Sep-97 : release 2                                  */
/*     numerous parsing fixes                             */
/*     consistent error messages                          */
/*     cleaned up code                                    */
/*     fixed comment bugs                                 */
/* 24-Feb-98 : release 2C
 *	Converted code to standard REXX.
 *	! Script no longer runs TVCTL.
 * UPCOMING! : release 3
 *	Checks environment for TVFS.CONF.
 *	Added TVLN linking utility.
 */

/* todo: make constants more accessable */

'@ ECHO OFF'

/* Define global constants.           */
TITLE='[tvfs.conf]';
COMMENT='#';
DISPLAY='!';
DIVIDER=',';


/* Parse command line.                */
parse arg tvfsconf tvdrives;

call Initialize;
call Mount tvdrives;
call Link tvfsconf;
call Terminate 0;

Initialize : procedure expose TITLE
	rc = RxFuncAdd('TvLoadFuncs','TVRX','TvLoadFuncs');
	if ( rc <> 0 ) then do
		say TITLE '| Error calling RxFuncAdd()';
		call Terminate 1;
	end;							/* if : rc */

	rc = TvLoadFuncs();
	if ( rc <> 0 ) then do
		say TITLE '| Error calling TvLoadFuncs()';
		call Terminate 2;
	end;							/* if : rc */
return 0;							/* procedure initialize */

Mount : procedure expose TITLE
	arg tvdrives;

	do while ( Length(tvdrives) > 0 )
		parse var tvdrives this_drive (DIVIDER) tvdrives;
		rc = TvMount(this_drive':');
		if ( rc <> 0 ) then say TITLE '| Warning, could not mount 'this_drive':'
    end;							/* while : tv_drives */
return 0;							/* procedure : Mount */

Link : procedure expose TITLE COMMENT DISPLAY
	arg tvfsconf;

	call Stream tvfsconf, 'c', 'open read';
	do while ( Lines(tvfsconf) \= 0 )
		buffer = LineIn(tvfsconf);

		if ( Length(buffer) > 0 ) then do
			parse var buffer command 2 string;
			select
				when ( command = COMMENT ) then
					nop;
				when ( command = DISPLAY ) then
					say title string;
				otherwise
					parse var buffer parameters source destination;
					if ( Length(source) = 0 ) | ( Length(destination) = 0 ) then
						say TITLE '| Warning, could not link' buffer;
					else do
						rc = TvLink(parameters source destination);
						if ( rc <> 0 ) then say TITLE '| Warning, error' rc 'linking' buffer;
					end;			/* if : source, destination */
			end;					/* select */
		end;						/* if : buffer */
	end;							/* while : tvfsconf */
	call Stream tvfsconf, 'c', 'close';
return 0;							/* procedure : Link */

Terminate : procedure
	arg exitcode;
	call TvDropFuncs;
	exit(exitcode);
return 0;							/* procedure : Terminate */

