/* uudecode [input]
 *
 * create the specified file, decoding as you go.
 * used with uuencode.
 */
/*Last modified by boris@innonyc.com
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
/* single-character decode */
#define DEC(c)	(((c) - ' ') & 077)
char * index(char * sp, char c);
void decode( FILE * in, FILE * out);
void outdec(char * p, FILE * f,int n);


void main(int argc, char ** argv)
{
FILE *in, *out;	int cur_arg=1;	char dest[256];	char buf[80];
 struct find_t ffblk; int ii, done=1;char file_name[256];

if((argc==2)&&((!strcmp(argv[1],"-?"))||(!strcmp(argv[1],"-h"))
||(!strcmp(argv[1],"/?"))||(!strcmp(argv[1],"/h")) )){
printf("Program performs uudecode on files.\nTo use type %s <file names>\n\
When activated without arguments uses standart input\nWild card are SUPPORTED\n"
,argv[0]);
exit(0);
}

do{
	/* optional input arg */
	if (argc > 1) {
	     if(done){/*first attempt to decode the argument*/
	     done =_dos_findfirst(argv[cur_arg],_A_NORMAL|_A_HIDDEN|
	     _A_RDONLY|_A_SYSTEM|_A_ARCH,&ffblk);	      ii=strlen(argv[cur_arg]);
	      while((ii>=0)&&(argv[cur_arg][ii]!='\\'))ii--;
	      ii++;
	     }
	     strncpy(file_name,argv[cur_arg],ii);file_name[ii]=0;
	     strcat(file_name,ffblk.name);
	     printf("Working with %s\n",file_name);
	     if ((in = fopen(file_name, "r")) == NULL) {
		perror(file_name);
		exit(1);
	     }
	} else{
		in = stdin;  cur_arg=argc;
	 }
	/* search for header line */
	do{
		if (fgets(buf, sizeof buf, in) == NULL) {
			fprintf(stderr, "No begin line\n");
			goto ending;
		}
	} while(strncmp(buf, "begin ", 6) != 0);

	sscanf(buf, "begin %*o %s",dest);

	/* create output file */
	out = fopen(dest, "wb");
	if (out == NULL) {
		perror(dest);
		goto ending;
	}
	decode(in, out);

	if (fgets(buf, sizeof buf, in) == NULL || strcmp(buf, "end\n")) {
		fprintf(stderr, "No end line\n");
		goto ending;
	}
	ending: fclose(out); fclose(in);
	done = _dos_findnext(&ffblk);
	if ((argc > 1)&&(done!=0)){cur_arg++;}

  }while(cur_arg<argc);
}

/*
 * copy from in to out, decoding as you go along.
 */
void decode( FILE * in, FILE * out)
{
	char buf[80];
	char *bp;
	int n, i, expected;

	for (;;) {
		/* for each input line */
		if (fgets(buf, sizeof buf, in) == NULL) {
			printf("Short file\n");
			return;
		}
		if (buf[0] == '\n')
			continue;
		n = DEC(buf[0]);
		if (n <= 0)
			break;

		/* Calculate expected # of chars and pad if necessary */
		expected = ((n+2)/3)<<2;
		for (i = strlen(buf)-1; i <= expected; i++) buf[i] = ' ';

		bp = &buf[1];
		while (n > 0) {
			outdec(bp, out, n);
			bp += 4;
			n -= 3;
		}
	}
}

/*
 * output a group of 3 bytes (4 input characters).
 * the input chars are pointed to by p, they are to
 * be output to file f.  n is used to tell us not to
 * output all of them at the end of the file.
 */
void outdec(char * p, FILE * f,int n)
{
	int c1, c2, c3;

	c1 = DEC(*p) << 2 | DEC(p[1]) >> 4;
	c2 = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
	c3 = DEC(p[2]) << 6 | DEC(p[3]);
	if (n >= 1)
		putc(c1, f);
	if (n >= 2)
		putc(c2, f);
	if (n >= 3)
		putc(c3, f);
}

/*
 * Return the ptr in sp at which the character c appears;
 * NULL if not found
 */

#define	NULL	0

char * index(char * sp, char c)
{
	while(*sp) {
		if (*sp == c)return(sp);
		sp++;
	}
	return(NULL);
}
