/* INSTALL origin Bernd Wetzel 1993                                          */
/* procedure to install Dcopy on the harddisk                                */
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs 

title = 'Installation of DCopy'
sourcepath = '.\DCOPY'
sourcedll = '.\DCOPYDLL'
targetpath = 'C:\OS2\APPS'
targetdll  = 'C:\OS2\DLL'
file.0 = 4
file.1 = 'DCOPY.EXE'
file.2 = 'DCOPY.TIC'
file.3 = 'DCOPY.CNF'
file.4 = 'DCOPY.DOC'
file.5 = 8
file.6 = 'SUPPDEL.DLL'
file.7 = 'SUPPCPY.DLL'
file.8 = 'SUPPZIP.DLL'

CALL SysCls
SAY 
SAY '[36m'title'[0;0m'
SAY 'By default DCopy will be installed to' targetpath'.'
SAY 'Enter "Y" to confirm, "N" to exit or enter a new path (e.g. C:\DCOPY)'
SAY 'where DCopy should be installed.'
SAY 'Press <ENTER> when ready.'
PULL answer .
IF (answer <> 'Y') THEN DO
  IF (answer = 'N') THEN EXIT 1
  targetpath = answer
END

'@CD' sourcepath
IF (rc <> 0) THEN DO
   SAY 'DCopy could not be found in' sourcepath '!'
   SAY title 'will be terminated.'
   EXIT 2
END

/* Check for all the files in the current directory                           */
filemissing = 0
DO i = 1 TO file.0
  search = file.i
  sysrc = SysFileTree(search, ret, 'FO')
  IF (ret.0 = 0 | sysrc <> 0) THEN DO
    SAY file.i 'is missing in the current directory'
    filemissing = 1
  END
END
IF filemissing = 1 THEN DO
  EXIT 1
END

sysrc = SysMkDir(targetpath)
IF (sysrc <> 0) THEN DO
  SAY 'Directory' targetpath 'could not be created !'
  IF (sysrc = 5) THEN SAY 'Directory already exists !'
  SAY 'Enter "Y" to confirm, "N" to exit'
  SAY 'Press <ENTER> when ready.'
  PULL answer .
  IF (answer <> 'Y') THEN EXIT 2
END

SAY 'DCopy will be installed to 'targetpath' ...'
DO i = 1 TO file.0
  target = targetpath || '\' || file.i
  '@COPY' file.i '/B' target '/V >nul 2>nul'
  IF (rc <> 0) THEN DO
    SAY 'File' file.i 'could not be copied to' targetpath '!'
    SAY title 'will be terminated.'
    EXIT 3
  END
END


SAY
SAY '[36m'title'[0;0m'
SAY 'By default DCopy-DLLs will be installed to' targetdll'.'
SAY 'Enter "Y" to confirm, "N" to exit or enter a new path (e.g. C:\DCOPY\DLL)'
SAY 'where the DLL should be installed (Think of your LIBPATH!).'
SAY 'Press <ENTER> when ready.'
PULL answer .
IF (answer <> 'Y') THEN DO
  IF (answer = 'N') THEN EXIT 1
  targetdll = answer
END

j=i

'@CD' sourcedll
IF (rc <> 0) THEN DO
   SAY 'DCopy DLLs could not be found in' sourcedll '!'
   SAY title 'will be terminated.'
   EXIT 2
END

/* Check for all the files in the current directory                           */
filemissing = 0
DO i = j+1 TO file.j
  search = file.i
  sysrc = SysFileTree(search, ret, 'FO')
  IF (ret.0 = 0 | sysrc <> 0) THEN DO
    SAY file.i 'is missing in the current directory'
    filemissing = 1
  END
END
IF filemissing = 1 THEN DO
  EXIT 1
END

sysrc = SysMkDir(targetdll)
IF (sysrc <> 0) THEN DO
  SAY 'Directory' targetdll 'could not be created !'
  IF (sysrc = 5) THEN SAY 'Directory already exists !'
  SAY 'Enter "Y" to confirm, "N" to exit'
  SAY 'Press <ENTER> when ready.'
  PULL answer .
  IF (answer <> 'Y') THEN EXIT 2
END

SAY 'DCopy-DLLs will be installed to 'targetdll' ...'
DO i = j+1 TO file.j
  target = targetdll || '\' || file.i
  '@COPY' file.i '/B' target '/V >nul 2>nul'
  IF (rc <> 0) THEN DO
    SAY 'File' file.i 'could not be copied to' targetdll '!'
    SAY title 'will be terminated.'
    EXIT 3
  END
END


SAY 'DCopy will be created as object on the desktop ...'
sysrc = SysCreateObject('WPProgram','DCopy','<WP_DESKTOP>','EXENAME='|| targetpath || '\' || file.1';PROGTYPE=PM;STARTUPDIR='||targetpath)
IF (sysrc <> 1) THEN DO
  SAY 'Object could not be created on the desktop !'
  SAY title 'will be terminated.'
  EXIT 4
END

SAY 'DCopy was successfully installed to 'targetpath'.'
EXIT 0
