/* rm.c - a UNIXish command for MSDOS
 * developed under Turbo C 2.0
 * Hume Smith
 */

#include <dir.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <errno.h>
#include <stdio.h>

#define Recurse (1<<0)
#define All (1<<1)
#define Select (1<<2)
#define Test (1<<3)
#define Force (1<<4)

char Usage[]=
"Usage: rm [-f] [-r] [-s] [-t] [-] name ...\n"
"option\n"
"-f - force     - delete read-only files without asking\n"
"-r - recurse   - delete subdirectories too\n"
"-s - selective - user is prompted at each file\n"
"-t - test      - list files that would have been deleted without deleting\n"
"-  - all following arguments are taken as filenames\n"
"\nCaution!  Can make a big mess very fast!\n";

int Switches=0;

int Wait(void)
{
  int r;

  while(1)
  {
    r=getch();
    if(r=='y'||r=='Y')
    {
      fprintf(stderr,"yes\n");
      return !0;
    }
    if(r=='n'||r=='N')
    {
      fprintf(stderr,"no\n");
      return 0;
    }
    if(r==3)
    {
      fprintf(stderr,"Break!\n");
      exit(0);
    }
  }
}

void Remove(char *Drive,char *Path,char *Name,char *Extension)
{
  struct ffblk FFBlk;
  int r;
  char Space[200];

  fnmerge(Space,Drive,Path,Name,Extension);
  for(r=findfirst(Space,&FFBlk,(Switches&Recurse)?FA_HIDDEN|FA_DIREC:FA_HIDDEN);
      !r;
      r=findnext(&FFBlk)
     )
  {
    /* avoid the "." and ".." files! */
    if(!strcmp(FFBlk.ff_name,".")||!strcmp(FFBlk.ff_name,".."))
      continue;

    /* if it is a directory, recurse */
    if(FFBlk.ff_attrib&FA_DIREC)
    {
      strcpy(Space,Path);
      strcat(Space,FFBlk.ff_name);
      strcat(Space,"\\");
      Remove(Drive,Space,"*",".*");
    }

    /* build full name */
    strcpy(Space,Drive);
    strcat(Space,Path);
    strcat(Space,FFBlk.ff_name);

    /* did the user want selectiveness? */
    if(Switches&Select)
    {
      fprintf(stderr,
              "Remove %s%s %s? ",
              (FFBlk.ff_attrib&FA_HIDDEN)?"(hidden) ":"",
              (FFBlk.ff_attrib&FA_DIREC)?"Directory":"File",
              Space
             );
      if(Wait())
        goto Delete;
      else
        goto Skip;
    }

Delete:
    /* unlink would fail on these */
    if(FFBlk.ff_attrib&FA_RDONLY)
    {
      /* if the force switch is set */
      if(Switches&Force)
        goto ChMod;

      /* double-check with user */
      fprintf(stderr,"Remove (read-only) %s? ",Space);

      /* if he says no */
      if(!Wait())
        goto Skip;

ChMod:
      /* change mode */
      if(chmod(Space,~FA_RDONLY))
      {
        printf("Error %d (%s) in chmod\n",errno,sys_errlist[errno]);
        goto Skip;
      }
    }

    /* farewell */
    if(Switches&Test)
      printf("%s\n",Space);
    else
      if(FFBlk.ff_attrib&FA_DIREC)
        if(rmdir(Space))
          printf("Error %d (%s) in rmdir(%s)\n",
                 errno,
                 sys_errlist[errno],
                 Space
                );
        else
          printf("%s Deleted\n",Space);
      else
        if(unlink(Space))
          printf("Error %d (%s) in unlink(%s)\n",
                 errno,
                 sys_errlist[errno],
                 Space
                );
        else
          printf("%s Deleted\n",Space);
Skip:
    ;
  }
}

void main(int ArgC,char **ArgV)
{
  int i,n=0;
  char Drive[5],Path[100],Name[13],Extension[4];

  /* check all args */
  for(i=1;i<ArgC;i++)
    /* if an option */
    if(!(Switches&All)&&ArgV[i][0]=='-')
      /* check which */
      switch(ArgV[i][1])
      {
      case 0:
        Switches|=All;
        break;
      case 'f':
        Switches|=Force;
        break;
      case 'r':
        Switches|=Recurse;
        break;
      case 's':
        Switches|=Select;
        break;
      case 't':
        Switches|=Test;
        break;
      default:
        fprintf(stderr,"rm: unknown option %s\n",ArgV[i]);
      }
    else
      /* pack list */
      ArgV[++n]=ArgV[i];

  if(!n)
    printf(Usage);
  else
    for(i=1;i<=n;i++)
    {
      fnsplit(ArgV[i],Drive,Path,Name,Extension);
      Remove(Drive,Path,Name,Extension);
    }
}
