/* MF.CMD  (MakeFile) by Gordon Snider  v1.0.0  2003/01/26 */
/* PURPOSE: Creates a file entry, by default in the current directory,
            and issues a message naming the file.
   SYNTAX:  MF /?
       or   MF [filename] [/T]

      where file_name is the optional name of the file you want to create.
      A path may be included with the filename to place the file in any 
      directory. If you don't supply a filename 
      SysTempFileName('temp.???') 
      will be used to create one in the current directory, beginning with 
      temp. followed by three digits;
      and where the following optional switches may be used:  
      /?  triggers a display of a help screen and then exits,
      /T  turns on the REXX trace ?i  
*/
if LRU() then exit
arg target '/' switch
if pos('?', switch) > 0 then do         
    do l = 1 until substr(sourceline(l), 1, 2) = '*/'
      say sourceline(l)
    end l
  exit
  end  /* if */
if pos('T', switch) > 0 then trace ?i
if target = '' then target = SysTempFileName('temp.???')
call LINEOUT target,''
if result then say 'File not created.'
say target 'created.'
exit 0
