/*
 *  ************************************************************************
 *                      	OS/2 Command-Line Utilities
 *  (c) Copyright 1991-2000 Jonathan de Boyne Pollard.  All Rights Reserved.
 *  ************************************************************************
 */

/* "@(#)HELP.CMD version 1.1.0" */

'@echo off'

call RxFuncAdd 'SysGetMessage','RexxUtil','SysGetMessage'

usage = "HELP"||"0D0A"X||"   or: HELP message_number"||"0D0A"X||"   or: HELP [book] command"
copyr = "Copyright (c) 1998-2000 Jonathan de Boyne Pollard.  All Rights Reserved."

parse arg first second third

select
	when third \== '' then do
		say SysGetMessage(1003)
		say usage
	end
	when second \== '' then do
		cmdline = 'view '||first||' '||second
		'(2>nul 1>nul ? && start /pm /c '||cmdline||') || start /pm '||cmdline
	end
	when translate(first) == "ON" then do
		prompt = value("PROMPT",,"OS2ENVIRONMENT")
		ipos = pos("$i", prompt)
		if ipos < 1 then
			prompt = value("PROMPT","$i"||prompt,"OS2ENVIRONMENT")
	end
	when translate(first) == "OFF" then do
		prompt = value("PROMPT",,"OS2ENVIRONMENT")
		ipos = pos("$i", prompt)
		if ipos > 0 then
			prompt = value("PROMPT",left(prompt,ipos-1)||substr(prompt,ipos+2),"OS2ENVIRONMENT")
	end
	when first == "/?" then do
		say SysGetMessage(190, "CLUH.MSG", copyr, usage)
	end
	when first == '' then do
		say
		say SysGetMessage(1491)
	end
	when datatype(first,"N") then do
		say
		say SysGetMessage(first)
		say SysGetMessage(first, "OSO001H.MSG")
	end
	when datatype(first,"A") & datatype(left(first,3), "M") & datatype(substr(first,4),"N") then do
		file = left(first,3)
		if translate(file) == "SYS" then
			file = "OSO001"
		num = substr(first,4)
		say
		say SysGetMessage(num, file||".MSG")
		say SysGetMessage(num, file||"H.MSG")
	end
	otherwise do
		cmdref = value("CMDREF",,"OS2ENVIRONMENT")
		if cmdref == '' then
			cmdref = 'clu21+cmdref'
		cmdline = 'view '||cmdref||' '||first
		'(2>nul 1>nul ? && start /pm /c '||cmdline||') || start /pm '||cmdline
	end
end
