#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

typedef struct
{
   char * ico_name;
   char * ico_string;
   int ico_len;
} ICO;
typedef ICO * PICO;

void load (PICO [], char *, USHORT *);

main ()
{
   int indx;

   HDIR hdir = 0xFFFF;
   FILEFINDBUF findbuf;
   USHORT usSearchCount = 1, num_icons = 0, curr_ico = 0, comp_ico;
   PICO * pico;

   printf ("Loading");

   if (DosFindFirst ("*.ICO", &hdir, FILE_NORMAL,
                     &findbuf, sizeof (findbuf),
                     &usSearchCount, 0L) != 0)
   {
      printf ("\nNo .ICO files found\n");
      return 96;
   }
   do num_icons++;
   while (DosFindNext (hdir,
                       &findbuf,
                       sizeof (findbuf),
                       &usSearchCount) == 0);
   printf (" %d icons; please wait...\n", num_icons);

   pico = (PICO *) malloc ((num_icons) * sizeof (PICO));

   usSearchCount = 1;
   DosFindFirst ("*.ICO", &hdir, FILE_NORMAL,
                 &findbuf, sizeof (findbuf),
                 &usSearchCount, 0L);

   do load (pico, findbuf.achName, &curr_ico);
   while (DosFindNext (hdir,
                       &findbuf,
                       sizeof (findbuf),
                       &usSearchCount) == 0);

   printf ("Comparing icons...\n");

   for (curr_ico = 0; curr_ico < num_icons; curr_ico++)
      for (comp_ico = curr_ico + 1; comp_ico < num_icons; comp_ico++)
         if (pico [curr_ico]->ico_len == pico [comp_ico]->ico_len)
         {
            for (indx = 0; indx < pico [curr_ico]->ico_len; indx++)
            {
               if (pico [curr_ico]->ico_string [indx] != pico [comp_ico]->ico_string [indx])
               {
                  indx = -1;
                  break;
               }
            }
            if (indx > 0)
               printf ("%s matches %s\n",
                       pico [curr_ico]->ico_name,
                       pico [comp_ico]->ico_name);
         }

   return 0;
}


void load (PICO pico [], char * filename, USHORT * curr_ico)
{
   char * s;
   int count;
   FILE *filenum;

   pico [*curr_ico] = (PICO) malloc (sizeof (ICO));

   pico [*curr_ico]->ico_name = (char *) malloc ((1 + strlen (filename)) * sizeof (char));
   strcpy (pico [*curr_ico]->ico_name, filename);

   filenum = fopen (filename, "r+b");
   if (filenum == NULL)
   {
      printf ("Cannot open %s\n", filename);
      exit (99);
   }
   pico [*curr_ico]->ico_len = filelength (fileno (filenum));

   if ((pico [*curr_ico]->ico_string = (char *) malloc ((1 + pico [*curr_ico]->ico_len) * sizeof (char))) == NULL)
   {
      printf ("Cannot allocate space\n");
      exit (98);
   }
   count = fread (pico [*curr_ico]->ico_string, sizeof (char), pico [*curr_ico]->ico_len, filenum);
   fclose (filenum);

   (*curr_ico)++;
}
