/* Script for Send Files to Phone via OBEX */
/* U can send GIF, BMP, EMY, VCF & so other */

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'RxAsyncRead', 'RXASYNC', 'RxAsyncRead'
Call RxFuncAdd 'RxAsyncWait', 'RXASYNC', 'RxAsyncWait'
Call RxFuncAdd 'RxAsyncSetMdmOutput', 'RXASYNC', 'RxAsyncSetMdmOutput'
Call RxFuncAdd 'RxAsyncGetRxCount', 'RXASYNC', 'RxAsyncGetRxCount'
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

signal on halt

/* [Global] */
comport="com1"
init="ATE0"
/* obexinit="AT+CPROT=0"  Try this if 1st not work */
obexinit="AT*EOBEX"
portspeed=115200
command_delay=0.5    /* delay between AT commands (sec) */
phonevol=7

/* [Internal] Don't modify w/o necessity !!! */
PortHandle=''
inpstr=''
remaining=''
debug=1
mainlog=1
crlf=d2c(13)d2c(10)

/* ------------- Entry Point -------------- */
Call SysCls

rc=crlf "    Automatic OBEX File Sender v 1.00 (c) By Alek Winner." crlf
say rc
if mainlog then call charout "send.log",rc

call comport_check


patrol:

parse arg filename

if filename="" then
  do
  say "Filename required..."
  exit
  end


rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "Init", "OK", "  Modem not ready... Exitting... ;("


rc=" "date()"  " time() "  Phone Modem Initialized OK"
say rc
if mainlog then call lineout "send.log",rc


rc=" "date()"  " time() "  Sending "||obexinit||"..."
say rc
if mainlog then call lineout "send.log",rc


rc = RxAsyncWrite( PortHandle, 0, obexinit||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string obexinit, "CONNECT", "  Requesting OBEX failed... Exitting... ;("


rc=" "date()"  " time() "  CONNECT Answered!"
say rc
if mainlog then call lineout "send.log",rc

call syssleep 0.5


/* Pict sending begins ... */

rc=" "date()"  " time() "  Opening OBEX Session..."
say rc
if mainlog then call lineout "send.log",rc


Send_str="80 00 07 01 00 00 FF"
Send_str=x2c(Send_str)

rc = RxAsyncWrite( PortHandle, 0, Send_str, 'Remaining' )
if rc <> 0 then signal err1

plength=7
call byteread

call syssleep 0.5

file=filename
fln=length(file)
flength=d2x(fln*2+5)
plength=d2x(fln*2+8)

do i=1 to fln*2 by 2
file=insert(x2c("00"),file,i)
end

rc=" "date()"  " time() "  Requsting" filename "send..."
say rc
if mainlog then call lineout "send.log",rc


Send_str=x2c("02"||right(plength,4,'0')||"01"||right(flength,4,'0'))||x2c(0)||file||x2c(0)

rc = RxAsyncWrite( PortHandle, 0, Send_str, 'Remaining' )
if rc <> 0 then signal err1

plength=3
call byteread

call syssleep 0.5

rc=charin(filename,,65535)
lrc=d2x(length(rc)+6)
lrd=d2x(length(rc)+3)

Send_str=x2c('82'||right(lrc,4,'0')||'49'||right(lrd,4,'0'))||rc


rc=" "date()"  " time() "  Sending" filename "contents..."
say rc
if mainlog then call lineout "send.log",rc

rc = RxAsyncWrite( PortHandle, 0, Send_str, 'Remaining' )
if rc <> 0 then signal err1

call syssleep 0.5


plength=3
call byteread

call syssleep 0.5

signal terminat


pbook_end:

terminat:

call charout filename

rc=" "date()"  " time() "  Sending 81 00 03 (End Session)..."
say rc
if mainlog then call lineout "send.log",rc

string1=x2c("81 00 03")

call RxAsyncWrite PortHandle, 3, string1, 'Remaining'
flag=0

call check_string "Disconnect", "OK", "  Modem not ready... Exitting... ;("


rc=" "date()"  " time() "  Disconnected OK!"
say rc
if mainlog then call lineout "send.log",rc


call close_all
call RxAsyncClose PortHandle
exit


/* --- Check Port State --------*/
comport_check:
if stream(comport,'c','open') = 'NOTREADY:32' then signal err0

call stream comport,'c','close'
rc = RxAsyncOpen( Comport, 'PortHandle' )

com_init:

rc = RxAsyncSetLnCtrl( PortHandle, portspeed, 8, 'N', 1 )
if rc <> 0 then signal err0

rc=RxAsyncSetDcbInfo(PortHandle,400,50,'00001001','10000000','','','','','' )
return

err0:
rc=" "date()"  " time() "  Comport is not respond... ;(" crlf
say rc
if mainlog then call charout "send.log",rc
/* call beep 262,250 */
exit
/* -----------------------------*/



/* -- Check Modem String --------- */
check_string:
PARSE ARG deb_str, ok_str, err_str

InpStr = ""
do until InpStr=ok_str||crlf | InpStr='ERROR'||crlf
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
if rc <> 0 then signal err1
db=deb_str InpStr crlf
if debug then call charout "debug.log",db
end

if InpStr = ok_str||crlf then return

err1:
rc=" "date()"  " time() err_str crlf
say rc
if mainlog then call charout "send.log",rc
/* call beep 262,250 */
signal term
/* -- Check Modem String - Ends -- */


/* ---- Check Byte Reading ---- */
byteread:
inp=''
cycle1:
if plength > 255 then
  do
  p=plength-255
  plength=255
  end
else p=0

rc = RxAsyncRead( PortHandle, plength, 10000, 'Inpstr' )
if rc=-1 then 
  do
  rc=" "date()"  " time() "  Phone Answer Timed Out!"
  say rc
  if mainlog then call lineout "send.log",rc
  signal terminat
  end

resp=c2x(left(inpstr,1))
if resp <> "A0" & resp <> "90" then
  do
  rc=" "date()"  " time() "  Send Error! ErrCode is" c2x(inpstr)
  say rc
  if mainlog then call lineout "send.log",rc
  signal terminat
  end

rc=" "date()"  " time() "  "c2x(inpstr) "Answered! (success)"
say rc
if mainlog then call lineout "send.log",rc

if p>0 then
  do
  inp=inp||inpstr
  plength=p
  signal cycle1
  end

inpstr=inp||inpstr

return
/* ---- Check Byte Reading Ends ---- */


/* ----- Close All Files -------*/
close_all:
call stream "send.log",'c','close'
call stream "debug.log",'c','close'
return
/* -----------------------------*/

term:
