//
// DCdebug.c - 室 ⥪ ணࠬ ⫠ 
//             the Plugin Debugger Source
//
//=============================================================
// (c) VicTor Smirnoff, 1999               sva@water.karelia.ru
//=============================================================


#define INCL_PM
#define INCL_DOSPROCESS        // DosSleep()

#include <os2.h>
#include <stdlib.h>            // max()
#include <string.h>            // strncpy()
#include <stdio.h>             // sprintf()
#include "DCplugin.h"
#include "DCdebug.h"


//-------------------------------------------------------------
// ⨯ 㭪権
// the Function Prototypes
//-------------------------------------------------------------
MRESULT EXPENTRY WndDlgProc( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY WndPluginProc( HWND, ULONG, MPARAM, MPARAM );
VOID SetDlgItemPos( LONG, LONG );
VOID DisplayError( ULONG );
VOID BeepError( int );
// #define max(a,b)  (((a) > (b)) ? (a) : (b)) 

//-------------------------------------------------------------
// ⠭
// the Constants
//-------------------------------------------------------------
#define DBGRETURN_ERROR         1   // 祭   訡
                                    // error - the Return Value
#define DBGBEEP_WARN_FREQ    3000   // ⮭ ᨣ  訡
                                    // the Error Beep Frequence
#define DBGBEEP_WARN_DUR      200   // ⥫쭮 ᨣ  訡 
                                    // the Error Beep Duration
#define DBGBEEP_WARN_PAUSE     40   // 㧠  ᨣ  訡
                                    // the Pause between the Error Beeps
#define DBGBEEP_WARN_INIT       2   // ᫮ ᨣ  訡 樠樨
                                    // the Beep Count of the Init Error
#define DBGBEEP_WARN_QUEUE      4   // ᫮ ᨣ  訡 ᮧ ।
                                    // the Beep Count of the Queue Error
#define DBGMSG_WARN_SIZE       80   //  ᮮ饭  訡
                                    // the Length of the Error Message
#define DBGTEST_STRING      " . This is a Test"


//-------------------------------------------------------------
//  ६
// the Global Vars
//-------------------------------------------------------------
HAB  hab;
HWND hwndMain;
HPOINTER hptrIcon = NULLHANDLE;

SWP swpDefault;                    // 䮫 ࠧ 
                                   // the Main Window Default Size
SWP swpMini;                       // ࠧ  । 樥
                                   // the Main Window Size before the Minimizing
ULONG screenCP;                    //  ࠭ ࠡ祣 ⮫
                                   // the Desktop Code Page

IDPLUGIN p;                        // 䨪 
                                   // the Plugin ID
HPLUGIN  h;                        // ࠢ  
                                   // the Plugin Control Structure
PCHAR  in;                         // 室    
ULONG  lin;                        // the Input Buffer and Length

CHAR szAppTitle[MAXNAMEL];

//=======================================================
//  㭪 ਫ
// the Main Application Function
//=======================================================
int main()
{
   HPS    hps;
   HMQ    hmq;
   QMSG   qmsg;
   ULONG  idMsg;
   APIRET rc;
   BOOL   success;

//-------------------------------------------------------------
// 稬 砫 祭
// Set the Initial Value
//-------------------------------------------------------------
   memset( &p, 0, sizeof(IDPLUGIN) );
   memset( &h, 0, sizeof(HPLUGIN) );

   lin = sizeof(DBGTEST_STRING)+1;
   rc = DosAllocMem( (PPVOID)&in,
                     (ULONG)lin,
        PAG_WRITE | PAG_READ | PAG_COMMIT );
   if (rc != 0)  return ( DBGRETURN_ERROR );
   strcpy( in, DBGTEST_STRING );

//-------------------------------------------------------------
// 樠㥬 ਫ
// Initialize the Application
//-------------------------------------------------------------
   hab = WinInitialize( 0 );
   if ( hab == NULLHANDLE )
   {
      BeepError( DBGBEEP_WARN_INIT );
      if ( in != NULL )  DosFreeMem( in );
      return ( DBGRETURN_ERROR );
   }

   hmq = WinCreateMsgQueue( hab, 0 );
   if ( hmq == NULLHANDLE )
   {
      BeepError( DBGBEEP_WARN_QUEUE );
      if ( in != NULL )  DosFreeMem( in );
      return ( DBGRETURN_ERROR );
   }

//-------------------------------------------------------------
// 稬  ࠭ ࠡ祣 ⮫
// Query the Desktop Code Page
//-------------------------------------------------------------
   hps = WinGetPS( HWND_DESKTOP );
   screenCP = GpiQueryCp( hps );
   WinReleasePS( hps );

//-------------------------------------------------------------
// 稬 ப   ( CP886  ᪮,   ᪮)
// Load the Window Title String (for CP866 - Russian, other - English)
//-------------------------------------------------------------
   idMsg = DBGRUS_APPTITLE;  if ( screenCP != 866L ) idMsg++;
   WinLoadString( hab, (HMODULE)0L, idMsg,
      MAXNAMEL, (PSZ)szAppTitle );
   hptrIcon = WinLoadPointer( HWND_DESKTOP, 0L, DBGID_MAIN );

//-------------------------------------------------------------
// ॣ㥬    
// Register the Window for Plugin Dialog
//-------------------------------------------------------------
   success = WinRegisterClass( hab,
                "DCdebugPlugin",
                WndPluginProc,
                0L, 4L );
   if ( !success )
   {
      DisplayError( DBGRUS_REGPLUGIN );
      if ( in != NULL )  DosFreeMem( in );
      WinDestroyMsgQueue( hmq );
      WinTerminate( hab );
      return ( DBGRETURN_ERROR );
   }

//-------------------------------------------------------------
//    ਫ ()
// Create the Main Application Window (as Dialog)
//-------------------------------------------------------------
   hwndMain = WinLoadDlg( HWND_DESKTOP,
                 HWND_DESKTOP,
                 WndDlgProc,
                 (HMODULE)0,
                 DBGID_MAIN,
                 NULL);
   if ( hwndMain == NULLHANDLE )
   {
      DisplayError( DBGRUS_CREATEMAIN );
      if ( in != NULL )  DosFreeMem( in );
      WinDestroyMsgQueue( hmq );
      WinTerminate( hab );
      return ( DBGRETURN_ERROR );
   }

   while( WinGetMsg( hab, &qmsg, 0, 0, 0 ) )
      WinDispatchMsg( hab, &qmsg );

//-------------------------------------------------------------
// ஥ ਫ
// Close the Application
//-------------------------------------------------------------
   if ( in != NULL )  DosFreeMem( in );
   if ( hptrIcon != NULLHANDLE )  WinDestroyPointer( hptrIcon );
   WinDestroyWindow( hwndMain );
   WinDestroyMsgQueue( hmq );
   WinTerminate( hab );

   return ( 0 );
}
//---------- end of main() ------------------------------------





//=============================================================
// 㭪   ()
// the Main Window Procedure (as Dialog)
//=============================================================
MRESULT EXPENTRY WndDlgProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch ( msg )
   {
//-------------------------------------------------------------
// WM_INITDLG
//      樠  Dialog
//    (  ⮬     ᮧ)
//       :
//          FALSE - 䮪  
//          TRUE  - 䮪 
//
// 1. ᨬ ஢ ࠧ஢  Dialog
//
// (***)  ࠢ쭮 祭 ࠧ஢ 䮫⭮ 
//        ⠭  ࠧ஢ 諮   ⥫
//       ᮮ饭 DBGMY_QUERYSIZE  DBGMY_SETSIZE
//-------------------------------------------------------------
      case WM_INITDLG:
         WinPostMsg( hwnd, DBGMY_QUERYSIZE, NULL, NULL );
         break;
 

//-------------------------------------------------------------
// DBGMY_QUERYSIZE
//    㯠  ࠡ稪 (Dialog) ࠧ ᫥ WM_INITDLG
//    ( ⮬ ६ 㦥 ᮧ  Dialog 䮫⭮ ࠧ)
//
// 1. ⠭   ⥪ 
// 2. 㧨 ⠡ ᥫ஢
// 3. ᮧ 짮⥫᪮ 
// 4.    ᯨ᮪ 
// 5. । 䮫 ࠧ  㢥稬    ;
//      쭮  ࠧ
//    (᫨   ࠧ,  짮⥫᪮ 
//      ࢮ ᪥  ⮫쪮 ᫥ 
//      ࠧ஢ ).
// 6. ⠭ ࠬ 
// 7. ᫨ ࠬ  ⠭ (ਬ, ),
//     ᮮ騬 䮫 ࠧ 
//-------------------------------------------------------------
      case DBGMY_QUERYSIZE:
         {
            SWP swp;
            SWCNTRL swctl;
            HSWITCH hswitch;

            WinSendMsg( hwndMain, WM_SETICON, (MPARAM)hptrIcon, (MPARAM)0L );
            WinSetWindowText( hwndMain, szAppTitle );

            swctl.hwnd = hwndMain;
            swctl.hwndIcon = hwndMain;
            swctl.hprog = NULLHANDLE;
            swctl.idProcess = 0;
            swctl.idSession = 0;
            swctl.uchVisibility = SWL_VISIBLE;
            swctl.fbJump = SWL_JUMPABLE;
            swctl.szSwtitle[0] = 0x00;
            swctl.szSwtitle[MAXNAMEL+1] = 0x00;
            strncpy( swctl.szSwtitle, szAppTitle, MAXNAMEL );
 
            hswitch = WinAddSwitchEntry( &swctl );
   
            WinQueryWindowPos( hwnd, (PSWP)&swp );
            swpDefault = swp;
            swpMini = swp;

            WinPostMsg( hwnd, DBGMY_SETSIZE,
               MPFROMLONG(swpDefault.cx), MPFROMLONG(swpDefault.cy) );
         }
         break;


//-------------------------------------------------------------
// DBGMY_SETSIZE
//    㯠  ࠡ稪 (Dialog) ᫥ MY_QUERYSIZE
//     WM_ADJUSTWINDOWPOS
//     ⢥ ࠬ஢ 砥  ࠧ  Dialog
//
// 1. 樮㥬    ᮮ⢥⢨  묨
//    ࠧࠬ, ᫨   ஢
//
// (***) WinSetWindowPos(...,SWP_ACTIVATE) 頥  ⭮
//       ॠ樨  ᨬ  ஢ ﭨ
//       ( WinQueryWindowPos 頥 ࠧ 
//       ࠢ ࠧ  (42x40   32x32), 
//        ࠭ 㦥 ᮢ   ࠧ஢)
//
// (***) WinShowWindow(...,TRUE) 室  
//       ᫥  ᮧ
//-------------------------------------------------------------
      case DBGMY_SETSIZE:
         {
            SWP swp;
            LONG deltaX, deltaY;

            WinSetWindowPos( hwnd, HWND_TOP, 0L, 0L, 0L, 0L,
               SWP_ACTIVATE );

            WinQueryWindowPos( hwnd, (PSWP)&swp );
            if ( !(swp.fl & SWP_MINIMIZE) )
            {
               deltaX = swp.cx - LONGFROMMP(mp1);
               deltaY = swp.cy - LONGFROMMP(mp2);
/*
{
   char szMsg[100];

   sprintf( szMsg, "(cx,cy) = (%ld,%ld)    (deltaX,deltaY) = (%ld,%ld)",
      swp.cx, swp.cy, deltaX, deltaY );
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, (PCH)szMsg,
      (PCH)szAppTitle, ID_MSGBOX,
      MB_OK | MB_APPLMODAL | MB_MOVEABLE | MB_INFORMATION );
}
*/
               if ( deltaX!=0 || deltaY!=0 )
                  SetDlgItemPos( deltaX, deltaY );

               WinShowWindow( hwnd, TRUE );
            }
         }
         break;


//-------------------------------------------------------------
// WM_ADJUSTWINDOWPOS
//    㯠 ।  ࠧ஢ 
//-------------------------------------------------------------
      case WM_ADJUSTWINDOWPOS:
         {
            SWP swp;

            WinQueryWindowPos( hwnd, (PSWP)&swp );

         //-------------------------------------------------------------
         // SWP_MINIMIZE
         //    襭  
         // 
         // 1. ࠭ ࠧ 
         //-------------------------------------------------------------
            if (((PSWP)mp1)->fl & SWP_MINIMIZE)
               WinQueryWindowPos( hwnd, (PSWP)&swpMini );

         //-------------------------------------------------------------
         // SWP_RESTORE || SWP_MAXIMIZE
         //    襭 ⠭  ᨬ 
         // 
         // 1. ᫨  ஢ ﭨ,  ᮮ騬 ࠧ,
         //    ࠭ । 樥;
         //    SWP_ACTIVATE ⪫砥 - ⭮ ॠ樨
         // 2.  ᮮ騬 ⥪騥 ࠧ 
         //
         // (***) ஢ઠ  ࠧ  䮫 室 
         //       ।饭  ࠧ஢ ᨬ஢
         //         䮫 (..   ﭥ 
         //       ࠭ ᨬ஢  㬥 )
         //-------------------------------------------------------------
            else if ( (((PSWP)mp1)->fl & SWP_RESTORE) ||
                      (((PSWP)mp1)->fl & SWP_MAXIMIZE) )
            {
               if ( swp.fl & SWP_MINIMIZE )
               {
                  ((PSWP)mp1)->fl = ((PSWP)mp1)->fl & ~SWP_ACTIVATE;
                  WinPostMsg( hwnd, DBGMY_SETSIZE,
                     MPFROMLONG(swpMini.cx), MPFROMLONG(swpMini.cy) );
               }
               else
               {
                  if ( (((PSWP)mp1)->cx<swpDefault.cx) ||
                       (((PSWP)mp1)->cy<swpDefault.cy) )
                  {
                     ((PSWP)mp1)->cx = max( swpDefault.cx, ((PSWP)mp1)->cx );
                     ((PSWP)mp1)->cy = max( swpDefault.cy, ((PSWP)mp1)->cy );
                  }
                  WinPostMsg( hwnd, DBGMY_SETSIZE,
                     MPFROMLONG(swp.cx), MPFROMLONG(swp.cy) );
               }
            }

         //-------------------------------------------------------------
         // SWP_SIZE
         //    襭  ࠧ஢ 
         // 
         // 1. ᫨  ࠧ  䮫 (쭮 ),
         //      ࠬ  ⠭ 䮫 ࠧ஢
         // 2. ᮮ騬 ⥪騥 ࠧ 
         // 
         // (***)   SWP_SIZE ᥣ 室    SWP_MOVE
         //-------------------------------------------------------------
            else if (((PSWP)mp1)->fl & SWP_SIZE)
            {
               if ( (((PSWP)mp1)->cx<swpDefault.cx) ||
                    (((PSWP)mp1)->cy<swpDefault.cy) )
               {
                  ((PSWP)mp1)->cx = max( swpDefault.cx, ((PSWP)mp1)->cx );
                  ((PSWP)mp1)->cy = max( swpDefault.cy, ((PSWP)mp1)->cy );
               }
               WinPostMsg( hwnd, DBGMY_SETSIZE,
                  MPFROMLONG(swp.cx), MPFROMLONG(swp.cy) );
            }
         }
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );


//-------------------------------------------------------------
// WM_CLOSE
//    㯠  ࠡ稪 (Dialog)
//
// ࠭ ࠬ  Dialog  OS2.INI
//
// (***) ࠡ뢠 室, ..  WinDefDlgProc 
//       뢠,  㬮砭, WinDismissDlg,   ࠡ稪
//       User  ᯮ WinProcessDlg  WinDlgBox
//       ( ) =>  ᮮ  稭 
//-------------------------------------------------------------
      case WM_CLOSE:
         WinDismissDlg( hwnd, TRUE );
         WinPostMsg( hwnd, WM_QUIT, NULL, NULL );
         break;


//-------------------------------------------------------------
// WM_COMMAND
//    㯠, ᫨ 짮⥫   -
//     
//-------------------------------------------------------------
      case WM_COMMAND:
         switch( SHORT1FROMMP( mp1 ) )
         {
         //-------------------------------------------------------------
         // 짮⥫   ESC
         //
         // (***) ⠭⭮  ᭨ ( )
         //-------------------------------------------------------------
            case DID_CANCEL:
               break;

         //-------------------------------------------------------------
         // 짮⥫ ࠫ   㭪⮢ 
         //
         // (***)  騩   㭪   ࠡ뢠.
         //       ᫨ ࠡ⪠ 㭪  稢 ஬
         //          return WinDefDlgProc( hwnd, msg, mp1, mp2 );
         //          
         //-------------------------------------------------------------
            case DBGID_PLUGINID:
               {
                  APIRET  rc;

                  memset( &p, 0, sizeof(IDPLUGIN) );

                  h.pluginHab  = hab;
                  h.pluginHwnd = NULLHANDLE;
                  h.pluginHmod = NULLHANDLE;
                  h.pluginVer  = DC_PLUGINVER;
                  h.pluginCP   = screenCP;

                  rc = DC_OK;
//                  rc =  DCpluginID( &h, &p );
               }
               break;

            case DBGID_PLUGININI:
               {
                  APIRET  rc;

                  h.pluginHab  = hab;
                  h.pluginHwnd = WinWindowFromID( hwnd, DBGID_PLUGIN );
                  h.pluginHmod = NULLHANDLE;
                  h.pluginVer  = DC_PLUGINVER;
                  h.pluginCP   = screenCP;

                  rc = DC_OK;
//                  rc =  DCpluginIni( &h );
               }
               break;

            case DBGID_PLUGINRUN:
               {
                  APIRET  rc;
                  PCHAR   out;
                  ULONG   lout;

                  out = NULL;  lout = 0L;

                  h.pluginHab  = hab;
                  h.pluginHwnd = WinWindowFromID( hwnd, DBGID_PLUGIN );
                  h.pluginHmod = NULLHANDLE;
                  h.pluginVer  = DC_PLUGINVER;
                  h.pluginCP   = screenCP;

                  rc = DC_OK;
//                  rc =  DCpluginRun( &h , in, lin, &out, &lout );
                  if ( rc == DC_OK )
                  {
                     if ( in != NULL )  DosFreeMem( in );
                     in = out;  lin = lout;
                  }
               }
               break;

            case DBGID_PLUGINEND:
               {
                  APIRET  rc;

                  h.pluginHab  = hab;
                  h.pluginHwnd = WinWindowFromID( hwnd, DBGID_PLUGIN );
                  h.pluginHmod = NULLHANDLE;
                  h.pluginVer  = DC_PLUGINVER;
                  h.pluginCP   = screenCP;

                  rc = DC_OK;
//                  rc =  DCpluginEnd( &h );
               }
               break;

            case DBGID_PLUGINSIZE:
               {
                  APIRET  rc;

                  h.pluginHab  = hab;
                  h.pluginHwnd = WinWindowFromID( hwnd, DBGID_PLUGIN );
                  h.pluginHmod = NULLHANDLE;
                  h.pluginVer  = DC_PLUGINVER;
                  h.pluginCP   = screenCP;

                  rc = DC_OK;
//                  rc =  DCpluginSize( &h );
               }
               break;

         //-------------------------------------------------------------
         //    ⠢ ࠡ ⮢ ᢮ 
         //
         // case :
         //    ...
         //    break;
         //-------------------------------------------------------------

         //-------------------------------------------------------------
         // WinDefDlgProc,  㬮砭
         //-------------------------------------------------------------
            default:
               return WinDefDlgProc( hwnd, msg, mp1, mp2 );
         }
         break;


//-------------------------------------------------------------
// WinDefDlgProc,  㬮砭
//-------------------------------------------------------------
      default:
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
   }
   return (MRESULT)FALSE;
}
//---------- end of WndDlgProc() ------------------------------





//=============================================================
// 㭪  - த⥫   
// the Parent Window of the Plugin Dialog
//=============================================================
MRESULT EXPENTRY WndPluginProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch ( msg )
   {
   case WM_CREATE:
      break;

   case WM_PAINT:
      {
         HPS    hps;
         RECTL  rctl;
 
         hps = WinBeginPaint( hwnd, (HPS)NULLHANDLE, &rctl );

         WinFillRect( hps, &rctl, CLR_PALEGRAY );

         WinEndPaint( hps );
      }
      break;

   default: 
      return WinDefWindowProc( hwnd, msg, mp1, mp2 );
   }
   return (MRESULT)FALSE;
}
//---------- end of WndPluginProc() ------------------------------





//=======================================================================
// 樮஢ ⮢ 
//    dX - 饭 ࠧ஢    X
//    dY - 饭 ࠧ஢    Y
//
// Set Position for the Dialog Items
//    dX - the Window Size Increase/Descrease on X
//    dY - the Window Size Increase/Descrease on Y
//=======================================================================
VOID SetDlgItemPos( LONG dX, LONG dY )
{
   HWND hwnd;
   SWP swp;

// 祬   
// (ᮢ   ⥫쭮 ॥)
// hide all Dialog Items
   WinShowWindow( WinWindowFromID( hwndMain, DBGID_PLUGIN), FALSE );

// 樮㥬 짮⥫᪮ 
// set Position for the User Window
   hwnd = WinWindowFromID( hwndMain, DBGID_PLUGIN);
   WinQueryWindowPos( hwnd, (PSWP)&swp );
   WinSetWindowPos( hwnd,
      HWND_TOP,
      swp.x+dX, swp.y, swp.cx, swp.cy+dY,
      SWP_MOVE | SWP_SIZE );

//    
   WinShowWindow( WinWindowFromID( hwndMain, DBGID_PLUGIN), TRUE );
}
//---------- end of SetDlgItemPos() ---------------------------





//=============================================================
// 뢮 ᮮ饭  訡 ( CP866  ᪮,   ᪮)
//    idMsg - 䨪 ᮮ饭  
//
// Display the Error Message (for CP866 - Russian, other - English)
//    idMsg - the Error Message ID
//=============================================================
VOID DisplayError( ULONG idMsg )
{
   HWND  hwnd;
   ULONG xMsg;
   char cMsg[DBGMSG_WARN_SIZE];

   xMsg = idMsg;
   if (screenCP != 866L)  xMsg++;
   WinLoadString( hab, (HMODULE)0L, xMsg, DBGMSG_WARN_SIZE, (PSZ)cMsg );

   if (hwndMain == NULLHANDLE)  hwnd = HWND_DESKTOP;
   else  hwnd = hwndMain;

   WinMessageBox( HWND_DESKTOP, hwnd, (PCH)cMsg,
      (PCH)szAppTitle, DBGID_MSGBOX,
      MB_OK | MB_APPLMODAL | MB_MOVEABLE | MB_ERROR );
}
//---------- end of DisplayError() ----------------------------





//=======================================================================
//   訡
//    n - ⢮ ᨣ  ਨ
//
// the Error Beep
//    n - the Count of the Error Beep
//=======================================================================
VOID BeepError(int n)
{
   int i;

   for ( i=0; i<n; i++ )
   {
      DosBeep( DBGBEEP_WARN_FREQ, DBGBEEP_WARN_DUR );
      DosSleep( DBGBEEP_WARN_PAUSE );
   }
}
//---------- end of BeepError() -------------------------------





