/* REXX */
/* ファイル分割 */
/* パラメータはusage:参照 */
/* (C) Copyright 1999 kyo */
options 'ETMODE'; options 'EXMODE';
parse arg prm '@' tr
trace value tr;

/* OSとコマンド名取得 */
/* DOSのCHARINで長さが32767までしか対応していないため分割読み込み */
/* DOSではコマンド名先頭の'@'がエラーとなる */
parse source os . cmdname
select
when os = "DOS" then
do
	inlen = 32700
	'echo off'
end
when os = "OS/2" then
do
	inlen = 1000000000000
	'@echo off'
end
otherwise
	inlen = 1000000000000
end

/* コマンド名取得 */
/* 文字列を反転して'.'と最初の'\'で分解 */
rvcmdname = reverse(cmdname)
parse var rvcmdname rvcmdext '.' rvcmdbody '\' rvcmddir
cmdname = reverse(rvcmdbody) || '.' || reverse(rvcmdext)

/* パラメータ処理 */
if prm = '' then signal usage
if translate(substr(prm, 1, 6)) = '-SIZE ' then
do /* -sizeパラメータがある場合 */
	parse var prm optkw optsz fname otherprm
	if optsz = '' then signal usage
	if fname = '' then signal usage
	optsz = optsz * 1024
end
else
do
	parse var prm fname otherprm
	if fname = '' then signal usage
	optsz = 1350 * 1024
end
/* 余分なパラメータはエラー */
if otherprm <> '' then signal usage
/* サイズパラメータチェック */
if datatype(optsz, 'W') = 0 then signal usage
if optsz < 0 then signal usage

/* 対象ファイル名を分割 */
rvfname = reverse(fname)
parse var rvfname rvext '.' rvbody '\' rvdir
if rvbody = '' then
do /* 拡張子なしのファイル */
	parse var rvfname rvbody '\' rvdir
	rvext = ''
end
body = reverse(rvbody)
ext = reverse(rvext)
dir = reverse(rvdir)
/* 拡張子がbatあるいは数字のみだとエラー */
if translate(ext) = "BAT" then signal exterr
if datatype(ext, 'W') = 1 then signal exterr
/* DOSの8.3のファイルのみサポート */
if length(body) > 8 | length(ext) > 3 then signal fnerr

/* 対象ファイルの存在確認 */
if stream(fname, 'C', "QUERY EXISTS") = "" then signal usage
/* 対象ファイルの大きさ */
fsz = stream(fname, 'C', "QUERY SIZE")
/* 指定サイズより小さければ分割しない */
if fsz < optsz then signal onefile
/* 分割した結果が999を越えればエラー */
if fsz / optsz > 999 then signal toomany

/* 分割される拡張子連番 */
exti = 1
/* バッチファイル名 */
batfn = body'.bat'

/* バッチコマンド */
batcmd = 'copy '

/* main */
say "Cutting file" fname

/* 分割回数fsz % optsz + 1; 最後の1回は残り（optsz以下）を読み込む */
do fsz % optsz

/* 連番を付けたファイルに出力 */
	pfn = body||'.'||right('00'||exti, 3)
/* ファイルが存在すれば削除する */
	if stream(pfn, 'c', "QUERY EXISTS") <> "" then "del" pfn
	say "Writing" pfn
/* 出力ファイルを開く */
	rc = stream(pfn, 'C', "OPEN WRITE")

/* 指定した長さの分読み込みと出力 */
	if optsz > inlen then
	do	/* DOSの場合CHARINで分割読み込み */
		part = ''
		do optsz % inlen
			part = charin(fname, , inlen)
			call charout pfn, part
		end
		part = charin(fname, , optsz // inlen)
		call charout pfn, part
	end
	else
	do
		part = charin(fname, , optsz)
		call charout pfn, part, 1
	end

/* ファイルを閉じる */
	rc = stream(pfn, 'C', "CLOSE")

/* バッチコマンドにファイル名を追加 */
	batcmd = batcmd||'/b '

/* 連番1以外なら'+'を追加 */
	if exti > 1 then batcmd = batcmd||'+ '
	batcmd = batcmd||pfn||' '
	exti = exti + 1

/* while end */
end

/* 残りサイズはfsz // optsz */
lftfsz = fsz // optsz
/* 連番を付けたファイルに出力 */
pfn = body||'.'||right('00'||exti, 3)
/* ファイルが存在すれば削除する */
if stream(pfn, 'c', "QUERY EXISTS") <> "" then "del" pfn
say "Writing" pfn
/* 出力ファイルを開く */
rc = stream(pfn, 'C', "OPEN WRITE")

/* 指定した長さの分読み込みと出力 */
if inlen < lftfsz then
do	/* DOSの場合CHARINで分割読み込み */
	part = ''
	do lftfsz % inlen
		part = charin(fname, , inlen)
		call charout pfn, part
	end
	part = charin(fname, , lftfsz // inlen)
	call charout pfn, part
end
else
do
	part = charin(fname, , lftfsz)
	call charout pfn, part, 1
end

/* ファイルを閉じる */
rc = stream(pfn, 'C', "CLOSE")

/* バッチコマンドにファイル名を追加 */
batcmd = batcmd||'/b '
batcmd = batcmd||'+ '||pfn||' '

/* ファイル分割終わり */

/* バッチコマンドに対象ファイル名を追加 */
batcmd = batcmd||'/b '||body||'.'||ext||x2c("0D0A")
/* バッチファイルにバッチコマンド出力 */
/* ファイルが存在すれば削除する */
if stream(batfn, 'c', "QUERY EXISTS") <> "" then "del" batfn
say "Creating batch file" batfn
call charout batfn, batcmd, 1

exit

usage:
say "Usage:"
say cmdname "[-size nnn] ファイル名"
say "nnn: 分割されたファイルの大きさ(k byte) デフォルト=1350k"
exit

onefile:
say "指定サイズより小さいファイルなので分割できません"
exit

exterr:
say "拡張子がBATあるいは数字のみのものはサポートしません"
exit

fnerr:
say "DOSのファイル名を指定してください"
exit

toomany:
say "分割ファイルが999個以下になるように指定してください"
exit