/* REXX */
/* 一定時間毎にランダムにデスクトップの壁紙を設定する */
/* (C) Copyright 1997 kyo */

options 'ETMODE'; options 'EXMODE';
arg period wallpdir fext itype '@' tr
trace value tr;
/* default period */
if period = '' | DATATYPE(period) <> 'NUM' then
do
	period = 60
end
else
do
	period = STRIP(period)
end
/* Default Wallpaper directory */
if wallpdir = '' then
do
	wallpdir = 'f:\os2\bitmap\'
end
/* Default file extention */
if fext = '' then
do
	fext = 'bmp'
end
/* Default image type */
if itype = '' then
do
	itype = 'N'
end
/* Load functions */
if RxFuncQuery('SysLoadFuncs') then call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
/* Get image file info */
numjpeg = SysFileTree(wallpdir||'*.'||fext, 'file', 'O')
if numjpeg <> 0 | file.0 = 0 then
do
	signal error
end
/* 無限ループ */
do forever
/* 乱数 */
	r = random(1, file.0)
	param = 'BACKGROUND='||file.r||','||itype
	call SysSetObjectData'', param
/* 秒数分Wait */
	call SysSleep(period)
end
exit

error:
say 'Error !'
exit