/* Kernel update installation script */
/* Created: 05.11.2005               */

parse arg target source option

/* env */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* start */
Say
Say 'Starting installation...'

/* Removing RO attributes */
Say
Say 'Removing RO attributes from kernel files...'
'@attrib -r -s -h 'target'\os2krnl >> 'product_log' 2>>&1'
'@attrib -r -s -h 'target'\os2ldr  >> 'product_log' 2>>&1'

/* backing up old files */
Say
Say 'Backing up old files...'
'@copy  'target'\os2krnl 'target'\os2krnl.sav >> 'product_log' 2>>&1'
'@copy  'target'\os2ldr  'target'\os2ldr.sav  >> 'product_log' 2>>&1'
'@copy  'target'\os2dump 'target'\os2dump.sav >> 'product_log' 2>>&1'
'@mkdir 'target'\os2\system\trace\backup      >> 'product_log' 2>>&1'
'@xcopy 'target'\os2\system\trace\*.tdf 'target'\os2\system\trace\backup\. >> 'product_log' 2>>&1'

/* updating files */
Say
Say 'Updating files...'
'@unzip -o 'inst_dir'\kernel.zip -d 'target'\. >> 'product_log' 2>>&1'

/* delete some files */
'@del 'target'\readme  >> 'product_log' 2>>&1'
'@del 'target'\warning >> 'product_log' 2>>&1'
