/* REXX **********************************************/
/*                                                   */
/* Name.......: TESTALG1.CMD                         */
/* Function...: Test Rexx-algorithms from the file   */
/*              RXALGO01.CMD:                        */
/*               1. Bubble sort                      */
/*               2. Binary search                    */
/*               3. Insertion sort                   */
/*               4. Quick sort                       */
/*               5. Shell sort                       */
/*               6. Square root                      */
/*               7. Translation to lower case        */
/*               8. Digital Audio Player (mciRexx)   */
/*               9. Exclude multiple items           */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines or comment out the  */
/*              Say statements for Random and Sort   */
/*              functions                            */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

Say 
Say 'This file is the test-routine for the sample internal' 
Say 'Rexx-subroutines from the file RXALGO01.CMD'
Say 'Start this file with PMREXX to see the output lines'
Say 'or comment out the Say statements of the stem-variable'
Say 'from RandomStem and test-sort calls .'
Say
Say 'Refer to the source code of this file for more'
Say 'informations, please.'
Say 
Say 'The sample calls of this routines follows.'
Say 'Press any key to continue. '

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Call CharIn
Call SysCls

/*--------------(Set random numbers)-------------*/
number = 100
Call RandomStem number
search_value = stem.1

/*-----------------(Bubble Sort)-----------------*/
Say
Say 'Test Bubble Sort.'
start = Time(r)
Call BubSort
endTime = Time(r)
Say 'Sort duration:' endTime
Say "Press enter to continue"
Pull y
/* Following 3 statements can be comment out */
Do i = 1 To stem.0
  Say stem.i
End 
/*--------------(Duration: 1.630000)-------------*/

/*----------------(Binary Search)----------------*/
Say
Say 'Test Binary Search. Search for:' search_value
start = Time(r)
found = BiSearch(search_value)
endTime = Time(r)
Say 'Search duration:' endTime
If found > 0 Then Say stem.found
Else Say 'Nothing found'
Say "Press enter to continue"
Pull y
/*--------------(Duration: 0.030000)-------------*/

/*--------------(Set random numbers)-------------*/
number = 100
Call RandomStem number

/*-----------------(Insert Sort)-----------------*/
Say
Say 'Test Insert Sort.'
start = Time(r)
Call InsSort
endTime = Time(r)
Say 'Sort duration:' endTime
Say "Press enter to continue"
Pull y
/* Following 3 statements can be comment out */
Do i = 1 To stem.0
  Say stem.i
End 
/*-------------(Duration: 1.590000)--------------*/

/*-------------(Set random numbers)--------------*/
number = 100
Call RandomStem number

/*-----------------(Quick Sort)------------------*/
Say
Say 'Test Quick Sort.'
start = Time(r)
Call QSort
endTime = Time(r)
Say 'Sort duration:' endTime
Say "Press enter to continue"
Pull y
/* Following 3 statements can be comment out */
Do i = 1 To stem.0
  Say stem.i
End 
/*-------------(Duration: 0.310000)--------------*/

/*-------------(Set random numbers)--------------*/
number = 100
Call RandomStem number

/*-----------------(Shell Sort)------------------*/
Say
Say 'Test Shell Sort.'
start = Time(r)
Call ShlSort
endTime = Time(r)
Say 'Sort duration:' endTime
Say "Press enter to continue"
Pull y
/* Following 3 statements can be comment out */
Do i = 1 To stem.0
  Say stem.i
End 
/*-------------(Duration: 0.880000)--------------*/

/*--------------(Test Square Root)---------------*/
Say
Say 'Sqrt('search_value') =' SqrRoot(search_value)

/*------------(Test To Lower Case)---------------*/
Say
string = 'TEST TRANSLATION TO LOWER CASE OF ,  AND '
Say 'This string:' string
Say 'is translated to lower case:'
Say ToLower(string)

/*------------(Test Digital Player)--------------*/
rc = RxFuncAdd('mciRxInit','MCIAPI','mciRxInit')
Init_RC = mciRxInit()

/* Adjust following file name */
Sound_File = 'D:\MMOS2\SOUNDS\startup.wav'
Say 
Say 'Sound file:' Sound_File 'is played. Please wait for the end.'
rc = PlayFile(Sound_File)
Call mciRxExit

/*--------( Test Exclude duplicate items )-------*/
Drop stem.

stem.1 = 2
stem.2 = 3
stem.3 = 3
stem.4 = 3
stem.5 = 6
stem.6 = 6
stem.7 = 6
stem.8 = 6
stem.9 = 7
stem.10= 8
stem.0 = 10

Say 
Say 'Test Exclude multiple items'
Say
Say 'Before:'
Do i = 1 To stem.0 
  Say stem.i
End 
Say 'After:'
Call NoMult

Do queued()
  Pull x
  say x
End
Say
Say 'Press any key to exit'
Pull x

Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
  Call mciRxExit
Exit


/*===============(Internal subroutines)==============*/

/*===========(Fill stem with random numbers)=========*/
/*                                                   */
/* Name.......: RandomStem                           */
/*                                                   */
/* Function...: Fills the stem with random numbers   */
/*                                                   */
/* Call parm..: Number of items  (default = 10)      */
/* Returns....: Nothing (NULL string)                */
/*                                                   */
/* Syntax.....: Call RandomStem number               */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
RandomStem: Procedure Expose stem.

Arg number

If Datatype(number) \= 'NUM' Then number = 10
stem.0 = number

Do i = 1 To number
  stem.i = Random( )
  /* Following statement can be comment out */
  Say stem.i
End

Return ''

/*==================(Binary search)==================*/
/* :-))                                              */
/* Name.......: BiSearch                             */
/*                                                   */
/* Function...: Search a stem variable for a value   */
/* Call parm..: Search value                         */
/* Returns....: 0 if nothing found                   */
/*              index of the found value             */
/* Sample call: found_index = BiSearch(value)        */
/*              If found_index = 0 Then              */
/*                Say 'Value' value 'not found!'     */
/*              Else                                 */
/*                Say stem.found_index               */
/*                                                   */
/* Notes......: The elements to search for must be   */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*              The stem-variable must be in the     */
/*              sorted order                         */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

BiSearch: Procedure Expose stem.

Parse Arg value           /* Search value            */

found  = 0                /* Index of the found Item */
bottom = 1                /* Index of the first Item */
top    = stem.0           /* Index of the last Item  */

/*------------------(Binary Search)------------------*/
Do While found = 0 & top >= bottom
  mean = (bottom + top) % 2
  If value = stem.mean Then
    found = mean
  Else If value < stem.mean Then
    top = mean - 1
  Else
    bottom = mean + 1
End /* Do While */

Return found


/*===================(Bubble sort)===================*/
/* :-I                                               */
/* Name.......: BubSort                              */
/*                                                   */
/* Function...: Bubble Sort for a stem variable      */
/* Call parm..: No                                   */
/* Returns....: nothing (NULL string)                */
/*                                                   */
/* Sample call: Call BubSort                         */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

BubSort: Procedure Expose stem.

/*------------(Bubble Sort for the Stem)-------------*/
Do i = stem.0 To 1 By -1 Until flip_flop = 1
  flip_flop = 1
  Do j = 2 To i
    m = j - 1
    If stem.m > stem.j Then Do
      xchg   = stem.m
      stem.m = stem.j
      stem.j = xchg
      flip_flop = 0
    End /* If stem.m ... */
  End /* Do j = 2 ...    */
End /* Do i = stem.0 ... */

Return ''


/*=================(Insertion sort)==================*/
/* :-!                                               */
/* Name.......: InsSort                              */
/*                                                   */
/* Function...: Insertion Sort for a stem variable   */
/* Call parm..: No                                   */
/* Returns....: nothing (NULL string)                */
/*                                                   */
/* Sample call: Call InsSort                         */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

InsSort: Procedure Expose stem.

/*------------(Insertion Sort for Stem)--------------*/
Do x = 2 To stem.0
  xchg = stem.x
  Do y = x - 1 By -1 To 1 While stem.y > xchg
    xchg   = stem.x
    stem.x = stem.y
    stem.y = xchg
    x = y
  End /* Do y = x... */
  stem.x = xchg
End /* Do x = 2 ...  */

Return ''


/*====================(Quick sort)===================*/
/* :-))                                              */
/* Name.......: QSort                                */
/*                                                   */
/* Function...: Quick Sort for a stem variable       */
/* Call parm..: No                                   */
/* Returns....: Left-Right span                      */
/*                                                   */
/* Sample call: Call QSort                           */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

QSort: Procedure Expose stem.

/*--------------(Quick Sort for Stem)----------------*/
Arg left, right

If left  = '' Then left  = 1
If right = '' Then right = stem.0
If right > left Then Do
  i = left
  j = right
  k = (left+right)%2
  x = stem.k
  Do Until i > j
    Do While stem.i < x; i = i + 1; End
    Do While stem.j > x; j = j - 1; End
    If i <= j Then Do
      xchg = stem.i
      stem.i = stem.j
      stem.j = xchg
      i = i + 1
      j = j - 1
    End
  End
  y = QSort(left,j)
  y = QSort(i,right)
End

Return right - left 


/*====================(Shell sort)===================*/
/* :-)                                               */
/* Name.......: ShlSort                              */
/*                                                   */
/* Function...: Shell Sort for a stem variable       */
/* Call parm..: No                                   */
/* Returns....: nothing (NULL string)                */
/*                                                   */
/* Sample call: Call ShlSort                         */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

ShlSort: Procedure Expose stem.

/*---------------(Shell Sort for Stem)---------------*/
parts = 3       /* adjust to your necessities ( >1 ) */
Do n = 1 To parts
  incr = 2**n - 1
  Do j = incr + 1 To stem.0
    i = j - incr
    xchg = stem.j
    Do While xchg < stem.i & i > 0
      m = i + incr
      stem.m = stem.i
      i = i - incr
    End /* Do While xchg ... */
    m = i + incr
    stem.m = xchg
  End /* Do j = incr ... */
End /* Do n = 1 ... */

Return ''


/*===================(Square root)===================*/
/* :-)                                               */
/* Name.......: SqrRoot                              */
/*                                                   */
/* Function...: Square root evolution for the call   */
/*              parameter                            */
/* Call parms.: Evolution number, precision          */
/* Returns....: Square root                          */
/*                                                   */
/* Syntax.....: sqrt = SqrRoot(number, [precision])  */
/*                                                   */
/* Notes......: precision is the highest possible    */
/*              error for the evaluation.            */
/*              Default Value is 0.00001             */
/*              You are responsible for the valid    */
/*              number value                         */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

SqrRoot: Procedure Expose stem.

/*--------------(Square root evolution)-------------*/
Arg number, precision

If Datatype(number) \= 'NUM' Then Return -1
If precision <= 0 | precision > 1 Then precision = 0.00001

sqrt = 1
 
Do Until Abs(sqrt_old - sqrt) < precision
  sqrt_old = sqrt
  sqrt = (sqrt_old * sqrt_old + number) / (2 * sqrt_old)
End /* Do Until ... */

Return sqrt


/*============(Play digital WAV/MID file)============*/
/* :-)                                OS/2 Only!!!   */
/* Name.......: PlayFile                             */
/*                                                   */
/* Function...: Play digital WAV/MID file            */
/*                                                   */
/* Call parms.: File name to play                    */
/* Returns....: RC from the last mciRexx function    */
/*                                                   */
/* Sample call: rc = PlayFile('bach.mid')            */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
PlayFile: Procedure

Arg CmdObject
If CmdObject = '' Then Return -1

loudness = 70 /* % */
/*--------------(Prepare MCI-commands)---------------*/
CmdStr.1 = 'OPEN' CmdObject 'ALIAS W WAIT'
CmdStr.2 = 'SET W TIME FORMAT MS WAIT'
CmdStr.3 = 'SET W AUDIO VOLUME' loudness 'WAIT'
CmdStr.4 = 'PLAY W WAIT'
/*------------(Play digital WAV/MID file)------------*/
Do i = 1 To 4
  /*-------(Send MCI command strings)--------*/
  rc = mciRxSendString(CmdStr.i, 'retstrvar', '0','0')
  If rc > 0 Then Leave
End

CmdStr = 'CLOSE W WAIT'
/*-------------(Send MCI command string)-------------*/
rc = mciRxSendString(CmdStr, 'retstrvar', '0','0')

Return rc


/*=============(Translate To Lower Case)=============*/
/* :-)                                               */
/* Name.......: ToLower                              */
/*                                                   */
/* Function...: Translate entired string to lower    */
/*              case                                 */
/* Call parms.: String to translate                  */
/* Returns....: Translated string                    */
/*                                                   */
/* Syntax.....: lowString = ToLower(upperString)     */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
ToLower: Procedure

/*-----------(Lower Case entired string)------------*/
Parse Arg Upper_String

Lowers = XRange('a','z') || ''
Uppers = XRange('A','Z') || ''

Return Translate(Upper_String,Lowers,Uppers)


/*============( Exclude duplicate items )=============*/
/*                                                 11 */
/* Name.......: NoMult                                */
/*                                                    */
/* Function...: excludes multiple items from a sorted */
/*              stem variable                         */
/* Call parm..: no                                    */
/* Returns....: 0                                     */
/*                                                    */
/* Syntax.....: Call NoMult                           */
/*                                                    */
/* Notes......: The elements to exclude must be       */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*              The stem variable must be previously  */
/*              sorted                                */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
NoMult: Procedure Expose stem.

Do i = 1 To stem.0
  Queue stem.i
  Do j = i + 1 while stem.i = stem.j
  End
  i = j - 1
End

Return 0
