/* DUMPALL.CMD: This Rexx program runs the show for EXTRACT/MERGER
   program.
*/
parse arg site
if site = '' then do
  site = 'baum02.ege.edu.tr'
  site = 'omega.gmd.de'
  site = 'vm3090.ege.edu.tr'
  site = 'news.ege.edu.tr'
  site = "news.metu.edu.tr"
  site = 'liberty.uc.wlu.edu'
end

/* This is what will be put between each message. This needs to be
 the same for EXTRACT.CFG as well.
*/
SEPARATOR = '**#turgut#**'

'C:'
'CD \DOCS'
'DEL S\S.UUE'
"\binp\dumpgrp -s"site "-r -l"SEPARATOR
say 'DUMPGRP returns:' rc
if rc = 1 then exit rc
if rc = -1 then exit rc

/* Does S.UUE exist? */
If lines('C:\DOCS\S\S.UUE') < 1 Then Exit 0
r = lineout('C:\DOCS\S\S.UUE',,)

'CD S'
'ERASE INCOMP.ZUP'
'REN S.UUE INCOMP.ZUP'

/* NOEOF removes CTRL-Z that may be present in file.. */
'..\NOEOF'

if lines('INCOMP.OUT') > 0 Then Do
  r = lineout('INCOMP.OUT',,)
  'DEL INCOMP.ZUP'
  'REN INCOMP.OUT INCOMP.ZUP'
end

'CD ..'
'EXTRACT'
'MERGER'
'CD S'
'DEL INCOMP.BAK'
'REN INCOMP.ZUP INCOMP.BAK'
'CD ..'
call DEUUE
'MOVE *.ZIP S'
'MOVE *.ARJ S'
'MOVE *.GIF S'
'MOVE *.JPG S'
'MOVE *.MPG S'
'MOVE *.DL  S'
exit

/* Here we decode the received pieces: */
DeUUE:
'FORALL *.GI : UUDDEL "@S" "@N.GIF"'
'FORALL *.JP : UUDDEL "@S" "@N.JPG"'
'FORALL *.ZI : UUDDEL "@S" "@N.ZIP"'
'FORALL *.MP : UUDDEL "@S" "@N.MPG"'
'FORALL *.DL : UUDDEL "@S" "@N.DL_"'
'FORALL *.AR : UUDDEL "@S" "@N.ARJ"'
Return

