/*
	filemtch.c
	
	by sava/LP-Project, 1998-1999.
*/


#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "filemtch.h"

const char *  c_next(const char * s);
const char *  c_prev(const char * s, const char * top);

char *  my_strpbrk(const char *s, const char *t);
int  my_memcmp(const void * m1, const void * m2, int cnt, int case_sense);
int  my_strcmp(const char * s1, const char * s2, int case_sense);


int  file_match(const char *s, const char *match, int case_sense)
{
	int		result = 0;
	const char *	m;
	int		slen, len;
	
	if (*match == '\0') {
		return (*s == '\0');
	}
	
	slen = strlen(s);
	
	m = my_strpbrk(match, "*?");
	if (m == NULL) { /* Xg[Pr */
		return (my_strcmp(s, match, case_sense) == 0);
	}
	
	len = m - match;
	if (len > 0) {
		if (slen >= len && my_memcmp(s, match, len, case_sense) == 0) {
			return file_match(s + len, match + len, case_sense);
		} else {
			return 0;
		}
	} else {
		if (slen >= 1 && *m == '?') {
			return file_match(c_next(s), match + 1, case_sense);
		}
		if (*m == '*') {
			++match;
			while(1) {
				result = file_match(s, match, case_sense);
				if (result || (*s == '\0')) break;
				s = c_next(s);
			}
		}
	}
	
	return result;
}



const char *  c_next(const char * s)
{
	return s + 1;
}

const char *  c_prev(const char * s, const char * top)
{
	const char * p;
	
	p = s - 1;
	
	return (p >= top) ? p : NULL;
}

char *  my_strpbrk(const char *s, const char *s2)
{
	return strpbrk((char *)s, (char *)s2);
}

int  my_memcmp(const void * m1, const void * m2, int cnt, int case_sense)
{
	int		r;
	unsigned char	c1, c2;
	unsigned char	*p1, *p2;
	
	if (case_sense) return memcmp(m1, m2, cnt);
	
	p1 = (unsigned char *)m1;
	p2 = (unsigned char *)m2;
	
	while(cnt) {
		c1 = *p1++ | ('a' - 'A');
		c2 = *p2++ | ('a' - 'A');
		r = c1 - c2;
		if (r != 0) break;
		--cnt;
	}
	
	return r;
}


int  my_strcmp(const char * s1, const char * s2, int case_sense)
{
	if (case_sense) return strcmp(s1, s2);
	
	return stricmp(s1, s2);
}

