/* decode.cmd - decode raw digitizer data */
parse arg iFile /* obtain argument */

/* set default input file name */
if iFile=='' then iFile = '38400.RAW'

/* sanity check */
if chars(iFile)==0 then do
  say '"'||iFile||'" is an empty or non existant input file!'
  exit
  end

/* initialize */
byte.0='00'x ; i=0

do while chars(iFile) \= 0
  call GetPacket
/*
**     bit    7     6     5     4     3     2     1     0
**         Ŀ
**  byte.1   1    0    0    1    0    0    0   Bt0 
**         Ĵ
**  byte.2   0   x13  x12  x11  x10  x09  x08  x07 
**  byte.3   0   x06  x05  x04  x03  x02  x01  x00 
**  byte.4   0   y13  y12  y11  y10  y09  y08  y07 
**  byte.5   0   y06  y05  y04  y03  y02  y01  y00 
**         
**            finger event record when 5 bytes received
**
**     bit    7     6     5     4     3     2     1     0
**         Ŀ
**  byte.1   1    0    0    1    0    0    0   Bt0 
**         Ĵ
**  byte.2   0   x13  x12  x11  x10  x09  x08  x07 
**  byte.3   0   x06  x05  x04  x03  x02  x01  x00 
**  byte.4   0   y13  y12  y11  y10  y09  y08  y07 
**  byte.5   0   y06  y05  y04  y03  y02  y01  y00 
**  byte.6   0   z13  z12  z11  z10  z09  z08  z07 
**  byte.7   0   z06  z05  z04  z03  z02  z01  z00 
**         
**            finger event record when 7 bytes received
**
**     bit    7     6     5     4     3     2     1     0
**         Ŀ
**  byte.1   1    0   Prx   0    0    0   Bt1  Bt0 
**         Ĵ
**  byte.2   0   x13  x12  x11  x10  x09  x08  x07 
**  byte.3   0   x06  x05  x04  x03  x02  x01  x00 
**  byte.4   0   y13  y12  y11  y10  y09  y08  y07 
**  byte.5   0   y06  y05  y04  y03  y02  y01  y00 
**  byte.6   0   z11  z10  z09  z08  z07  z06  z05 
**  byte.7   0   z04  z03  z02  z01  z00   ?    ?  
**         Ĵ
**  byte.8   0    0    0    0    0    0    0    0  
**  byte.9   0    0    0    0    0    0    0    0  
**         
**            stylus event record when 9 bytes received
**
**     bit    7     6     5     4     3     2     1     0
**         Ŀ
**  byte.1   1    0    0    1    0    0   Bt1  Bt0 
**         Ĵ
**  byte.2   0   x13  x12  x11  x10  x09  x08  x07 
**  byte.3   0   x06  x05  x04  x03  x02  x01  x00 
**  byte.4   0   y13  y12  y11  y10  y09  y08  y07 
**  byte.5   0   y06  y05  y04  y03  y02  y01  y00 
**  byte.6   0   z13  z12  z11  z10  z09  z08  z07 
**  byte.7   0   z06  z05  z04  z03  z02  z01  z00 
**         Ĵ
** byte.08   0   x13  x12  x11  x10  x09  x08  x07 
** byte.09   0   x06  x05  x04  x03  x02  x01  x00 
** byte.10   0   y13  y12  y11  y10  y09  y08  y07 
** byte.11   0   y06  y05  y04  y03  y02  y01  y00 
** byte.12   0   z13  z12  z11  z10  z09  z08  z07 
** byte.13   0   z06  z05  z04  z03  z02  z01  z00 
**         
**            finger event record when 13 bytes received
*/
  sBtn=right(c2d(bitand(byte.1,'0F'x)),2,'0')
  xPos=right(128*c2d(byte.2)+1*c2d(byte.3),5,'0')
  yPos=right(128*c2d(byte.4)+1*c2d(byte.5),5,'0')
  event=byte.1
  select
    when event=='90'x then call Finger('NoButMov')
    when event=='91'x then call Finger('But1Down')
    when event=='92'x then call Finger('But2Down')
    when event=='93'x then call Finger('But3Down')
    when event=='80'x then call Stylus('NoButMov')
    when event=='A0'x then call Stylus('MoveOnly')
    when event=='A1'x then call Stylus('But1Down')
    when event=='A2'x then call Stylus('But2Down')
    when event=='A3'x then call Stylus('But3Down')
    otherwise call Unknown
    end
  end
exit

GetPacket:
do until i==6|i==8|i==10|i=14
  byte.1=byte.i ; i=1
  do until bitand(byte.i,'80'x)=='80'x
    if chars(iFile)==0 then return
    i=i+1 ; byte.i=charin(iFile)
    end
  end
return

Finger:
parse arg type
/* show report */
output='sBtn='||sBtn||',xPos='||xPos||',yPos='||yPos
say output||',Finger:'||type
return

Stylus:
parse arg type
/* show report */
zPos=right(32*c2d(byte.6)+c2d(bitand(byte.7,'7C'x))%4,5,'0')
output='sBtn='||sBtn||',xPos='||xPos||',yPos='||yPos||',zPos='||zPos
say output||',Stylus:'||type
return

Unknown:
/* show packet */
packet=c2x(byte.1||byte.2||byte.3||byte.4||byte.5)
if i>=08 then packet=packet||c2x(byte.6||byte.7)
if i>=10 then packet=packet||c2x(byte.8||byte.9)
if i==14 then packet=packet||c2x(byte.10||byte.11||byte.12||byte.13)
say 'Packet='||packet||',Huh?'
return
