/* SecureEntry Release 3.x uninstaller routine   */
/* (C) IBM Corp  1996,1998. All rights reserved  */
/* Returns 0 -> all ok, 1 -> warnings 2->error   */

say 'IBM SecureEntry for OS/2 Version 3'
say '5793-R46 (C) Copyright IBM Corp. 1996'
say 'All Rights reserved. US Government Users Restricted Rights -'
say 'Use, duplication or disclosure restricted by GSA ADP '
say 'Schedule Contract with IBM Corp. '
say 'Licensed Materials - Property of IBM.'
say

If RxFuncQuery('SysLoadFuncs') Then
Do
  Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  Call SysLoadFuncs
End

parse arg command

batchparm=0
shutdownparm=0
do while command<>''
  parse var command p1 command
  if strip(translate(p1))='BATCH' then batchparm=1
  else
  if strip(translate(p1))='SHUTDOWN' then shutdownparm=1
  else
  do
    say 'ERROR: Unknown parameter :'p1
    return 2
  end
end


/* 0. Verify Sentry is installed */

installpath = value('SGM_SHELL',,'OS2ENVIRONMENT')
if installpath='' then
do
  say 'Error : SecureEntry not installed'
  return 2
end

sefilepath=installpath
if substr(sefilepath,length(sefilepath),1)<>'\' then
   sefilepath=sefilepath'\'


parse upper value VALUE("PATH",,"OS2ENVIRONMENT") with ":\OS2\SYSTEM"-1 bootdrive+1
ospath=value('PATH',,'OS2ENVIRONMENT')
sesfilepath=bootdrive':\os2\security\sesdb\secure.sys'
savesesfile=sefilepath'install\SECURE.SEN'
oldstartupfile=bootdrive':\STARTUP.CMD'
savestartupfile=sefilepath'install\STARTUP.SEN'
configfile=bootdrive':\CONFIG.SYS'
newconfigfile=bootdrive':\CONFIG.NEW'
saveconfig=bootdrive':\CONFIG.SEN'

address cmd '@rxqueue /clear'                         /* Clear the Queue */
address cmd '@Ver /R|rxqueue /fifo > nul'       /* Get OS/2 Revision Level */
Do Queued()
  Parse Pull linea
End
Parse var linea . revnumber               /* Just get the build level */
revnumber=Strip(revnumber)
vernumber=left(SysOS2Ver(),3)

ismerlin=0
if (datatype(revnumber,'N')=1)&(datatype(vernumber,'N')=1) then
do
  if vernumber>2.3 then ismerlin=1
end

if rxfuncquery('rxedyucm_getuser') then
do
  call rxfuncadd 'RxEdyUcmLoadFuncs', 'RXUCM','RxEdyUcmLoadFuncs'
  call RxEdyUcmLoadFuncs
end

isadmin=1
if stream(sefilepath'install\SENTRY.SIG','c','query exists')<>'' then
do
  if rxfuncquery('rxedyucm_getuser')=0 then
  do
    gu=rxedyucm_getuser()
    parse var gu other'ADMIN:'isadmin
  end
end
if batchparm=0 then
do
  if isadmin=0 then
  do
    say 'ERROR: Administrator privilege required'
    return 2
  end
  say 'SecureEntry deinstallation procedure'
  say '===================================='
  say 'WARNING : This process will completely remove SecureEntry from'
  say 'this workstation. Do you want to proceed (yes/no) ?'
  parse pull response
  if abbrev('YES',translate(strip(response)),1) then
  do
    returncode=0
  end
  else
  do
    if abbrev('NO',translate(strip(response)),1)=0 then say 'NO assumed'
    returncode=1
    return returncode
  end
end
else
do
  if rxfuncquery('RxEdyUcm_Enable_Remote')=0 then
  do
    call RxEdyUcm_Enable_Remote 8
  end
  returncode=0
end

configuration=0
institution=''
installpath=''
servername=''
domainname=''
allowdomainchange=''
serverpath=''
useracf=0
useucm=0
installsources=1
installtreelock=1
useses=1

descfilepath=sefilepath'install\sentry.cnf'

rc=stream(descfilepath,'c','open read')
if rc='READY:' then
do
  say 'Reading configuration file..'
  linenumber=0
  do while lines(descfilepath)
    line=linein(descfilepath)
    linenumber=linenumber+1
    parse var line line'//'
    line=strip(line)
    if (line<>'') then
    do
      parse var line token'='value
      token=strip(translate(token))
      value=strip(value)
      select
         when abbrev('ALLOWDOMAINCHANGE',token,1)     then allowdomainchange   =value
         when abbrev('CONFIGURATION',token,1)  then configuration=value
         when abbrev('DOMAINNAME',token,1)     then domainname   =value
         when abbrev('INSTALLFROM',token,1)    then installfrom  =value
         when abbrev('INSTALLPATH',token,1)    then installpath  =value
         when abbrev('INSTALLSOURCES',token,1)    then installsources  =value
         when abbrev('INSTALLTREELOCK',token,1)    then installtreelock  =value
         when abbrev('INSTITUTION',token,1)    then institution  =value
         when abbrev('SERVERNAME',token,1)     then servername   =value
         when abbrev('SERVERPATH',token,1)     then serverpath   =value
         when abbrev('USERACF',token,1)        then useracf      =value
         when abbrev('USESES',token,1)        then useses      =value
         when abbrev('USEUCM',token,1)         then useucm       =value
         otherwise
            do
              call output 'Error : Syntax error line 'linenumber' : 'line
              return 1
            end
      end
    end
  end
  rc=stream(descfilepath,'c','close')
end

if rxfuncquery('RxEdyUcm_Matches')=0 then
do
  if RxEdyUcm_Matches('?:\IBMLAN\RPL\BB??.??\SGMSHELL\',sefilepath)<>0 then
  do
    /* look in sgmuserpath to see if wsod enabled right now. If yes, recreate the workstations folder. */
    if stream(substr(sefilepath,1,13)'USER'substr(sefilepath,14)'NOUSER\EDYSLA.INI','c','query exists')<>'' then
    do
      say 'Disabling WSOD support'
      address cmd '@'sefilepath'install\SEWSODEN.EXE DA DS 1>nul 2>&1'
    end
  end
end

/* 0.5 Ensure launchpad erased   */
restoredpad=0
if ismerlin=1 then
do
  say 'Clearing warpcenter..'
  /* Set Machine profile */
  address cmd '@'sefilepath'exec\EDYSCTST.EXE 1>nul 2>&1'
  restoredpad=1
end
if restoredpad=0 then
do
  say 'Clearing launchpad..'

  rc=sysfiledelete(sefilepath'nouser\EDYPAD.INI')
  address cmd '@'sefilepath'exec\EDYLNREF.EXE /F 1>nul 2>&1'

  rc=SysMoveObject('<EDY_LP_BACKUP>', '<WP_DESKTOP>')
  if rc=1 then
  do
    rc=SysSetObjectData('<EDY_LP_BACKUP>', 'OBJECTID=<WP_LAUNCHPAD>')
    rc =SysIni('USER', 'PM_Workplace:Location', '<EDY_LP_BACKUP>', 'DELETE:')
    restoredpad=2
  end
end

/* 1. Clear Workbench            */
say 'Destroying workbench..'

if rxfuncquery('RxEdyUcm_QueryObjPath')=0 then
do
  address cmd '@'sefilepath'install\EDYDD.EXE "'RxEdyUcm_QueryObjPath("<SGM_MAIN_WB>")'" /r /n 1>nul 2>&1'
end

result=SysDestroyObject("<SGM_MAIN_WB>")
if result<>1 then
do
  say 'Warning : Unable to destroy workbench folder.'
  returncode=1
end
result=SysDestroyObject(sefilepath"TEMPLATE")
if result<>1 then
do
  say 'Warning : Unable to destroy workbench folder.'
  returncode=1
end

/* 2. Deregister classes         */
if stream(sefilepath'install\EDYCLASS.EXE','c','query exists')<>'' then
do
  say 'Deregistering classes..'
  address cmd '@'sefilepath'install\EDYCLASS /U 1>nul 2>&1'
  if rc<>0 then
  do
    say 'Warning : Deregistering classes ended up in error.'
    returncode=1
  end
end
else
do
  say 'Warning : Could not deregister classes (EDYCLASS not found).'
  returncode=1
end

/* 2.5 Crearing associations */
say 'Clearing associations ...'
associations.0=5
associations.1='SE Launchpad Profile'
associations.2='SE Treelock Profile'
associations.3='SE Floppy Profile'
associations.4='SE SES Profile'
associations.5='SE Win Profile'
MsgFile=sefilepath'EXEC\EDYERROR.MSG'
do i=1 to associations.0
  NewTitle = SysGetMessage(679+i, MsgFile)
  If Abbrev(NewTitle, 'SYS0') then
    NewTitle = ''
  Else
    NewTitle = substr(NewTitle, 1, length(NewTitle) - 2)
  if newtitle<>'' then associations.i=newtitle
end

do i=1 to associations.0
  /* Create type */
  type=associations.i
  call sysini 'USER','PMWP_ASSOC_TYPE',type,'DELETE:'
end


/* 3. Deregister SYS_DLLs        */
if stream(sefilepath'exec\EDYWINI.EXE','c','query exists')<>'' then
do
  say 'Deregistering SYS_DLLs..'
  address cmd '@EDYWINI /U EDYLKSTR EDYSESNO EDYWIN 1>nul 2>&1'
  if rc<>0 then
  do
    say 'Warning : Could not deregister SYS_DLLs.'
    returncode=1
  end
end
else
do
  say 'Warning : Could not deregister SYS_DLLs (EDYWINI not found).'
  returncode=1
end

/* 4. Retouch SES file           */
if stream(savesesfile,'c','query exists')<>'' then
do
  say 'Resetting SES file..'
  address cmd '@copy 'savesesfile' 'sesfilepath' 1>nul 2>&1'
  if rc<>0 then
  do
    say 'Warning : Could not copy old SES configuration file'
    returncode=1
  end
end

/* 5. Retouch CONFIG.SYS         */
say 'Resetting config.sys file'

address cmd '@copy 'configfile' 'saveconfig' 1>nul 2>&1'
if rc<>0 then
do
  say 'Error : Could not backup CONFIG.SYS file as 'saveconfig
  returncode=1
end
else
do
  rc=stream(configfile,'c','open read')
  if rc<>'READY:' then
  do
    say 'Error : Could not open file 'configfile
    returncode=1
  end
  else
  do
    i=0
    do while lines(configfile)
      i=i+1
      filestem.i=linein(configfile)
    end
    rc=stream(configfile,'c','close')
    filestem.0=i

    /* Here setup the steal flag */
    stealSES=0
    if (useses=0) then
    do
      if addconfig(0,'FND','SET SESDBPATH','')<>0 then
      do
        if (stealSES=0) then stealSES=2
      end
    end

    call addconfig  0,'DEL','SET SGM_DB',''
    call addconfig  0,'DEL','SET SGM_SHELL',''
    call addconfig  0,'DEL','SET SGM_OVER_MK',''
    call addconfig  0,'DEL','SET EDYEU',''
    call addconfig  0,'DEL','SET SGM_LS',''
    call addconfig  0,'DEL','SET SGM_UCM_ENABLE',''
    call addconfig  0,'DEL','SET SGM_UCM_BRANCH',''
    call addconfig  0,'DEL','SET SGM_UCM_THIS_BRANCH',''
    call addconfig  0,'DEL','SET SGM_SL_LOGMODE',''
    call addconfig  0,'DEL','SET SGM_SL_LOGPATH',''
    call addconfig  0,'DEL','SET SGM_ADM_PRIV',''
    call addconfig  0,'DEL','SET SGM_SES_LOGPATH',''
    call addconfig  0,'DEL','SET SGM_INI_LOGPATH',''
    call addconfig  0,'DEL','SET SGM_WPS_FASTLOAD',''
    call addconfig  0,'DEL','SET SGM_WPS_LOADCLASS',''
    call addconfig  0,'DEL','SET SGM_WPS_DISABLE',''
    call addconfig  0,'DEL','SET SGM_WPS_PRINTJOBS',''
    call addconfig  0,'DEL','SET SGM_WPS_NONDESKTOP',''
    call addconfig  0,'DEL','SET SGM_WPS_TRACE',''
    call addconfig  0,'DEL','SET SGM_WPS_BEEP',''
    call addconfig  0,'DEL','SET SGM_WPS_SKIP_PREPOPULATE',''
    call addconfig  0,'DEL','SET SGM_SES_CAD',''
    call addconfig  0,'DEL','SET SGM_SES_INACTIVITY',''
    call addconfig  0,'DEL','SET SGM_ALLOW_CAD',''
    call addconfig  0,'DEL','SET SGM_EDYSC_DISABLE',''
    call addconfig  0,'DEL','SET SGM_DISABLE_SYSTEM_KEYS',''
    call addconfig  0,'DEL','SET SGM_HOOK_SYSTEM_KEYS',''
    call addconfig  0,'DEL','SET SGM_EDYLK_SHOW',''
    call addconfig  0,'DEL','SET SGM_BACK_BITMAP',''
    call addconfig  0,'DEL','SET SGM_PM_WAIT_B4_KILL',''
    call addconfig  0,'DEL','SET SGM_PM_WAIT_B4_FLUSH',''
    call addconfig  0,'DEL','SET SGM_WIN_EXPLICITMENUS',''
    call addconfig  0,'DEL','SET SGM_SS_IF_NO_AUTOLOCKUP',''
    call addconfig  0,'DEL','SET SGM_SS_WHEN_LOCKUP',''
    call addconfig  0,'DEL','SET SGM_SS_USEREXIT',''
    call addconfig  0,'DEL','SET SGM_SS_ALLOW_IP',''
    call addconfig  0,'DEL','SET SGM_SS_ALLOW_IU',''
    call addconfig  0,'DEL','SET SGM_SHUTDOWN_AT_LOGON_PANEL',''
    call addconfig  0,'DEL','SET SGM_LS_IFLOGGED',''
    call addconfig  0,'DEL','SET SGM_SLA_EXEC',''
    call addconfig  0,'DEL','SET SGM_SLA_TYPE',''
    call addconfig  0,'DEL','SET SGM_HIDE_EXIT_AFTER_LOGON',''
    call addconfig  0,'DEL','SET SGM_WPS_IGNORE_ADMIN',''
    call addconfig  0,'DEL','SET SGM_REFRESH_PARMS',''
    call addconfig  0,'DEL','SET SGM_NETBIOS_ADAPTER_NUM',''
    call addconfig  0,'DEL','SET SGM_UCM_LOGPATH',''
    call addconfig  0,'DEL','SET EDY_UCM_MAXROWS',''
    call addconfig  0,'DEL','SET SGM_HIDE_WAIT_DLGS',''
    call addconfig  0,'DEL','SET SGM_FORCE_LUALIAS',''
    call addconfig  0,'DEL','SET SGM_FORCE_MODE',''
    call addconfig  0,'DEL','SET SGM_UCM_DBDFT',''
    call addconfig  0,'DEL','SET SGM_HOOK_CANN_KEY',''
    call addconfig  0,'DEL','SET SGM_USER_DLGS',''
    call addconfig  0,'DEL','SET SGM_SNA_TIMEOUT',''
    call addconfig  0,'DEL','SET SGM_SGMSHELL_GROUP',''
    call addconfig  0,'DEL','SET SGM_ROAM_LOGPATH',''
    call addconfig  0,'DEL','SET EDYLOADCLASS',''
    call addconfig  0,'DEL','SET EDYOBJTRACE',''
    call addconfig  0,'RDD','SET PATH',sefilepath'exec'
    call addconfig  0,'RDD','SET PATH',sefilepath'wrkb'
    call addconfig  0,'RDD','SET PATH',sefilepath'service'
    call addconfig  0,'RDD','SET DPATH',sefilepath'exec'
    call addconfig  0,'RDD','SET HELP',sefilepath'help'
    call addconfig  0,'RDD','SET BOOKSHELF',sefilepath'install'
    call addconfig  0,'RDD','LIBPATH',sefilepath'dll'
    call addconfig  0,'RDD','LIBPATH',sefilepath'wrkb\dll'
    if (useses=1) then
    do
      call addconfig  0,'RDD','LIBPATH',bootdrive':\os2\security\ses'
      call addconfig  0,'RDD','LIBPATH',bootdrive':\os2\security\sesdb'
    end

    if (useses=1)|(stealSES=0) then
    do
      call addconfig  0,'DEL','SET RUNWORKPLACE',''
    end

    call addconfig  0,'DEL','SET RESTARTOBJECTS',''
    call addconfig  0,'DEL','SET AUTOSTART',''

    if (useses=1) then
    do
      call addconfig  0,'DEL','PROTSHELL',''
    end

    call addconfig  0,'DEL','DEVICE',sefilepath'EXEC\EDYCAD.SYS'

    if (useses=1) then
    do
      call addconfig  0,'DEL','BASEDEV','SESDD32.SYS'
    end

    call addconfig  0,'DEL','BASEDEV','EDYDD32.SYS'
    call addconfig  0,'DEL','BASEDEV','EDYFLPY.FLT'

    if (useses=1) then
    do
      call addconfig  0,'DEL','CALL',bootdrive':\OS2\SECURITY\SES\SESSTART.EXE 'bootdrive':\OS2\SECURITY\SES\SESDMON.EXE'
    end

    call addconfig  0,'DEL','CALL',sefilepath'exec\edylogfs.exe'

    if (useses=1)|(stealSES=0) then
    do
      call addconfig  0,'DEL','SET SESDBPATH',''
      call addconfig  0,'DEL','SET AUTOGUEST',''
      call addconfig  0,'DEL','SET GUESTNAME',''
      call addconfig  0,'DEL','SET TRUSTEDPATH',''
      call addconfig  0,'DEL','SET USERSHELL',''
      call addconfig  0,'DEL','SET RESTARTUSERSHELL',''
      call addconfig  0,'DEL','SET BACKGROUNDBITMAP',''
    end

    call addconfig  0,'DEL','SET TEMP',sefilepath'TEMP'
    call addconfig  0,'DEL','SET TMP',sefilepath'TEMP'

    if (useses=1) then
    do
      call addconfig 1,'SET','PROTSHELL',bootdrive':\OS2\PMSHELL.EXE'
    end

    if (useses=1)|(stealSES=0) then
    do
      call addconfig 2,'SET','SET RUNWORKPLACE',bootdrive':\OS2\PMSHELL.EXE'
    end

    if restoredpad=1 then
    do
      call addconfig 3,'SET','SET AUTOSTART','PROGRAMS,TASKLIST,FOLDERS,WARPCENTER'
    end
    else
    do
      call addconfig 3,'SET','SET AUTOSTART','PROGRAMS,TASKLIST,FOLDERS,LAUNCHPAD'
    end

    sourcedeldir=sefilepath'INSTALL\EDYDD.EXE'
    if stream(sourcedeldir,'c','query exists')='' then
    do
      parse source p1 p2 thisfile
      sourcedeldir=filespec('drive',thisfile)||filespec('path',thisfile)||'EDYDD.EXE'
    end
    address cmd '@COPY 'sourcedeldir' 'bootdrive':\EDYDD.EXE >nul'
    newerror=0
    rc=sysfiledelete(newconfigfile)
    rc=stream(newconfigfile,'c','open write')
    if rc<>'READY:' then
    do
      say 'Error : Could not recreate file 'newconfigfile
      newerror=1
      returncode=1
    end
    else
    do
      do j=1 to filestem.0
        rc=lineout(newconfigfile,filestem.j)
        if rc<>0 then
        do
          say 'Error : Could not write to file 'newconfigfile
          newerror=1
          returncode=1
        end
      end
      rc=stream(newconfigfile,'c','close')
      if newerror=0 then
      do
        rc=sysfiledelete(configfile)
        rc=stream(configfile,'c','open write')
        if rc<>'READY:' then
        do
          say 'Error : Could not recreate file 'configfile
          address cmd '@copy 'saveconfig' 'configfile' 1>nul 2>&1'
          returncode=1
        end
        else
        do
          rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @echo Completing SecureEntry Uninstall. Please wait...')
          rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @'bootdrive':\EDYDD.EXE 'sefilepath' /n >nul')
          rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'bootdrive':\EDYDD.EXE >nul')
          if stream(bootdrive':\EDYSTART.CMD','c','query exists')<>'' then
            rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'bootdrive':\EDYSTART.CMD >nul')
          if stream(bootdrive':\EDYLKINI.LOG','c','query exists')<>'' then
            rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'bootdrive':\EDYLKINI.LOG >nul')
          if stream(bootdrive':\OS2\SECURITY\SESDB\EDYSLA.LOG','c','query exists')<>'' then
            rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'bootdrive':\OS2\SECURITY\SESDB\EDYSLA.LOG >nul')
          if stream(bootdrive':\OS2\BOOT\EDYDD32.SYS','c','query exists')<>'' then
            rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'bootdrive':\OS2\BOOT\EDYDD32.SYS >nul')
          if stream(bootdrive':\OS2\BOOT\EDYFLPY.FLT','c','query exists')<>'' then
            rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'bootdrive':\OS2\BOOT\EDYFLPY.FLT >nul')
          rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @COPY 'newconfigfile' 'configfile' >nul')
          rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'newconfigfile' >nul')
          rc=lineout(configfile,'CALL='bootdrive':\OS2\CMD.EXE /C @DEL 'saveconfig' >nul')
          do j=1 to filestem.0
            rc=lineout(configfile,filestem.j)
            if rc<>0 then
            do
              say 'Error : Could not write to file 'configfile
              address cmd '@copy 'saveconfig' 'configfile' 1>nul 2>&1'
              returncode=1
            end
          end
          rc=stream(configfile,'c','close')
        end
      end
    end
  end
end

/* 6. Remigrate edystart.cmd     */
if stream(savestartupfile,'c','query exists')<>'' then
do
  say 'Resetting startup file..'
  address cmd '@copy 'savestartupfile' 'oldstartupfile' 1>nul 2>&1'
  if rc<>0 then
  do
    say 'Warning : Could not copy old STARTUP.CMD file'
    returncode=1
  end
end

/* At this point, only EXEC and DLL dirs are alive */
if (batchparm=0)&(shutdownparm=0) then
do
  say 'SecureEntry deinstall first process completed.'
  say 'NOTE:'
  say '- The SecureEntry config.sys file has been copied as 'saveconfig
  say '- The files 'configfile' and 'newconfigfile' are required to complete'
  say '  deinstallation after boot'
  say '- The file 'sefilepath'install\CONFIG.SEN contains the config.sys file'
  say '  that existed before the SecureEntry installation'
  say 'You can review the different configuration files and touch the 'newconfigfile
  say 'file before reboot. This file will be used as the new config.sys file after'
  say 'the following boot.'
  say 'You can shutdown now the system and reboot to complete the process.'
  say 'Do you want to shutdown now (yes/no) ?'
  parse pull response
  if abbrev('YES',translate(strip(response)),1) then
  do
    address cmd 'start shutdown.exe'
  end
  else
  do
    if abbrev('NO',translate(strip(response)),1)=0 then say 'NO assumed'
  end
end
else
do
  if (batchparm=1) then
  do
    if rxfuncquery('RxEdyUcm_Enable_Remote')=0 then
    do
      call RxEdyUcm_Enable_Remote 9
    end
  end
  if shutdownparm=1 then
    address cmd 'start shutdown.exe'
end

return returncode

addconfig:

parse arg order,command,token,value
value=strip(value)
token=strip(token)

if (command='SET')|(command='SEF') then
do
  /* SET command means insert SET token=value to the end of config */
  /* erasing previous value                                        */
  /* The SEF command does the same but only searches an replaces   */
  /* full matching specs                                           */
  /* -1 => to the end. 0=> to the beginning n=> at line position n */
  /* in any case, if the token was found, just substitute it       */

  valueset=0
  j=words(token)
  do i=1 to filestem.0
    parse var filestem.i thetoken'='thevalue
    found=1
    do k=1 to j
      if translate(word(token,k))<>translate(word(thetoken,k)) then
      do
        found=0
        leave
      end
    end
    if found=1 then
    do
      if (command='SET')|(translate(substr(strip(thevalue),1,length(value)))=translate(value)) then
      do
        if (valueset=0) then
        do
          filestem.i=token'='value
          valueset=1
        end
        else
        do
          /* here delete the line */
          do k=i+1 to filestem.0
            z=k-1
            filestem.z=filestem.k
          end
          filestem.0= (filestem.0)-1
        end
      end
    end
  end
  if valueset=0 then
  do
    i=order
    if order=0  then i=1
    if order=-1 then i=1+filestem.0
    if i>1+filestem.0 then i=1+filestem.0
    if filestem.0>i then
    do
      do k=filestem.0 to i by -1
        z=k+1
        filestem.z=filestem.k
      end
    end
    filestem.i=token'='value
    filestem.0=1+filestem.0
  end
end
else
if (command='FND')|(command='FNF') then
do
  j=words(token)
  do i=1 to filestem.0
    parse var filestem.i thetoken'='thevalue
    found=1
    do k=1 to j
      if translate(word(token,k))<>translate(word(thetoken,k)) then
      do
        found=0
        leave
      end
    end
    if found=1 then
    do
      if (command='FND')|(translate(substr(strip(thevalue),1,length(value)))=translate(value)) then
         return i
    end
  end
  return 0
end
if command='DEL' then
do
  j=words(token)
  do i=1 to filestem.0
    parse var filestem.i thetoken'='thevalue
    found=1
    do k=1 to j
      if translate(word(token,k))<>translate(word(thetoken,k)) then
      do
        found=0
        leave
      end
    end
    if found=1 then
    do
      if (value='')|(translate(substr(strip(thevalue),1,length(value)))=translate(value)) then
      do
        /* here delete the line */
        do k=i+1 to filestem.0
          z=k-1
          filestem.z=filestem.k
        end
        filestem.0= (filestem.0)-1
      end
    end
  end
end
else
if (command='ADD')|(command='RDD') then
do
  j=words(token)
  do i=1 to filestem.0
    parse var filestem.i thetoken'='thevalue
    found=1
    do k=1 to j
      if translate(word(token,k))<>translate(word(thetoken,k)) then
      do
        found=0
        leave
      end
    end
    if found=1 then
    do
      parsedstring=''
      parse var thevalue temp';'other
      found=0
      do while temp<>''
        if translate(value)=translate(temp) then
        do
          if command='RDD' then
          do
            if parsedstring='' then
              filestem.i=thetoken'='other
            else
              filestem.i=thetoken'='parsedstring';'other
            found=1
            leave
          end
          else
          do
            found=1
            leave
          end
        end
        if parsedstring='' then parsedstring=temp
        else
           parsedstring=parsedstring';'temp
        parse var other temp';'other
      end
      if (found=0)&(command='ADD') then
      do
        if substr(thevalue,length(thevalue),1)=';' then thevalue=thevalue||value
        else
          thevalue=thevalue';'value
        filestem.i=thetoken'='thevalue
      end
      leave
    end
  end
end
return
