/*--------------------------------------------------------------------------
**
** Copyright (c) 1994 Syntegration
**
** wprest.cmd
**
** Function:   Workplace restore command file
**             this procedure restores the workplace file from a backup
**             directory in a drive other than your boot drive
**------------------------------------------------------------------------*/
ARG   user_dir
/*--------------------------------------------------------------------------
** Load the REXX Utility functions
**------------------------------------------------------------------------*/

CALL RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
CALL RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
CALL RxFuncAdd 'SysRmDir', 'RexxUtil', 'SysRmDir'
CALL RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'


/*----------------------------------------------------------------------
** Load text strings for SysFileDel and SysRmDir return codes.
** then display the logo
**----------------------------------------------------------------------*/

CALL LoadDELRCText
CALL LoadRDRCText


/*-------------------------------------------------------------------------
**
** Function:      DelDir
**
** Description:  Deletes all files and subdirectories in the target,
**                then it deletes the target directory.
**
**-----------------------------------------------------------------------*/

/*-------------------------------------------------------------------------
** Check to make sure the directory exists -
** If it does prompt the user to make sure they really want to do this.
** Otherwise issue a message and exit
**-----------------------------------------------------------------------*/
IF LENGTH(STRIP(user_dir, 'B')) > 0 THEN
DO
   rc = SysFileTree( user_dir, dir_list, 'D')
   IF dir_list.0 = 0  THEN
   DO
      SAY user_dir' not found.'
      exit
   END

   DROP dir_list.

   /*-----------------------------------------------------------------------
   ** Mark all the read-only files to be non read-only
   **---------------------------------------------------------------------*/

   rc = SysFileTree( user_dir, dir_list, 'BO', '****','----')

   DROP dir_list.

   /*-----------------------------------------------------------------------
   ** Go through the list of files and delete each one
   **---------------------------------------------------------------------*/

   rc = SysFileTree( user_dir || '\*.*', dir_list, 'FSO' )
   DO x = 1 TO dir_list.0
      rc = SysFileDelete(dir_list.x)
      SAY dir_list.x '........' DELRCText.RC
   END

   DROP dir_list.

   /*-----------------------------------------------------------------------
   ** Go through all the subdirectories and remove them.
   ** We go backwards through the list in order to delete the
   ** lowest level sudirectories first and work our way back up
   ** the tree.
   **---------------------------------------------------------------------*/

   rc = SysFileTree(user_dir || '\*.*', dir_list, 'DSO')

   DO x = dir_list.0 TO 1 BY -1

      rc=SysRmDir( dir_list.x )
      SAY dir_list.x '........' RDRCText.RC

   END

   DROP dir_list.

   /*-----------------------------------------------------------------------
   ** Delete the directory the user passed
   **---------------------------------------------------------------------*/

   rc = SysRmDir( user_dir )
   SAY user_dir '........' RDRCText.RC

END

exit


/*-------------------------------------------------------------------------
**
** Function:      LoadDELRCText
**
** Description:   Provides text strings for SysFileDel return codes
**
**-----------------------------------------------------------------------*/

LoadDELRCText:

   DELRCText.0    = 'File deleted successfully. '
   DELRCText.2    = 'Error.  File not found. '
   DELRCText.3    = 'Error.  Path not found. '
   DELRCText.5    = 'Error.  Access denied. '
   DELRCText.26   = 'Error.  Not DOS disk. '
   DELRCText.32   = 'Error.  Sharing violation. '
   DELRCText.36   = 'Error.  Sharing buffer exceeded. '
   DELRCText.87   = 'Error.  Invalid parameter. '
   DELRCText.206  = 'Error.  Filename exceeds range error. '

RETURN

/*-------------------------------------------------------------------------
**
** Function:      LoadRDRCText
**
** Description:   Provides text strings for SysRmDir return codes
**
**-----------------------------------------------------------------------*/

LoadRDRCText:

   RDRCText.0     = 'Directory removed successfully. '
   RDRCText.2     = 'Error.  File not found. '
   RDRCText.3     = 'Error.  Path not found. '
   RDRCText.5     = 'Error.  Access denied. '
   RDRCText.16    = 'Error.  Current Directory. '
   RDRCText.26    = 'Error.  Not DOS disk. '
   RDRCText.87    = 'Error.  Invalid parameter. '
   RDRCText.108   = 'Error.  Drive locked. '
   RDRCText.206   = 'Error.  Filename exceeds range error. '

RETURN

