/* ----------------------------------------------------------
** SWUTILS.CMD
** The Secure Workplace
** Utilities Object Creation Program
** ---------------------------------------------------------*/
'@echo off'

/* ---------------------------------------------------------
** Load the REXX Utility functions
** --------------------------------------------------------*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ---------------------------------------------------------
** Create a Restricted Folder on the Desktop
** --------------------------------------------------------*/
class    = 'WPFolder'
setup    = 'OBJECTID=<SWU_MAIN>;'
title    = 'The Secure Workplace^Utilities'
location = '<WP_DESKTOP>'
result   = SysCreateObject(class, title, location, setup, 'U')

/* ---------------------------------------------------------
** Create the Object Editor
** --------------------------------------------------------*/
class    = "WPProgram"
location = "<SWU_MAIN>"
title    = "Object Editor"
setup    = "PROGTYPE=PM;EXENAME=objedit.exe;ASSOCFILTER=*.OMF;OBJECTID=<SWU_OBJECTEDITOR>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)

/* ---------------------------------------------------------
** Create an instance of the  Object Manager
** --------------------------------------------------------*/
class    = "SWObjMan"
location = "<SWU_MAIN>"
title    = "Object Manager"
setup    = "OBJECTID=<SWU_OBJECTMANAGER>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)

/* ---------------------------------------------------------
** Create the Image Backup program
** --------------------------------------------------------*/
class    = "WPProgram"
location = "<SWU_MAIN>"
title    = "Workplace Image Backup"
setup    = "EXENAME=WPBACKUP.CMD;PROGTYPE=FULLSCREEN;OBJECTID=<SWU_WPBACKUP>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)

/* ---------------------------------------------------------
** Create the Image Restore program
** --------------------------------------------------------*/
class    = "WPProgram"
location = "<SWU_MAIN>"
title    = "Workplace Image Restore"
setup    = "EXENAME=WPRESTOR.CMD;PROGTYPE=FULLSCREEN;"
setup    = setup || "OBJECTID=<SWU_WPRESTORE>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)

/* ---------------------------------------------------------
** Create the Shutdown program
** --------------------------------------------------------*/
class    = "WPProgram"
location = "<SWU_MAIN>"
title    = "System Shutdown"
setup    = "EXENAME=shutdown.exe;PARAMETERS=/NOLOGO /NOPROMPT;PROGTYPE=PM;"
setup    = setup || "OBJECTID=<SWU_SHUTDOWN>;"
action   = "R"
result   = SysCreateObject(class, title, location, setup, action)
/* ---------------------------------------------------------
** Create the Workplace Reset program
** --------------------------------------------------------*/
class    = "WPProgram"
location = "<SWU_MAIN>"
title    = "Workplace Reset"
setup    = "EXENAME=swreset.exe;PROGTYPE=PM;"
setup    = setup || "OBJECTID=<SWU_SWRESET>;"
action   R
result   = SysCreateObject(class, title, location, setup, action)

exit
