#ifndef _CHANNELC_H
#define _CHANNELC_H


#include <dnpap.h>
#include <mac.h>
#include <snmp.h>


typedef struct _CHANNEL
{
    LONG            Index;
    LONG            IfIndex;
    LONG            AcceptType;
    LONG            DataControl;
    LONG            TurnOnEventIndex;
    LONG            TurnOffEventIndex;
    LONG            EventIndex;
    LONG            EventStatus;
    LWORD           Matches;
    BYTE            Description[SNMP_SIZE_BUFCHR];
    WORD            DescriptionLen;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;
    MAC_COLL        Coll;
    MAC_IFACE       *Iface;

} CHANNEL;


BOOLEAN ChannelInit (CHANNEL *channel);
BOOLEAN ChannelStart (CHANNEL *channel);
BOOLEAN ChannelStop (CHANNEL *channel);


#endif
