#ifndef _HISTORY_C_H
#define _HISTORY_C_H


#include <dnpap.h>
#include <mac.h>
#include <snmp.h>
#include <timer.h>


#define MINALLOCENTRIES     4


typedef struct _ETHER_STATS
{
    ULONG           DropEvents;
    ULONG           Octets;
    ULONG           Pkts;
    ULONG           BroadcastPkts;
    ULONG           MulticastPkts;
    ULONG           CRCAlignErrors;
    ULONG           UndersizePkts;
    ULONG           OversizePkts;
    ULONG           Fragments;
    ULONG           Jabbers;
    ULONG           Collisions;

} ETHER_STATS;


typedef struct _ETHER_HISTORY
{
    ULONG           IntervalStart;
    ULONG           DropEvents;
    ULONG           Octets;
    ULONG           Pkts;
    ULONG           BroadcastPkts;
    ULONG           MulticastPkts;
    ULONG           CRCAlignErrors;
    ULONG           UndersizePkts;
    ULONG           OversizePkts;
    ULONG           Fragments;
    ULONG           Jabbers;
    ULONG           Collisions;
    ULONG           Utilization;

} ETHER_HISTORY;


typedef struct _HISTORY_CONTROL
{
    LONG            Index;
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    LONG            BucketsRequested;
    LONG            BucketsGranted;
    ULONG           Interval;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;

    LONG            BucketsAllocated;
    LONG            BucketsPos;
    BOOLEAN         BucketsWrapped;

    TIMER_DESCR     *Timer;
    BOOLEAN         FirstCall;

    MAC_IFACE       *Iface;

    ETHER_HISTORY   *EtherBuckets;

} HISTORY_CONTROL;


BOOLEAN HistoryConfigInit(VOID);

BOOLEAN HistoryCInit(HISTORY_CONTROL *historycontrol);
BOOLEAN HistoryCStart(HISTORY_CONTROL *historycontrol);
BOOLEAN HistoryCStop(HISTORY_CONTROL *historycontrol);

ETHER_HISTORY *EtherHistorySearch(HISTORY_CONTROL *historycontrol, SNMP_OBJECT *obj, WORD idlen);

ETHER_HISTORY *NewEtherHistory(LONG nrentries);
ETHER_HISTORY *ReNewEtherHistory(ETHER_HISTORY* ptr, LONG nrentries, LONG oldnrentries, LONG maxnrentries);
VOID           DelEtherHistory(ETHER_HISTORY* ptr);


#endif

