#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dnpap.h>
#include <message.h>
#include <snmp.h>
#include <mac.h>

#include "infoe.h"
#include "infoc.h"



/*****************************************************************
** NAME:        InfoInit
** SYNOPSIS:    BOOLEAN InfoInit (BEHOLDER_INFO *beholderInfo)
** PARAMETERS:  pointer to data beholderInfo entry
** DESCRIPTION: initializes collector.
** REMARKS:     called when status is CREATE_REQUEST: see infom.c
** RETURNS:     TRUE: everything OK
**              FALSE: or net not initialized
*******************************************************************/

BOOLEAN InfoInit (BEHOLDER_INFO *beholderInfo)
{
LONG source[] = {1,3,6,1,2,1,2,2,1,1,1};
    
    beholderInfo->SourceLen = sizeof(source)/sizeof(source[0]);
    memcpy (beholderInfo->Source, source, sizeof(source));

    if ((beholderInfo->Iface =
        MacIfaceGet((WORD) beholderInfo->Source[beholderInfo->SourceLen-1])) == NULL)
    {
        DnpapMessage(DMC_ERROR, INFO_NETINIT, "beholderInfo: network init");
        return FALSE;
    }
    return TRUE;
}


/*****************************************************************
** NAME:        InfoStart
** SYNOPSIS:    BOOLEAN InfoStart (BEHOLDER_INFO *beholderInfo)
** PARAMETERS:  pointer to data beholderInfo entry
** DESCRIPTION: starts collector.
** REMARKS:     called when status is VALID: see infom.c
** RETURNS:     TRUE: everything OK
*******************************************************************/

BOOLEAN InfoStart (BEHOLDER_INFO *beholderInfo)
{
    MacStatistics(beholderInfo->Iface, &beholderInfo->BaseStat);
    return TRUE;
}

/*****************************************************************
** NAME:        InfoStop
** SYNOPSIS:    BOOLEAN InfoStop (BEHOLDER_INFO *beholderInfo)
** PARAMETERS:  pointer to data beholderInfo entry
** DESCRIPTION: stops collector.
** REMARKS:     called when status is INVALID: see infom.c
** RETURNS:     TRUE
*******************************************************************/

BOOLEAN InfoStop (BEHOLDER_INFO *beholderInfo)
{
    return TRUE;
}
