#ifndef _MATRIX_C_H
#define _MATRIX_C_H


#include <dnpap.h>
#include <snmp.h>

#include "hash.h"


typedef struct _SRCDST
{
    BYTE        SrcDst[2*HOST_SZEADDR];
    LWORD       Pkts;
    LWORD       Octets;
    LWORD       Errors;

    struct _SRCDST  *SrcDstPrev;
    struct _SRCDST  *SrcDstNext;
    
    struct _SRCDST  *DstSrcPrev;
    struct _SRCDST  *DstSrcNext;

    struct _SRCDST  *LRUPrev;
    struct _SRCDST  *LRUNext;
    
} SRCDST;


typedef struct _MATRIX_CONTROL
{
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    LONG            TableSize;
    ULONG           LastDeleteTime;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;
    
    MAC_COLL        Coll;
    MAC_IFACE       *Iface;
    
	HashTable		*Table;
	
	SRCDST			*SrcDstList;
	SRCDST			*DstSrcList;

    SRCDST          *LRUList;
    SRCDST          *LRULast;
    
} MATRIX_CONTROL;


BOOLEAN MatrixConfigInit(VOID);

BOOLEAN MatrixCInit(MATRIX_CONTROL *matrixcontrol);
BOOLEAN MatrixCStart(MATRIX_CONTROL *matrixcontrol);
BOOLEAN MatrixCStop(MATRIX_CONTROL *matrixcontrol);

SRCDST* MatrixHashSearch(MATRIX_CONTROL *matrixcontrol, BYTE *srcdst, WORD len, BOOLEAN SDorder);
SRCDST* MatrixHashSearch2(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN SDorder);


#endif

