#ifndef _NEURO_K_H
#define _NEURO_K_H


#include <dnpap.h>
#include <stdarg.h>

#include "neuro_e.h"



#define NEURO_MAXOUTPUT       1
#define NEURO_MINOUTPUT       -1
#define NEURO_MAXMINOUTPUT    2
#define NEURO_MAXWEIGHT       10
#define NEURO_MINWEIGHT       -10


#ifdef __unix__
#define srand(seed)	srand48(seed)
#define random(num)	(lrand48() % (num))
#endif


	
typedef struct Weight_
{
        LONG fromlayer;
        LONG fromneuron;

        FLOAT value;

        FLOAT delta;
        FLOAT prvdelta;

} Weight;



typedef struct Neuron_  Neuron;

typedef FLOAT (*OutputFunction)(Neuron* neuron);

struct Neuron_
{
        FLOAT output;
        FLOAT activation;

        FLOAT bias;
	FLOAT dbias;
	FLOAT prvdbias;
	
        FLOAT delta;

        OutputFunction func;
        OutputFunction dfunc;

        LONG nrweights;
        Weight* weights;
};



typedef struct NeuronLayer_
{
        LONG nrneurons;
        Neuron* neurons;

} NeuronLayer;



typedef struct NeuronNet_
{
        LONG nrlayers;
        NeuronLayer* layers;

} NeuronNet;



typedef struct InOutput_
{
        LONG inoutnr;
        FLOAT value;

} InOutput;



NeuronNet*      NewNeuronNet(UNSIGNED seed, LONG nrlayers, ...);
void            DelNeuronNet(NeuronNet* net);

InOutput*   NewNeuronInOutput(LONG size);
void		DelNeuronInOutput(InOutput* inout);

LONG     CalcNeuronNet(NeuronNet* net,
                              InOutput in[], LONG nrin,
                              InOutput out[], LONG nrout,
                              BOOLEAN train, BOOLEAN update,
			      FLOAT lambda, FLOAT mu);
LONG	CalcNeuronNetError(NeuronNet* net, 
				   InOutput out[], LONG nrout,
				   FLOAT* error);


#endif
