#ifndef _DHOSTX_H
#define _DHOSTX_H


#include <dnpap.h>


#define HOST_SZEADDR    6


typedef struct _DNPAP_HOST
{
    BYTE        Address[HOST_SZEADDR];
    ULONG       InPkts;
    ULONG       OutPkts;
    ULONG       InOctets;
    ULONG       OutOctets;
    ULONG       OutErrors;
    ULONG       OutBroadcastPkts;
    ULONG       OutMulticastPkts;

    /* DNPAP additions  */
    ULONG       *IATBuckets;
    ULONG       *ISTBuckets;
    ULONG       InBucket1Pkts;
    ULONG       InBucket2Pkts;
    ULONG       InBucket3Pkts;
    ULONG       InBucket4Pkts;
    ULONG       InBucket5Pkts;
    ULONG       InBucket6Pkts;
    ULONG       OutBucket1Pkts;
    ULONG       OutBucket2Pkts;
    ULONG       OutBucket3Pkts;
    ULONG       OutBucket4Pkts;
    ULONG       OutBucket5Pkts;
    ULONG       OutBucket6Pkts;
    ULONG       InTCPPkts;
    ULONG       OutTCPPkts;
    ULONG       InOtherPkts;
    ULONG       OutOtherPkts;

    ULONG       IATTime;
    ULONG       ISTTime;

    struct _DNPAP_HOST  *LexPrev;
    struct _DNPAP_HOST  *LexNext;

	struct _DNPAP_HOST  *TimePrev;    
	struct _DNPAP_HOST  *TimeNext;    
    
    struct _DNPAP_HOST  *LRUPrev;
    struct _DNPAP_HOST  *LRUNext;
    
    struct _DNPAP_HOST  **TimeListPtr;
    
} DNPAP_HOST;


#endif
