#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dnpap.h>
#include <message.h>
#include <mac.h>
#include <timer.h>
#include <protocol.h>

#include "dstate.h"
#include "dstatc.h"


static VOID StatMacCallback(MAC_COLL *collector, PROT_PKT *pkt);



BOOLEAN DnpapStatCInit (DNPAP_ETHER_STATS *etherStats)
{
LONG source[] = {1,3,6,1,2,1,2,2,1,1,1};
    
    etherStats->SourceLen = sizeof(source)/sizeof(long);
    memcpy (etherStats->Source, source, sizeof(source));

    if ((etherStats->Iface =
        MacIfaceGet((WORD) etherStats->Source[etherStats->SourceLen-1])) == NULL)
    {
        DnpapMessage(DMC_ERROR, DSTAT_NETINIT, "detherStat: network initialization failed");
        return (FALSE);
    }
    return TRUE;
}

BOOLEAN DnpapStatCStart (DNPAP_ETHER_STATS *etherStats)
{
    etherStats->Coll.Rcve       = StatMacCallback;
    etherStats->Coll.specific   = etherStats;
    if (!MacCollRegister(&(etherStats->Coll)))
    {
        DnpapMessage(DMC_ERROR, DSTAT_NETINIT, "detherStat: network initialization failed");
        return (FALSE);
    }

    MacStatistics(etherStats->Iface, &etherStats->BaseStat);

    etherStats->Octets = 0; 
    etherStats->Pkts = 0; 
    etherStats->Pkts64Octets = 0; 
    etherStats->Pkts65to127Octets = 0; 
    etherStats->Pkts128to255Octets = 0; 
    etherStats->Pkts256to511Octets = 0;
    etherStats->Pkts512to1023Octets = 0;
    etherStats->Pkts1024to1518Octets = 0;

	etherStats->IATNrBuckets = 10;
	etherStats->IATInterval = 1000;
	if ((etherStats->IATBuckets = NewBuckets(etherStats->IATNrBuckets)) == NULL)
		return FALSE;

	etherStats->IATTime = 0;
		
    return TRUE;
}

BOOLEAN DnpapStatCStop (DNPAP_ETHER_STATS *etherStats)
{
    MacCollRemove(&(etherStats->Coll));
    DelBuckets(etherStats->IATBuckets);
    return TRUE;
}

ULONG *NewBuckets(LONG nrbuckets)
{
	return DnpapMalloc(nrbuckets*sizeof(ULONG));
}

ULONG *ReNewBuckets(ULONG *buckets, LONG nrbuckets)
{
	return DnpapRealloc(buckets, nrbuckets*sizeof(ULONG));
}

VOID DelBuckets(ULONG *buckets)
{
	return DnpapFree(buckets);
}

VOID StatMacCallback(MAC_COLL *collector, PROT_PKT *pkt)
{
PROT_OBJ Interface = {1, {1,2}};
PROT_OBJ Size = {1, {1,4}};
PROT_OBJ Time = {1, {1,6}};
ULONG size;
ULONG time;
LONG iat, iatindex;
DNPAP_ETHER_STATS *etherStats = collector->specific;

    if (ProtGetField(pkt,&Interface) == TRUE &&
        Interface.Syntax.LngInt == etherStats->Source[etherStats->SourceLen-1])
    {
        if (ProtGetField(pkt,&Size) == TRUE &&
        	ProtGetField(pkt,&Time) == TRUE)
        {
        	etherStats->Pkts++;
        	
            size = Size.Syntax.LngUns + 4L;
            etherStats->Octets += size;
            if (size == 64)
                etherStats->Pkts64Octets++;
            if (size >= 65)
            {
                if (size <= 127)
                    etherStats->Pkts65to127Octets++;
                else if (size <= 255)
                    etherStats->Pkts128to255Octets++; 
                else if (size <= 511)
                    etherStats->Pkts256to511Octets++;
                else if (size <= 1023)
                    etherStats->Pkts512to1023Octets++;
                else if (size <= 1518)
                    etherStats->Pkts1024to1518Octets++;
            }
            
			time = Time.Syntax.LngUns;
			if (etherStats->IATTime == 0)
				etherStats->IATTime = time;
			else
			{
	            iat = time - etherStats->IATTime;
	            etherStats->IATTime = time;
	            iatindex = iat/etherStats->IATInterval;
	            if (iatindex >= etherStats->IATNrBuckets)
	                iatindex = etherStats->IATNrBuckets-1;
	            etherStats->IATBuckets[iatindex]++;
			}
        }
    }

    return;
}                       
