!include ..\..\include\standard.mak

SYS     = mib
SYSLIB  = b2

all: obj doc

install: all $(INCDIR)\$(SYS)sup.h $(INCDIR)\$(SYS)rqs.h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS)sup.h: $(SYS)sup.h
	$(CP) $(SYS)sup.h $(INCDIR)\$(SYS)sup.h

$(INCDIR)\$(SYS)rqs.h: $(SYS)rqs.h
	$(CP) $(SYS)rqs.h $(INCDIR)\$(SYS)rqs.h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj;

obj: $(SYS).obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c
    $(MAN) -R:API  $(SYS).c > $(SYS).man

$(SYS).obj: $(SYS).c $(SYS)rqs.h $(SYS)sup.h

test.exe: test.obj test.ini
	$(LINK) test.obj $(SYSLIB)
	markexe windowcompat test.exe

