#include <stddef.h> 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"

BYTE *protTCPString[]=
{
    "SOURCE_PORT",           
    "DESTINATION_PORT",      
    "SEQUENCE_NUMBER",       
    "ACKNOWLEDGEMENT_NUMBER",
    "HLEN",                  
    "RESERVED",              
    "CODE_BITS",             
    "WINDOW",                
    "CHECKSUM",              
    "URGENT_POINTER",       
    "OPTIONS"
};

static WORD HLen;

BOOLEAN ProtTCPHeader (PROT_PKT *Pkt)
{
    LWORD Child;

    if (Pkt->DataLen < 20)
        return (FALSE);
    if ((Pkt->Frame = DnpapMalloc (sizeof(PROT_TCP))) == NULL)
        return (FALSE);
    Pkt->Frame->Tcp.SrcPort = Pkt->Ptr;
    Pkt->Frame->Tcp.DstPort = Pkt->Ptr + 2;
    Pkt->Frame->Tcp.SeqNr = Pkt->Ptr + 4;
    Pkt->Frame->Tcp.AckNr = Pkt->Ptr + 8;
    Pkt->Frame->Tcp.HLen = Pkt->Ptr + 12;

    HLen = 4 * (WORD)(*(Pkt->Frame->Tcp.HLen) >> 4);
    if (Pkt->DataLen < HLen)
        return (FALSE);

    Pkt->Frame->Tcp.Reserved = Pkt->Ptr + 12;
    Pkt->Frame->Tcp.Code = Pkt->Ptr + 13;
    Pkt->Frame->Tcp.Window = Pkt->Ptr + 14;
    Pkt->Frame->Tcp.ChkSum = Pkt->Ptr + 16;
    Pkt->Frame->Tcp.UrgePtr = Pkt->Ptr + 18;
    Pkt->Frame->Tcp.Option = Pkt->Ptr + 20;
    Pkt->Frame->Tcp.Data = Pkt->Ptr + HLen;

    PROT_NETWORD (Child,Pkt->Frame->Tcp.DstPort)

    switch(Child)
    {
        case 53:
            Pkt->ChildProt = PROT_PKTDNS;
            break;
        default:
            Pkt->ChildProt = PROT_PKTUNKNOWN;
    }
    return (TRUE);
}

BOOLEAN ProtTCPField (PROT_PKT *Pkt, PROT_OBJ *Obj)
{
    LWORD Reserved;

    if (Obj->Level == 0 && Obj->Id[1] == PROT_TYPE)
    {
        Obj->Type = SNMP_GAUGE;
        Obj->Syntax.LngUns = Pkt->ChildProt;
        return (TRUE);
    }

    if (Obj->Id[0] == PROT_PKTTCP)
    {
        switch (Obj->Id[1])
        {
            case 1:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Tcp.SrcPort)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 2:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Tcp.DstPort)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 3:
                Obj->Type = SNMP_GAUGE;
                PROT_NETLWORD(Obj->Syntax.LngUns,Pkt->Frame->Tcp.SeqNr);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 4:
                Obj->Type = SNMP_GAUGE;
                PROT_NETLWORD(Obj->Syntax.LngUns,Pkt->Frame->Tcp.AckNr);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 5:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Tcp.HLen);
                Obj->Syntax.LngUns >>= 4;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 6:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD)(*(Pkt->Frame->Tcp.Reserved) & 0x0F);
                Obj->Syntax.LngUns <<= 2;
                Reserved = (LWORD) (*(Pkt->Frame->Tcp.Reserved + 1) & 0xC0);
                Reserved >>= 6;
                Obj->Syntax.LngUns |= Reserved;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 7:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) (*(Pkt->Frame->Tcp.Code) & 0x3F);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 8:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Tcp.Window);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 9:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Tcp.ChkSum);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 10:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns,Pkt->Frame->Tcp.UrgePtr);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 11:
                Obj->Type = SNMP_OCTETSTR;           /* only total option field */
                Obj->SyntaxLen = 4 * (*(Pkt->Frame->Tcp.HLen) >> 4) - 20;
                memcpy(Obj->Syntax.BufChr, Pkt->Frame->Tcp.Option, Obj->SyntaxLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 12:
                Obj->Type = SNMP_NULL;
                if (Pkt->DataLen <= HLen)
                    Obj->SyntaxLen = 0;
                else
                    Obj->SyntaxLen = Pkt->DataLen - HLen;
                Obj->Syntax.Ptr = Pkt->Frame->Tcp.Data;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            default:
                return (FALSE);
        }
    }

    if (Obj->Level > 0 && Pkt->ChildProt != PROT_PKTUNKNOWN)
    {
        if (Pkt->Child == NULL)
        {
            if ((Pkt->Child = DnpapMalloc (sizeof(PROT_PKT))) == NULL)
                return (FALSE);
            Pkt->Child->Ptr = Pkt->Frame->Tcp.Data;
            Pkt->Child->Child = NULL;
            Pkt->Child->DataLen = Pkt->DataLen - HLen;
            if ((ProtPtr[Pkt->ChildProt].Header(Pkt->Child)) == FALSE)
            {
                DnpapFree(Pkt->Child);
                return (FALSE);
            }
        }
        Obj->Level--;
        return (ProtPtr[Pkt->ChildProt].Field (Pkt->Child, Obj));
    }
    return (FALSE);
}

BOOLEAN ProtTCPPrint (PROT_OBJ *Obj, BYTE **StrPtr)
{
    WORD Ind;
    BYTE Char[4];

    switch (Obj->Id[1])
    {
        case 1:                                 /* Src Port */
        case 2:                                 /* Dst Port */
        case 8:                                 /* Window */
            sprintf(protocolString, "%6lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 3:                                 /* Seq Nr */
        case 4:                                 /* Ack Nr */
            sprintf(protocolString, "%12lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 5:                                 /* HLen */
            sprintf(protocolString, "%2lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 6:                                 /* Reserved */
        case 7:                                 /* Code */
            sprintf(protocolString, "%01lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 9:                                 /* ChkSum */
        case 10:                                /* Urgent Ptr */
            sprintf(protocolString, "%4lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 11:                                /* Options */
            *protocolString = '\0';
            for (Ind = 0; Ind < Obj->SyntaxLen; Ind++)
            {
                sprintf(Char, "%02x",Obj->Syntax.BufChr[Ind]);
                strcat(protocolString, Char);
            }
            *StrPtr = protocolString;
            return (TRUE);
        default:
            return (FALSE);
    }
}
