#include <stdio.h>
#include <config.h>
#include "ip.h"
#include "iprcve.h"





MAC_PROT ipMac =
{
    IpRcve,
    MAC_PROT_IP
};






BOOLEAN IpInit(void)
{
    BYTE            name[255];
    BYTE            *descr;
    DWORD           dest, mask, nextHop;
    WORD            i, metric;
    IP_IFACE        *ip;
    MAC_IFACE       *mac;
    static BOOLEAN  init = FALSE;
    
    if (!init)
    {
        i = 1;
        sprintf(name, "ip.iface.name.%d", i);
        while (ConfigGetString(name, &descr))
        {
            mac = MacIfaceFind(descr);
            if (mac!=0)
            {
                ip = DnpapMalloc(sizeof(IP_IFACE));
                if (ip!=0)
                {
                    ip->iface = mac;
            
                    sprintf(name, "ip.iface.addr.%d", i);
                    ConfigGetIPAddr(name, &ip->addr);
            
                    sprintf(name, "ip.iface.mask.%d", i);
                    ConfigGetIPAddr(name, &ip->mask);

                    ip->up = TRUE;
                    sprintf(name, "ip.iface.up.%d", i);
                    ConfigGetBoolean(name, &ip->up);
            
                    IpIfaceRegister(ip);
                }
            }
            
            i++;
            sprintf(name, "ip.iface.name.%d", i);
        }
        
        i = 1;
        sprintf(name, "ip.route.dest.%d", i);
        while (ConfigGetIPAddr(name, &dest))
        {
            sprintf(name, "ip.route.mask.%d", i);
            ConfigGetIPAddr(name, &mask);
            
            sprintf(name, "ip.route.nextHop.%d", i);
            ConfigGetIPAddr(name, &nextHop);
            
            sprintf(name, "ip.route.iface.%d", i);
            ConfigGetString(name, &descr);
            
            metric = 255;
            sprintf(name, "ip.route.metric.%d", i);
            ConfigGetShort(name, &metric);

            mac = MacIfaceFind(descr);
            if (mac!=0)
                IpRouteAdd(dest, mask, nextHop, mac, metric);
            
            i++;
            sprintf(name, "ip.route.dest.%d", i);
        }
        
        init = MacProtRegister(&ipMac);
    }

    return init;
}


